/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.digests.RomulusDigest;
import org.bouncycastle.crypto.engines.AEADBaseEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;

public class RomulusEngine
extends AEADBaseEngine {
    private byte[] k;
    private byte[] npub;
    private static final int AD_BLK_LEN_HALF = 16;
    private Instance instance;
    private final byte[] CNT;
    private static final byte[] sbox_8 = new byte[]{101, 76, 106, 66, 75, 99, 67, 107, 85, 117, 90, 122, 83, 115, 91, 123, 53, -116, 58, -127, -119, 51, -128, 59, -107, 37, -104, 42, -112, 35, -103, 43, -27, -52, -24, -63, -55, -32, -64, -23, -43, -11, -40, -8, -48, -16, -39, -7, -91, 28, -88, 18, 27, -96, 19, -87, 5, -75, 10, -72, 3, -80, 11, -71, 50, -120, 60, -123, -115, 52, -124, 61, -111, 34, -100, 44, -108, 36, -99, 45, 98, 74, 108, 69, 77, 100, 68, 109, 82, 114, 92, 124, 84, 116, 93, 125, -95, 26, -84, 21, 29, -92, 20, -83, 2, -79, 12, -68, 4, -76, 13, -67, -31, -56, -20, -59, -51, -28, -60, -19, -47, -15, -36, -4, -44, -12, -35, -3, 54, -114, 56, -126, -117, 48, -125, 57, -106, 38, -102, 40, -109, 32, -101, 41, 102, 78, 104, 65, 73, 96, 64, 105, 86, 118, 88, 120, 80, 112, 89, 121, -90, 30, -86, 17, 25, -93, 16, -85, 6, -74, 8, -70, 0, -77, 9, -69, -26, -50, -22, -62, -53, -29, -61, -21, -42, -10, -38, -6, -45, -13, -37, -5, 49, -118, 62, -122, -113, 55, -121, 63, -110, 33, -98, 46, -105, 39, -97, 47, 97, 72, 110, 70, 79, 103, 71, 111, 81, 113, 94, 126, 87, 119, 95, 127, -94, 24, -82, 22, 31, -89, 23, -81, 1, -78, 14, -66, 7, -73, 15, -65, -30, -54, -18, -58, -49, -25, -57, -17, -46, -14, -34, -2, -41, -9, -33, -1};
    private static final byte[] TWEAKEY_P = new byte[]{9, 15, 8, 13, 10, 14, 12, 11, 0, 1, 2, 3, 4, 5, 6, 7};
    private static final byte[] RC = new byte[]{1, 3, 7, 15, 31, 62, 61, 59, 55, 47, 30, 60, 57, 51, 39, 14, 29, 58, 53, 43, 22, 44, 24, 48, 33, 2, 5, 11, 23, 46, 28, 56, 49, 35, 6, 13, 27, 54, 45, 26};

    public RomulusEngine(RomulusParameters romulusParameters) {
        this.AADBufferSize = 16;
        this.BlockSize = 16;
        this.MAC_SIZE = 16;
        this.IV_SIZE = 16;
        this.KEY_SIZE = 16;
        this.CNT = new byte[7];
        switch (romulusParameters.ord) {
            case 0: {
                this.algorithmName = "Romulus-M";
                this.instance = new RomulusM();
                break;
            }
            case 1: {
                this.algorithmName = "Romulus-N";
                this.instance = new RomulusN();
                break;
            }
            case 2: {
                this.algorithmName = "Romulus-T";
                this.AADBufferSize = 32;
                this.instance = new RomulusT();
            }
        }
        this.setInnerMembers(romulusParameters == RomulusParameters.RomulusN ? AEADBaseEngine.ProcessingBufferType.Buffered : AEADBaseEngine.ProcessingBufferType.Immediate, AEADBaseEngine.AADOperatorType.Counter, romulusParameters == RomulusParameters.RomulusM ? AEADBaseEngine.DataOperatorType.Stream : AEADBaseEngine.DataOperatorType.Counter);
    }

    private static void skinny_128_384_plus_enc(byte[] input, byte[] userkey) {
        int q;
        int i;
        byte[][] state = new byte[4][4];
        byte[][][] keyCells = new byte[3][4][4];
        byte[][][] keyCells_tmp = new byte[3][4][4];
        for (i = 0; i < 4; ++i) {
            q = i << 2;
            System.arraycopy(input, q, state[i], 0, 4);
            System.arraycopy(userkey, q, keyCells[0][i], 0, 4);
            System.arraycopy(userkey, q + 16, keyCells[1][i], 0, 4);
            System.arraycopy(userkey, q + 32, keyCells[2][i], 0, 4);
        }
        for (int round = 0; round < 40; ++round) {
            byte tmp;
            int j;
            for (i = 0; i < 4; ++i) {
                for (j = 0; j < 4; ++j) {
                    state[i][j] = sbox_8[state[i][j] & 0xFF];
                }
            }
            byte[] byArray = state[0];
            byArray[0] = (byte)(byArray[0] ^ RC[round] & 0xF);
            byte[] byArray2 = state[1];
            byArray2[0] = (byte)(byArray2[0] ^ RC[round] >>> 4 & 3);
            byte[] byArray3 = state[2];
            byArray3[0] = (byte)(byArray3[0] ^ 2);
            for (i = 0; i <= 1; ++i) {
                for (j = 0; j < 4; ++j) {
                    byte[] byArray4 = state[i];
                    int n = j;
                    byArray4[n] = (byte)(byArray4[n] ^ (keyCells[0][i][j] ^ keyCells[1][i][j] ^ keyCells[2][i][j]));
                }
            }
            for (i = 0; i < 4; ++i) {
                for (j = 0; j < 4; ++j) {
                    byte pos = TWEAKEY_P[j + (i << 2)];
                    q = pos >>> 2;
                    int r = pos & 3;
                    keyCells_tmp[0][i][j] = keyCells[0][q][r];
                    keyCells_tmp[1][i][j] = keyCells[1][q][r];
                    keyCells_tmp[2][i][j] = keyCells[2][q][r];
                }
            }
            for (i = 0; i <= 1; ++i) {
                for (j = 0; j < 4; ++j) {
                    keyCells[0][i][j] = keyCells_tmp[0][i][j];
                    tmp = keyCells_tmp[1][i][j];
                    keyCells[1][i][j] = (byte)(tmp << 1 & 0xFE ^ tmp >>> 7 & 1 ^ tmp >>> 5 & 1);
                    tmp = keyCells_tmp[2][i][j];
                    keyCells[2][i][j] = (byte)(tmp >>> 1 & 0x7F ^ tmp << 7 & 0x80 ^ tmp << 1 & 0x80);
                }
            }
            while (i < 4) {
                for (j = 0; j < 4; ++j) {
                    keyCells[0][i][j] = keyCells_tmp[0][i][j];
                    keyCells[1][i][j] = keyCells_tmp[1][i][j];
                    keyCells[2][i][j] = keyCells_tmp[2][i][j];
                }
                ++i;
            }
            tmp = state[1][3];
            state[1][3] = state[1][2];
            state[1][2] = state[1][1];
            state[1][1] = state[1][0];
            state[1][0] = tmp;
            tmp = state[2][0];
            state[2][0] = state[2][2];
            state[2][2] = tmp;
            tmp = state[2][1];
            state[2][1] = state[2][3];
            state[2][3] = tmp;
            tmp = state[3][0];
            state[3][0] = state[3][1];
            state[3][1] = state[3][2];
            state[3][2] = state[3][3];
            state[3][3] = tmp;
            for (j = 0; j < 4; ++j) {
                byte[] byArray5 = state[1];
                int n = j;
                byArray5[n] = (byte)(byArray5[n] ^ state[2][j]);
                byte[] byArray6 = state[2];
                int n2 = j;
                byArray6[n2] = (byte)(byArray6[n2] ^ state[0][j]);
                byte[] byArray7 = state[3];
                int n3 = j;
                byArray7[n3] = (byte)(byArray7[n3] ^ state[2][j]);
                tmp = state[3][j];
                state[3][j] = state[2][j];
                state[2][j] = state[1][j];
                state[1][j] = state[0][j];
                state[0][j] = tmp;
            }
        }
        for (i = 0; i < 16; ++i) {
            input[i] = (byte)(state[i >>> 2][i & 3] & 0xFF);
        }
    }

    void pad(byte[] m, int mOff, byte[] mp, int l, int len8) {
        mp[l - 1] = (byte)(len8 & 0xF);
        System.arraycopy(m, mOff, mp, 0, len8);
    }

    void g8A(byte[] s, byte[] c, int cOff) {
        int len = Math.min(c.length - cOff, 16);
        for (int i = 0; i < len; ++i) {
            c[i + cOff] = (byte)((s[i] & 0xFF) >>> 1 ^ s[i] & 0x80 ^ (s[i] & 1) << 7);
        }
    }

    void rho(byte[] m, int mOff, byte[] c, int cOff, byte[] s, int len8) {
        byte[] mp = new byte[16];
        this.pad(m, mOff, mp, 16, len8);
        this.g8A(s, c, cOff);
        if (this.forEncryption) {
            for (int i = 0; i < 16; ++i) {
                int n = i;
                s[n] = (byte)(s[n] ^ mp[i]);
                if (i < len8) {
                    int n2 = i + cOff;
                    c[n2] = (byte)(c[n2] ^ mp[i]);
                    continue;
                }
                c[i + cOff] = 0;
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                int n = i;
                s[n] = (byte)(s[n] ^ mp[i]);
                if (i >= len8 || i + cOff >= c.length) continue;
                int n3 = i;
                s[n3] = (byte)(s[n3] ^ c[i + cOff]);
                int n4 = i + cOff;
                c[n4] = (byte)(c[n4] ^ mp[i]);
            }
        }
    }

    void lfsr_gf56(byte[] CNT) {
        byte fb0 = (byte)((CNT[6] & 0xFF) >>> 7);
        CNT[6] = (byte)((CNT[6] & 0xFF) << 1 | (CNT[5] & 0xFF) >>> 7);
        CNT[5] = (byte)((CNT[5] & 0xFF) << 1 | (CNT[4] & 0xFF) >>> 7);
        CNT[4] = (byte)((CNT[4] & 0xFF) << 1 | (CNT[3] & 0xFF) >>> 7);
        CNT[3] = (byte)((CNT[3] & 0xFF) << 1 | (CNT[2] & 0xFF) >>> 7);
        CNT[2] = (byte)((CNT[2] & 0xFF) << 1 | (CNT[1] & 0xFF) >>> 7);
        CNT[1] = (byte)((CNT[1] & 0xFF) << 1 | (CNT[0] & 0xFF) >>> 7);
        CNT[0] = fb0 == 1 ? (byte)((CNT[0] & 0xFF) << 1 ^ 0x95) : (byte)((CNT[0] & 0xFF) << 1);
    }

    void block_cipher(byte[] s, byte[] K, byte[] T, int tOff, byte[] CNT, byte D) {
        byte[] KT = new byte[48];
        System.arraycopy(CNT, 0, KT, 0, 7);
        KT[7] = D;
        System.arraycopy(T, tOff, KT, 16, 16);
        System.arraycopy(K, 0, KT, 32, 16);
        RomulusEngine.skinny_128_384_plus_enc(s, KT);
    }

    private void reset_lfsr_gf56(byte[] CNT) {
        CNT[0] = 1;
        Arrays.fill(CNT, 1, 7, (byte)0);
    }

    public static void hirose_128_128_256(RomulusDigest.Friend friend, byte[] h, byte[] g, byte[] m, int mOff) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by RomulusDigest");
        }
        RomulusEngine.hirose_128_128_256(h, g, m, mOff);
    }

    static void hirose_128_128_256(byte[] h, byte[] g, byte[] m, int mOff) {
        byte[] key = new byte[48];
        byte[] hh = new byte[16];
        System.arraycopy(g, 0, key, 0, 16);
        System.arraycopy(h, 0, g, 0, 16);
        System.arraycopy(h, 0, hh, 0, 16);
        g[0] = (byte)(g[0] ^ 1);
        System.arraycopy(m, mOff, key, 16, 32);
        RomulusEngine.skinny_128_384_plus_enc(h, key);
        RomulusEngine.skinny_128_384_plus_enc(g, key);
        for (int i = 0; i < 16; ++i) {
            int n = i;
            h[n] = (byte)(h[n] ^ hh[i]);
            int n2 = i;
            g[n2] = (byte)(g[n2] ^ hh[i]);
        }
        g[0] = (byte)(g[0] ^ 1);
    }

    @Override
    protected void init(byte[] key, byte[] iv) throws IllegalArgumentException {
        this.npub = iv;
        this.k = key;
    }

    @Override
    protected void finishAAD(AEADBaseEngine.State nextState, boolean isDoFinal) {
        this.finishAAD1(nextState);
    }

    @Override
    protected void processBufferAAD(byte[] input, int inOff) {
        this.instance.processBufferAAD(input, inOff);
    }

    @Override
    protected void processFinalAAD() {
        this.instance.processFinalAAD();
    }

    @Override
    protected void processFinalBlock(byte[] output, int outOff) {
        this.instance.processFinalBlock(output, outOff);
    }

    @Override
    protected void processBufferEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.instance.processBufferEncrypt(input, inOff, output, outOff);
    }

    @Override
    protected void processBufferDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.instance.processBufferDecrypt(input, inOff, output, outOff);
    }

    @Override
    protected void reset(boolean clearMac) {
        super.reset(clearMac);
        this.instance.reset();
    }

    private static interface Instance {
        public void processFinalBlock(byte[] var1, int var2);

        public void processBufferAAD(byte[] var1, int var2);

        public void processFinalAAD();

        public void processBufferEncrypt(byte[] var1, int var2, byte[] var3, int var4);

        public void processBufferDecrypt(byte[] var1, int var2, byte[] var3, int var4);

        public void reset();
    }

    private class RomulusM
    implements Instance {
        private final byte[] mac_s = new byte[16];
        private final byte[] mac_CNT = new byte[7];
        private final byte[] s = new byte[16];
        private int offset;
        private boolean twist = true;

        @Override
        public void processFinalBlock(byte[] output, int outOff) {
            int len8;
            byte[] Temp;
            byte w = 48;
            int adlen = RomulusEngine.this.aadOperator.getLen();
            int mlen = RomulusEngine.this.dataOperator.getLen() - (RomulusEngine.this.forEncryption ? 0 : RomulusEngine.this.MAC_SIZE);
            byte[] m = ((AEADBaseEngine.StreamDataOperator)RomulusEngine.this.dataOperator).getBytes();
            int mOff = 0;
            int mauth = outOff;
            int xlen = mlen;
            if ((adlen & 0x1F) == 0 && adlen != 0) {
                w = (byte)(w ^ 8);
            } else if ((adlen & 0x1F) < 16) {
                w = (byte)(w ^ 2);
            } else if ((adlen & 0x1F) != 16) {
                w = (byte)(w ^ 0xA);
            }
            if ((mlen & 0x1F) == 0 && mlen != 0) {
                w = (byte)(w ^ 4);
            } else if ((mlen & 0x1F) < 16) {
                w = (byte)(w ^ 1);
            } else if ((mlen & 0x1F) != 16) {
                w = (byte)(w ^ 5);
            }
            if (RomulusEngine.this.forEncryption) {
                if ((w & 8) == 0) {
                    Temp = new byte[16];
                    len8 = Math.min(xlen, 16);
                    xlen -= len8;
                    RomulusEngine.this.pad(m, mOff, Temp, 16, len8);
                    RomulusEngine.this.block_cipher(this.mac_s, RomulusEngine.this.k, Temp, 0, this.mac_CNT, (byte)44);
                    RomulusEngine.this.lfsr_gf56(this.mac_CNT);
                    mOff += len8;
                } else if (mlen == 0) {
                    RomulusEngine.this.lfsr_gf56(this.mac_CNT);
                }
                while (xlen > 0) {
                    this.offset = mOff;
                    xlen = this.ad_encryption(m, mOff, this.mac_s, RomulusEngine.this.k, xlen, this.mac_CNT);
                    mOff = this.offset;
                }
                RomulusEngine.this.block_cipher(this.mac_s, RomulusEngine.this.k, RomulusEngine.this.npub, 0, this.mac_CNT, w);
                RomulusEngine.this.g8A(this.mac_s, RomulusEngine.this.mac, 0);
                mOff -= mlen;
            } else {
                System.arraycopy(m, mlen, RomulusEngine.this.mac, 0, RomulusEngine.this.MAC_SIZE);
            }
            RomulusEngine.this.reset_lfsr_gf56(RomulusEngine.this.CNT);
            System.arraycopy(RomulusEngine.this.mac, 0, this.s, 0, 16);
            if (mlen > 0) {
                RomulusEngine.this.block_cipher(this.s, RomulusEngine.this.k, RomulusEngine.this.npub, 0, RomulusEngine.this.CNT, (byte)36);
                while (mlen > 16) {
                    mlen -= 16;
                    RomulusEngine.this.rho(m, mOff, output, outOff, this.s, 16);
                    outOff += 16;
                    mOff += 16;
                    RomulusEngine.this.lfsr_gf56(RomulusEngine.this.CNT);
                    RomulusEngine.this.block_cipher(this.s, RomulusEngine.this.k, RomulusEngine.this.npub, 0, RomulusEngine.this.CNT, (byte)36);
                }
                RomulusEngine.this.rho(m, mOff, output, outOff, this.s, mlen);
            }
            if (!RomulusEngine.this.forEncryption) {
                if ((w & 8) == 0) {
                    Temp = new byte[16];
                    len8 = Math.min(xlen, 16);
                    xlen -= len8;
                    RomulusEngine.this.pad(output, mauth, Temp, 16, len8);
                    RomulusEngine.this.block_cipher(this.mac_s, RomulusEngine.this.k, Temp, 0, this.mac_CNT, (byte)44);
                    RomulusEngine.this.lfsr_gf56(this.mac_CNT);
                    mauth += len8;
                } else if (mlen == 0) {
                    RomulusEngine.this.lfsr_gf56(this.mac_CNT);
                }
                while (xlen > 0) {
                    this.offset = mauth;
                    xlen = this.ad_encryption(output, mauth, this.mac_s, RomulusEngine.this.k, xlen, this.mac_CNT);
                    mauth = this.offset;
                }
                RomulusEngine.this.block_cipher(this.mac_s, RomulusEngine.this.k, RomulusEngine.this.npub, 0, this.mac_CNT, w);
                RomulusEngine.this.g8A(this.mac_s, RomulusEngine.this.mac, 0);
                System.arraycopy(m, RomulusEngine.this.dataOperator.getLen() - RomulusEngine.this.MAC_SIZE, RomulusEngine.this.m_buf, 0, RomulusEngine.this.MAC_SIZE);
                RomulusEngine.this.m_bufPos = 0;
            }
        }

        int ad_encryption(byte[] A, int AOff, byte[] s, byte[] k, int adlen, byte[] CNT) {
            byte[] T = new byte[16];
            byte[] mp = new byte[16];
            int n = 16;
            int len8 = Math.min(adlen, n);
            RomulusEngine.this.pad(A, AOff, mp, n, len8);
            Bytes.xorTo(n, mp, s);
            this.offset = AOff += len8;
            RomulusEngine.this.lfsr_gf56(CNT);
            if ((adlen -= len8) != 0) {
                len8 = Math.min(adlen, n);
                adlen -= len8;
                RomulusEngine.this.pad(A, AOff, T, n, len8);
                this.offset = AOff + len8;
                RomulusEngine.this.block_cipher(s, k, T, 0, CNT, (byte)44);
                RomulusEngine.this.lfsr_gf56(CNT);
            }
            return adlen;
        }

        @Override
        public void processBufferAAD(byte[] input, int inOff) {
            if (this.twist) {
                Bytes.xorTo(RomulusEngine.this.MAC_SIZE, input, inOff, this.mac_s);
            } else {
                RomulusEngine.this.block_cipher(this.mac_s, RomulusEngine.this.k, input, inOff, this.mac_CNT, (byte)40);
            }
            this.twist = !this.twist;
            RomulusEngine.this.lfsr_gf56(this.mac_CNT);
        }

        @Override
        public void processFinalAAD() {
            if (RomulusEngine.this.aadOperator.getLen() == 0) {
                RomulusEngine.this.lfsr_gf56(this.mac_CNT);
            } else if (RomulusEngine.this.m_aadPos != 0) {
                Arrays.fill(RomulusEngine.this.m_aad, RomulusEngine.this.m_aadPos, RomulusEngine.this.BlockSize - 1, (byte)0);
                RomulusEngine.this.m_aad[RomulusEngine.this.BlockSize - 1] = (byte)(RomulusEngine.this.m_aadPos & 0xF);
                if (this.twist) {
                    Bytes.xorTo(RomulusEngine.this.BlockSize, RomulusEngine.this.m_aad, this.mac_s);
                } else {
                    RomulusEngine.this.block_cipher(this.mac_s, RomulusEngine.this.k, RomulusEngine.this.m_aad, 0, this.mac_CNT, (byte)40);
                }
                RomulusEngine.this.lfsr_gf56(this.mac_CNT);
            }
            RomulusEngine.this.m_aadPos = 0;
            RomulusEngine.this.m_bufPos = RomulusEngine.this.dataOperator.getLen();
        }

        @Override
        public void processBufferEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        }

        @Override
        public void processBufferDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        }

        @Override
        public void reset() {
            Arrays.clear(this.s);
            Arrays.clear(this.mac_s);
            RomulusEngine.this.reset_lfsr_gf56(this.mac_CNT);
            RomulusEngine.this.reset_lfsr_gf56(RomulusEngine.this.CNT);
            this.twist = true;
        }
    }

    private class RomulusN
    implements Instance {
        private final byte[] s = new byte[16];
        boolean twist;

        @Override
        public void processFinalBlock(byte[] output, int outOff) {
            int messegeLen = RomulusEngine.this.dataOperator.getLen() - (RomulusEngine.this.forEncryption ? 0 : RomulusEngine.this.MAC_SIZE);
            if (messegeLen == 0) {
                RomulusEngine.this.lfsr_gf56(RomulusEngine.this.CNT);
                RomulusEngine.this.block_cipher(this.s, RomulusEngine.this.k, RomulusEngine.this.npub, 0, RomulusEngine.this.CNT, (byte)21);
            } else if (RomulusEngine.this.m_bufPos != 0) {
                int len8 = Math.min(RomulusEngine.this.m_bufPos, 16);
                RomulusEngine.this.rho(RomulusEngine.this.m_buf, 0, output, outOff, this.s, len8);
                RomulusEngine.this.lfsr_gf56(RomulusEngine.this.CNT);
                RomulusEngine.this.block_cipher(this.s, RomulusEngine.this.k, RomulusEngine.this.npub, 0, RomulusEngine.this.CNT, RomulusEngine.this.m_bufPos == 16 ? (byte)20 : 21);
            }
            RomulusEngine.this.g8A(this.s, RomulusEngine.this.mac, 0);
        }

        @Override
        public void processBufferAAD(byte[] input, int inOff) {
            if (this.twist) {
                Bytes.xorTo(16, input, inOff, this.s);
            } else {
                RomulusEngine.this.block_cipher(this.s, RomulusEngine.this.k, input, inOff, RomulusEngine.this.CNT, (byte)8);
            }
            RomulusEngine.this.lfsr_gf56(RomulusEngine.this.CNT);
            this.twist = !this.twist;
        }

        @Override
        public void processFinalAAD() {
            if (RomulusEngine.this.m_aadPos != 0) {
                byte[] mp = new byte[16];
                int len8 = Math.min(RomulusEngine.this.m_aadPos, 16);
                RomulusEngine.this.pad(RomulusEngine.this.m_aad, 0, mp, 16, len8);
                if (this.twist) {
                    Bytes.xorTo(16, mp, this.s);
                } else {
                    RomulusEngine.this.block_cipher(this.s, RomulusEngine.this.k, mp, 0, RomulusEngine.this.CNT, (byte)8);
                }
                RomulusEngine.this.lfsr_gf56(RomulusEngine.this.CNT);
            }
            if (RomulusEngine.this.aadOperator.getLen() == 0) {
                RomulusEngine.this.lfsr_gf56(RomulusEngine.this.CNT);
                RomulusEngine.this.block_cipher(this.s, RomulusEngine.this.k, RomulusEngine.this.npub, 0, RomulusEngine.this.CNT, (byte)26);
            } else if ((RomulusEngine.this.m_aadPos & 0xF) != 0) {
                RomulusEngine.this.block_cipher(this.s, RomulusEngine.this.k, RomulusEngine.this.npub, 0, RomulusEngine.this.CNT, (byte)26);
            } else {
                RomulusEngine.this.block_cipher(this.s, RomulusEngine.this.k, RomulusEngine.this.npub, 0, RomulusEngine.this.CNT, (byte)24);
            }
            RomulusEngine.this.reset_lfsr_gf56(RomulusEngine.this.CNT);
        }

        @Override
        public void processBufferEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
            RomulusEngine.this.g8A(this.s, output, outOff);
            for (int i = 0; i < 16; ++i) {
                int n = i;
                this.s[n] = (byte)(this.s[n] ^ input[i + inOff]);
                int n2 = i + outOff;
                output[n2] = (byte)(output[n2] ^ input[i + inOff]);
            }
            RomulusEngine.this.lfsr_gf56(RomulusEngine.this.CNT);
            RomulusEngine.this.block_cipher(this.s, RomulusEngine.this.k, RomulusEngine.this.npub, 0, RomulusEngine.this.CNT, (byte)4);
        }

        @Override
        public void processBufferDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
            RomulusEngine.this.g8A(this.s, output, outOff);
            for (int i = 0; i < 16; ++i) {
                int n = i + outOff;
                output[n] = (byte)(output[n] ^ input[i + inOff]);
                int n2 = i;
                this.s[n2] = (byte)(this.s[n2] ^ output[i + outOff]);
            }
            RomulusEngine.this.lfsr_gf56(RomulusEngine.this.CNT);
            RomulusEngine.this.block_cipher(this.s, RomulusEngine.this.k, RomulusEngine.this.npub, 0, RomulusEngine.this.CNT, (byte)4);
        }

        @Override
        public void reset() {
            Arrays.clear(this.s);
            RomulusEngine.this.reset_lfsr_gf56(RomulusEngine.this.CNT);
            this.twist = true;
        }
    }

    public static class RomulusParameters {
        public static final int ROMULUS_M = 0;
        public static final int ROMULUS_N = 1;
        public static final int ROMULUS_T = 2;
        public static final RomulusParameters RomulusM = new RomulusParameters(0);
        public static final RomulusParameters RomulusN = new RomulusParameters(1);
        public static final RomulusParameters RomulusT = new RomulusParameters(2);
        private final int ord;

        RomulusParameters(int ord) {
            this.ord = ord;
        }
    }

    private class RomulusT
    implements Instance {
        private final byte[] h = new byte[16];
        private final byte[] g = new byte[16];
        byte[] Z = new byte[16];
        byte[] CNT_Z = new byte[7];
        byte[] LR = new byte[32];
        byte[] T = new byte[16];
        byte[] S = new byte[16];

        private RomulusT() {
        }

        @Override
        public void processFinalBlock(byte[] output, int outOff) {
            int n = 16;
            int messegeLen = RomulusEngine.this.dataOperator.getLen() - (RomulusEngine.this.forEncryption ? 0 : RomulusEngine.this.MAC_SIZE);
            if (RomulusEngine.this.m_bufPos != 0) {
                int macInOff;
                byte[] macIn;
                int len8 = Math.min(RomulusEngine.this.m_bufPos, 16);
                System.arraycopy(RomulusEngine.this.npub, 0, this.S, 0, 16);
                RomulusEngine.this.block_cipher(this.S, this.Z, this.T, 0, RomulusEngine.this.CNT, (byte)64);
                Bytes.xor(len8, RomulusEngine.this.m_buf, this.S, output, outOff);
                System.arraycopy(RomulusEngine.this.npub, 0, this.S, 0, 16);
                RomulusEngine.this.lfsr_gf56(RomulusEngine.this.CNT);
                if (RomulusEngine.this.forEncryption) {
                    macIn = output;
                    macInOff = outOff;
                } else {
                    macIn = RomulusEngine.this.m_buf;
                    macInOff = 0;
                }
                System.arraycopy(macIn, macInOff, RomulusEngine.this.m_aad, RomulusEngine.this.m_aadPos, RomulusEngine.this.m_bufPos);
                Arrays.fill(RomulusEngine.this.m_aad, RomulusEngine.this.m_aadPos + RomulusEngine.this.m_bufPos, RomulusEngine.this.AADBufferSize - 1, (byte)0);
                RomulusEngine.this.m_aad[RomulusEngine.this.m_aadPos + RomulusEngine.this.BlockSize - 1] = (byte)(RomulusEngine.this.m_bufPos & 0xF);
                if (RomulusEngine.this.m_aadPos == 0) {
                    System.arraycopy(RomulusEngine.this.npub, 0, RomulusEngine.this.m_aad, RomulusEngine.this.BlockSize, RomulusEngine.this.BlockSize);
                    n = 0;
                }
                RomulusEngine.hirose_128_128_256(this.h, this.g, RomulusEngine.this.m_aad, 0);
                RomulusEngine.this.lfsr_gf56(this.CNT_Z);
            } else if (RomulusEngine.this.m_aadPos != 0) {
                if (messegeLen > 0) {
                    Arrays.fill(RomulusEngine.this.m_aad, RomulusEngine.this.BlockSize, RomulusEngine.this.AADBufferSize, (byte)0);
                } else if (RomulusEngine.this.aadOperator.getLen() != 0) {
                    System.arraycopy(RomulusEngine.this.npub, 0, RomulusEngine.this.m_aad, RomulusEngine.this.m_aadPos, 16);
                    n = 0;
                    RomulusEngine.this.m_aadPos = 0;
                }
                RomulusEngine.hirose_128_128_256(this.h, this.g, RomulusEngine.this.m_aad, 0);
            } else if (messegeLen > 0) {
                Arrays.fill(RomulusEngine.this.m_aad, 0, RomulusEngine.this.BlockSize, (byte)0);
                System.arraycopy(RomulusEngine.this.npub, 0, RomulusEngine.this.m_aad, RomulusEngine.this.BlockSize, RomulusEngine.this.BlockSize);
                n = 0;
                RomulusEngine.hirose_128_128_256(this.h, this.g, RomulusEngine.this.m_aad, 0);
            }
            if (n == 16) {
                System.arraycopy(RomulusEngine.this.npub, 0, RomulusEngine.this.m_aad, 0, 16);
                System.arraycopy(RomulusEngine.this.CNT, 0, RomulusEngine.this.m_aad, 16, 7);
                Arrays.fill(RomulusEngine.this.m_aad, 23, 31, (byte)0);
                RomulusEngine.this.m_aad[31] = 23;
            } else {
                System.arraycopy(this.CNT_Z, 0, RomulusEngine.this.m_aad, 0, 7);
                Arrays.fill(RomulusEngine.this.m_aad, 7, 31, (byte)0);
                RomulusEngine.this.m_aad[31] = 7;
            }
            this.h[0] = (byte)(this.h[0] ^ 2);
            RomulusEngine.hirose_128_128_256(this.h, this.g, RomulusEngine.this.m_aad, 0);
            System.arraycopy(this.h, 0, this.LR, 0, 16);
            System.arraycopy(this.g, 0, this.LR, 16, 16);
            Arrays.clear(this.CNT_Z);
            RomulusEngine.this.block_cipher(this.LR, RomulusEngine.this.k, this.LR, 16, this.CNT_Z, (byte)68);
            System.arraycopy(this.LR, 0, RomulusEngine.this.mac, 0, RomulusEngine.this.MAC_SIZE);
        }

        @Override
        public void processBufferAAD(byte[] input, int inOff) {
            RomulusEngine.hirose_128_128_256(this.h, this.g, input, inOff);
        }

        @Override
        public void processFinalAAD() {
            Arrays.fill(RomulusEngine.this.m_aad, RomulusEngine.this.m_aadPos, RomulusEngine.this.AADBufferSize - 1, (byte)0);
            if (RomulusEngine.this.m_aadPos >= 16) {
                RomulusEngine.this.m_aad[RomulusEngine.this.AADBufferSize - 1] = (byte)(RomulusEngine.this.m_aadPos & 0xF);
                RomulusEngine.hirose_128_128_256(this.h, this.g, RomulusEngine.this.m_aad, 0);
                RomulusEngine.this.m_aadPos = 0;
            } else if (RomulusEngine.this.m_aadPos >= 0 && RomulusEngine.this.aadOperator.getLen() != 0) {
                RomulusEngine.this.m_aad[RomulusEngine.this.BlockSize - 1] = (byte)(RomulusEngine.this.m_aadPos & 0xF);
                RomulusEngine.this.m_aadPos = RomulusEngine.this.BlockSize;
            }
        }

        private void processBuffer(byte[] input, int inOff, byte[] output, int outOff) {
            System.arraycopy(RomulusEngine.this.npub, 0, this.S, 0, 16);
            RomulusEngine.this.block_cipher(this.S, this.Z, this.T, 0, RomulusEngine.this.CNT, (byte)64);
            Bytes.xor(16, this.S, input, inOff, output, outOff);
            System.arraycopy(RomulusEngine.this.npub, 0, this.S, 0, 16);
            RomulusEngine.this.block_cipher(this.S, this.Z, this.T, 0, RomulusEngine.this.CNT, (byte)65);
            System.arraycopy(this.S, 0, this.Z, 0, 16);
            RomulusEngine.this.lfsr_gf56(RomulusEngine.this.CNT);
        }

        private void processAfterAbsorbCiphertext() {
            if (RomulusEngine.this.m_aadPos == RomulusEngine.this.BlockSize) {
                RomulusEngine.hirose_128_128_256(this.h, this.g, RomulusEngine.this.m_aad, 0);
                RomulusEngine.this.m_aadPos = 0;
            } else {
                RomulusEngine.this.m_aadPos = RomulusEngine.this.BlockSize;
            }
            RomulusEngine.this.lfsr_gf56(this.CNT_Z);
        }

        @Override
        public void processBufferEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
            this.processBuffer(input, inOff, output, outOff);
            System.arraycopy(output, outOff, RomulusEngine.this.m_aad, RomulusEngine.this.m_aadPos, RomulusEngine.this.BlockSize);
            this.processAfterAbsorbCiphertext();
        }

        @Override
        public void processBufferDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
            this.processBuffer(input, inOff, output, outOff);
            System.arraycopy(input, inOff, RomulusEngine.this.m_aad, RomulusEngine.this.m_aadPos, RomulusEngine.this.BlockSize);
            this.processAfterAbsorbCiphertext();
        }

        @Override
        public void reset() {
            Arrays.clear(this.h);
            Arrays.clear(this.g);
            Arrays.clear(this.LR);
            Arrays.clear(this.T);
            Arrays.clear(this.S);
            Arrays.clear(this.CNT_Z);
            RomulusEngine.this.reset_lfsr_gf56(RomulusEngine.this.CNT);
            System.arraycopy(RomulusEngine.this.npub, 0, this.Z, 0, RomulusEngine.this.IV_SIZE);
            RomulusEngine.this.block_cipher(this.Z, RomulusEngine.this.k, this.T, 0, this.CNT_Z, (byte)66);
            RomulusEngine.this.reset_lfsr_gf56(this.CNT_Z);
        }
    }
}

