/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.kems;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.kems.SAKKEKEMExtractor;
import org.bouncycastle.crypto.kems.SecretWithEncapsulationImpl;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.SAKKEPublicKeyParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class SAKKEKEMSGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom random;

    public SAKKEKEMSGenerator(SecureRandom random) {
        this.random = random;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        SAKKEPublicKeyParameters keyParameters = (SAKKEPublicKeyParameters)recipientKey;
        ECPoint Z = keyParameters.getZ();
        BigInteger b = keyParameters.getIdentifier();
        BigInteger p = keyParameters.getPrime();
        BigInteger q = keyParameters.getQ();
        BigInteger g = keyParameters.getG();
        int n = keyParameters.getN();
        ECCurve curve = keyParameters.getCurve();
        ECPoint P = keyParameters.getPoint();
        Digest digest = keyParameters.getDigest();
        BigInteger ssv = BigIntegers.createRandomBigInteger(n, this.random);
        BigInteger r = SAKKEKEMSGenerator.hashToIntegerRange(Arrays.concatenate(ssv.toByteArray(), b.toByteArray()), q, digest);
        ECPoint bP = P.multiply(b).normalize();
        ECPoint R_bS = bP.add(Z).multiply(r).normalize();
        BigInteger pointX = BigInteger.ONE;
        BigInteger pointY = g;
        BigInteger[] v = new BigInteger[2];
        BigInteger currentX = BigInteger.ONE;
        BigInteger currentY = g;
        ECPoint current = curve.createPoint(currentX, currentY);
        int numBits = r.bitLength();
        for (int i = numBits - 2; i >= 0; --i) {
            BigInteger[] rlt = SAKKEKEMExtractor.fp2PointSquare(currentX, currentY, p);
            current = current.timesPow2(2);
            currentX = rlt[0];
            currentY = rlt[1];
            if (!r.testBit(i)) continue;
            rlt = SAKKEKEMExtractor.fp2Multiply(currentX, currentY, pointX, pointY, p);
            currentX = rlt[0];
            currentY = rlt[1];
        }
        v[0] = currentX;
        v[1] = currentY;
        BigInteger g_r = v[1].multiply(v[0].modInverse(p)).mod(p);
        BigInteger mask = SAKKEKEMSGenerator.hashToIntegerRange(g_r.toByteArray(), BigInteger.ONE.shiftLeft(n), digest);
        BigInteger H = ssv.xor(mask);
        byte[] encapsulated = Arrays.concatenate(R_bS.getEncoded(false), BigIntegers.asUnsignedByteArray(16, H));
        return new SecretWithEncapsulationImpl(BigIntegers.asUnsignedByteArray(n / 8, ssv), encapsulated);
    }

    static BigInteger hashToIntegerRange(byte[] input, BigInteger q, Digest digest) {
        byte[] hash = new byte[digest.getDigestSize()];
        digest.update(input, 0, input.length);
        digest.doFinal(hash, 0);
        byte[] A = Arrays.clone(hash);
        byte[] h = new byte[digest.getDigestSize()];
        int l = q.bitLength() >> 8;
        BigInteger v = BigInteger.ZERO;
        for (int i = 0; i <= l; ++i) {
            digest.update(h, 0, h.length);
            digest.doFinal(h, 0);
            digest.update(h, 0, h.length);
            digest.update(A, 0, A.length);
            byte[] v_i = new byte[digest.getDigestSize()];
            digest.doFinal(v_i, 0);
            v = v.shiftLeft(v_i.length * 8).add(new BigInteger(1, v_i));
        }
        return v.mod(q);
    }
}

