/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECCSIPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECCSIPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class ECCSISigner
implements Signer {
    private final BigInteger q;
    private final ECPoint G;
    private final Digest digest;
    private BigInteger j;
    private BigInteger r;
    private ECPoint Y;
    private final ECPoint kpak;
    private final byte[] id;
    private CipherParameters param;
    private ByteArrayOutputStream stream;
    private boolean forSigning;
    private final int N;

    public ECCSISigner(ECPoint kpak, X9ECParameters params, Digest digest, byte[] id) {
        this.kpak = kpak;
        this.id = id;
        this.q = params.getCurve().getOrder();
        this.G = params.getG();
        this.digest = digest;
        this.digest.reset();
        this.N = params.getCurve().getOrder().bitLength() + 7 >> 3;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.forSigning = forSigning;
        this.param = param;
        this.reset();
    }

    @Override
    public void update(byte b) {
        if (this.forSigning) {
            this.digest.update(b);
        } else {
            this.stream.write(b);
        }
    }

    @Override
    public void update(byte[] in, int off, int len) {
        if (this.forSigning) {
            this.digest.update(in, off, len);
        } else {
            this.stream.write(in, off, len);
        }
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        byte[] heBytes = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(heBytes, 0);
        ECCSIPrivateKeyParameters params = (ECCSIPrivateKeyParameters)((ParametersWithRandom)this.param).getParameters();
        BigInteger ssk = params.getSSK();
        BigInteger denominator = new BigInteger(1, heBytes).add(this.r.multiply(ssk)).mod(this.q);
        if (denominator.equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("Invalid j, retry");
        }
        BigInteger sPrime = denominator.modInverse(this.q).multiply(this.j).mod(this.q);
        return Arrays.concatenate(BigIntegers.asUnsignedByteArray(this.N, this.r), BigIntegers.asUnsignedByteArray(this.N, sPrime), params.getPublicKeyParameters().getPVT().getEncoded(false));
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        byte[] bytes = Arrays.copyOf(signature, this.N);
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(signature, this.N, this.N << 1));
        this.r = new BigInteger(1, bytes).mod(this.q);
        this.digest.update(bytes, 0, this.N);
        bytes = this.stream.toByteArray();
        this.digest.update(bytes, 0, bytes.length);
        bytes = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(bytes, 0);
        BigInteger HE = new BigInteger(1, bytes).mod(this.q);
        ECPoint HE_G = this.G.multiply(HE).normalize();
        ECPoint rY = this.Y.multiply(this.r).normalize();
        ECPoint sum = HE_G.add(rY).normalize();
        ECPoint J = sum.multiply(s).normalize();
        BigInteger rComputed = J.getAffineXCoord().toBigInteger();
        return rComputed.mod(this.q).equals(this.r.mod(this.q));
    }

    @Override
    public void reset() {
        ECPoint pvt;
        AsymmetricKeyParameter parameters;
        this.digest.reset();
        CipherParameters param = this.param;
        SecureRandom random = null;
        if (param instanceof ParametersWithRandom) {
            random = ((ParametersWithRandom)param).getRandom();
            param = ((ParametersWithRandom)param).getParameters();
        }
        ECPoint kpak_computed = null;
        if (this.forSigning) {
            parameters = (ECCSIPrivateKeyParameters)param;
            pvt = ((ECCSIPrivateKeyParameters)parameters).getPublicKeyParameters().getPVT();
            this.j = BigIntegers.createRandomBigInteger(this.q.bitLength(), random);
            ECPoint J = this.G.multiply(this.j).normalize();
            this.r = J.getAffineXCoord().toBigInteger().mod(this.q);
            kpak_computed = this.G.multiply(((ECCSIPrivateKeyParameters)parameters).getSSK());
        } else {
            parameters = (ECCSIPublicKeyParameters)param;
            pvt = ((ECCSIPublicKeyParameters)parameters).getPVT();
            this.stream = new ByteArrayOutputStream();
        }
        byte[] tmp = this.G.getEncoded(false);
        this.digest.update(tmp, 0, tmp.length);
        tmp = this.kpak.getEncoded(false);
        this.digest.update(tmp, 0, tmp.length);
        this.digest.update(this.id, 0, this.id.length);
        tmp = pvt.getEncoded(false);
        this.digest.update(tmp, 0, tmp.length);
        tmp = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(tmp, 0);
        BigInteger HS = new BigInteger(1, tmp).mod(this.q);
        this.digest.update(tmp, 0, tmp.length);
        if (this.forSigning) {
            if (!(kpak_computed = kpak_computed.subtract(pvt.multiply(HS)).normalize()).equals(this.kpak)) {
                throw new IllegalArgumentException("Invalid KPAK");
            }
            byte[] rBytes = BigIntegers.asUnsignedByteArray(this.N, this.r);
            this.digest.update(rBytes, 0, rBytes.length);
        } else {
            this.Y = pvt.multiply(HS).add(this.kpak).normalize();
        }
    }
}

