/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.mlkem;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jcajce.interfaces.MLKEMPrivateKey;
import org.bouncycastle.jcajce.interfaces.MLKEMPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.mlkem.BCMLKEMPublicKey;
import org.bouncycastle.jcajce.spec.MLKEMParameterSpec;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Fingerprint;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BCMLKEMPrivateKey
implements MLKEMPrivateKey {
    private static final long serialVersionUID = 1L;
    private transient MLKEMPrivateKeyParameters params;
    private transient String algorithm;
    private transient ASN1Set attributes;
    private transient byte[] priorEncoding;

    public BCMLKEMPrivateKey(MLKEMPrivateKeyParameters params) {
        this.params = params;
        this.algorithm = Strings.toUpperCase(params.getParameters().getName());
    }

    public BCMLKEMPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(PrivateKeyInfo keyInfo) throws IOException {
        this.attributes = keyInfo.getAttributes();
        this.priorEncoding = keyInfo.getEncoded();
        this.params = (MLKEMPrivateKeyParameters)PrivateKeyFactory.createKey(keyInfo);
        this.algorithm = Strings.toUpperCase(MLKEMParameterSpec.fromName(this.params.getParameters().getName()).getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCMLKEMPrivateKey) {
            BCMLKEMPrivateKey otherKey = (BCMLKEMPrivateKey)o;
            return Arrays.areEqual(this.params.getEncoded(), otherKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getEncoded() {
        try {
            if (this.priorEncoding != null) {
                return this.priorEncoding;
            }
            PrivateKeyInfo pki = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public MLKEMPublicKey getPublicKey() {
        return new BCMLKEMPublicKey(this.params.getPublicKeyParameters());
    }

    @Override
    public byte[] getPrivateData() {
        return this.params.getEncoded();
    }

    @Override
    public byte[] getSeed() {
        return this.params.getSeed();
    }

    @Override
    public MLKEMPrivateKey getPrivateKey(boolean preferSeedOnly) {
        byte[] seed;
        if (preferSeedOnly && (seed = this.params.getSeed()) != null) {
            return new BCMLKEMPrivateKey(this.params.getParametersWithFormat(1));
        }
        return new BCMLKEMPrivateKey(this.params.getParametersWithFormat(2));
    }

    @Override
    public MLKEMParameterSpec getParameterSpec() {
        return MLKEMParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String nl = Strings.lineSeparator();
        byte[] keyBytes = this.params.getPublicKey();
        buf.append(this.getAlgorithm()).append(" ").append("Private Key").append(" [").append(new Fingerprint(keyBytes).toString()).append("]").append(nl).append("    public data: ").append(Hex.toHexString(keyBytes)).append(nl);
        return buf.toString();
    }

    MLKEMPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(PrivateKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

