/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.pqc.crypto.falcon.FPREngine;

class FalconFFT {
    FalconFFT() {
    }

    static void FFT(double[] srcf, int f, int logn) {
        int hn;
        int n = 1 << logn;
        int t = hn = n >> 1;
        int u = 1;
        int m = 2;
        while (u < logn) {
            int ht = t >> 1;
            int hm = m >> 1;
            int i1 = 0;
            int j1 = 0;
            while (i1 < hm) {
                int j2 = j1 + ht + f;
                int fj = m + i1 << 1;
                double s_re = FPREngine.fpr_gm_tab[fj];
                double s_im = FPREngine.fpr_gm_tab[fj + 1];
                fj = f + j1;
                int fjhn = fj + hn;
                int fjht = fj + ht;
                int fjhthn = fjht + hn;
                while (fj < j2) {
                    double x_re = srcf[fj];
                    double x_im = srcf[fjhn];
                    double a_re = srcf[fjht];
                    double a_im = srcf[fjhthn];
                    double y_re = a_re * s_re - a_im * s_im;
                    double y_im = a_re * s_im + a_im * s_re;
                    srcf[fj] = x_re + y_re;
                    srcf[fjhn] = x_im + y_im;
                    srcf[fjht] = x_re - y_re;
                    srcf[fjhthn] = x_im - y_im;
                    ++fj;
                    ++fjhn;
                    ++fjht;
                    ++fjhthn;
                }
                ++i1;
                j1 += t;
            }
            t = ht;
            ++u;
            m <<= 1;
        }
    }

    static void iFFT(double[] srcf, int f, int logn) {
        int u;
        int n = 1 << logn;
        int t = 1;
        int m = n;
        int hn = n >> 1;
        for (u = logn; u > 1; --u) {
            int hm = m >> 1;
            int dt = t << 1;
            int i1 = 0;
            for (int j1 = 0; j1 < hn; j1 += dt) {
                int j2 = j1 + t + f;
                int fj = hm + i1 << 1;
                double s_re = FPREngine.fpr_gm_tab[fj];
                double s_im = -FPREngine.fpr_gm_tab[fj + 1];
                fj = f + j1;
                int fjhn = fj + hn;
                int fjt = fj + t;
                int fjthn = fjt + hn;
                while (fj < j2) {
                    double x_re = srcf[fj];
                    double x_im = srcf[fjhn];
                    double y_re = srcf[fjt];
                    double y_im = srcf[fjthn];
                    srcf[fj] = x_re + y_re;
                    srcf[fjhn] = x_im + y_im;
                    srcf[fjt] = (x_re -= y_re) * s_re - (x_im -= y_im) * s_im;
                    srcf[fjthn] = x_re * s_im + x_im * s_re;
                    ++fj;
                    ++fjhn;
                    ++fjt;
                    ++fjthn;
                }
                ++i1;
            }
            t = dt;
            m = hm;
        }
        if (logn > 0) {
            double ni = FPREngine.fpr_p2_tab[logn];
            for (u = 0; u < n; ++u) {
                srcf[f + u] = srcf[f + u] * ni;
            }
        }
    }

    static void poly_add(double[] srca, int a, double[] srcb, int b, int logn) {
        int n = 1 << logn;
        for (int u = 0; u < n; ++u) {
            int n2 = a + u;
            srca[n2] = srca[n2] + srcb[b + u];
        }
    }

    static void poly_sub(double[] srca, int a, double[] srcb, int b, int logn) {
        int n = 1 << logn;
        for (int u = 0; u < n; ++u) {
            int n2 = a + u;
            srca[n2] = srca[n2] - srcb[b + u];
        }
    }

    static void poly_neg(double[] srca, int a, int logn) {
        int n = 1 << logn;
        for (int u = 0; u < n; ++u) {
            srca[a + u] = -srca[a + u];
        }
    }

    static void poly_adj_fft(double[] srca, int a, int logn) {
        int n = 1 << logn;
        for (int u = n >> 1; u < n; ++u) {
            srca[a + u] = -srca[a + u];
        }
    }

    static void poly_mul_fft(double[] srca, int a, double[] srcb, int b, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int u = 0;
        int au = a;
        int auhn = a + hn;
        int bu = b;
        while (u < hn) {
            double a_re = srca[au];
            double a_im = srca[auhn];
            double b_re = srcb[bu];
            double b_im = srcb[bu + hn];
            srca[au] = a_re * b_re - a_im * b_im;
            srca[auhn] = a_re * b_im + a_im * b_re;
            ++u;
            ++au;
            ++bu;
            ++auhn;
        }
    }

    static void poly_muladj_fft(double[] srca, int a, double[] srcb, int b, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int u = 0;
        int au = a;
        while (u < hn) {
            double a_re = srca[au];
            double a_im = srca[au + hn];
            double b_re = srcb[b + u];
            double b_im = srcb[b + u + hn];
            srca[au] = a_re * b_re + a_im * b_im;
            srca[au + hn] = a_im * b_re - a_re * b_im;
            ++u;
            ++au;
        }
    }

    static void poly_mulselfadj_fft(double[] srca, int a, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        for (int u = 0; u < hn; ++u) {
            double a_re = srca[a + u];
            double a_im = srca[a + u + hn];
            srca[a + u] = a_re * a_re + a_im * a_im;
            srca[a + u + hn] = 0.0;
        }
    }

    static void poly_mulconst(double[] srca, int a, double x, int logn) {
        int n = 1 << logn;
        for (int u = 0; u < n; ++u) {
            srca[a + u] = srca[a + u] * x;
        }
    }

    static void poly_invnorm2_fft(double[] srcd, int d, double[] srca, int a, double[] srcb, int b, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        for (int u = 0; u < hn; ++u) {
            double a_re = srca[a + u];
            double a_im = srca[a + u + hn];
            double b_re = srcb[b + u];
            double b_im = srcb[b + u + hn];
            srcd[d + u] = 1.0 / (a_re * a_re + a_im * a_im + b_re * b_re + b_im * b_im);
        }
    }

    static void poly_add_muladj_fft(double[] srcd, double[] srcF, double[] srcG, double[] srcf, double[] srcg, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        for (int u = 0; u < hn; ++u) {
            int uhn = u + hn;
            double F_re = srcF[u];
            double F_im = srcF[uhn];
            double G_re = srcG[u];
            double G_im = srcG[uhn];
            double f_re = srcf[u];
            double f_im = srcf[uhn];
            double g_re = srcg[u];
            double g_im = srcg[uhn];
            double a_re = F_re * f_re + F_im * f_im;
            double a_im = F_im * f_re - F_re * f_im;
            double b_re = G_re * g_re + G_im * g_im;
            double b_im = G_im * g_re - G_re * g_im;
            srcd[u] = a_re + b_re;
            srcd[uhn] = a_im + b_im;
        }
    }

    static void poly_mul_autoadj_fft(double[] srca, int a, double[] srcb, int b, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        for (int u = 0; u < hn; ++u) {
            int n2 = a + u;
            srca[n2] = srca[n2] * srcb[b + u];
            int n3 = a + u + hn;
            srca[n3] = srca[n3] * srcb[b + u];
        }
    }

    static void poly_div_autoadj_fft(double[] srca, int a, double[] srcb, int b, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        for (int u = 0; u < hn; ++u) {
            double ib = 1.0 / srcb[b + u];
            int n2 = a + u;
            srca[n2] = srca[n2] * ib;
            int n3 = a + u + hn;
            srca[n3] = srca[n3] * ib;
        }
    }

    static void poly_LDL_fft(double[] srcg00, int g00, double[] srcg01, int g01, double[] srcg11, int g11, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int u = 0;
        int uhn = hn;
        int g01u = g01;
        int g01uhn = g01 + hn;
        while (u < hn) {
            double g00_re = srcg00[g00 + u];
            double g00_im = srcg00[g00 + uhn];
            double g01_re = srcg01[g01u];
            double g01_im = srcg01[g01uhn];
            double g11_im = 1.0 / (g00_re * g00_re + g00_im * g00_im);
            double g11_re = g00_re * g11_im;
            g00_re = g01_re * g11_re - g01_im * (g11_im *= -g00_im);
            g00_im = g01_re * g11_im + g01_im * g11_re;
            g11_re = g01_re;
            g11_im = g01_im;
            g01_re = g00_re * g11_re + g00_im * g11_im;
            g01_im = g00_re * -g11_im + g00_im * g11_re;
            int n2 = g11 + u;
            srcg11[n2] = srcg11[n2] - g01_re;
            int n3 = g11 + uhn;
            srcg11[n3] = srcg11[n3] - g01_im;
            srcg01[g01u] = g00_re;
            srcg01[g01uhn] = -g00_im;
            ++u;
            ++uhn;
            ++g01u;
            ++g01uhn;
        }
    }

    static void poly_split_fft(double[] srcf0, int f0, double[] srcf1, int f1, double[] srcf, int f, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int qn = hn >> 1;
        srcf0[f0] = srcf[f];
        srcf1[f1] = srcf[f + hn];
        for (int u = 0; u < qn; ++u) {
            int idx = f + (u << 1);
            double a_re = srcf[idx];
            double a_im = srcf[idx++ + hn];
            double b_re = srcf[idx];
            double b_im = srcf[idx + hn];
            srcf0[f0 + u] = (a_re + b_re) * 0.5;
            srcf0[f0 + u + qn] = (a_im + b_im) * 0.5;
            double t_re = a_re - b_re;
            double t_im = a_im - b_im;
            idx = u + hn << 1;
            b_re = FPREngine.fpr_gm_tab[idx];
            b_im = -FPREngine.fpr_gm_tab[idx + 1];
            idx = f1 + u;
            srcf1[idx] = (t_re * b_re - t_im * b_im) * 0.5;
            srcf1[idx + qn] = (t_re * b_im + t_im * b_re) * 0.5;
        }
    }

    static void poly_merge_fft(double[] srcf, int f, double[] srcf0, int f0, double[] srcf1, int f1, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int qn = hn >> 1;
        srcf[f] = srcf0[f0];
        srcf[f + hn] = srcf1[f1];
        for (int u = 0; u < qn; ++u) {
            int idx = f1 + u;
            double a_re = srcf1[idx];
            double a_im = srcf1[idx + qn];
            idx = u + hn << 1;
            double t_re = FPREngine.fpr_gm_tab[idx];
            double t_im = FPREngine.fpr_gm_tab[idx + 1];
            double b_re = a_re * t_re - a_im * t_im;
            double b_im = a_re * t_im + a_im * t_re;
            idx = f0 + u;
            a_re = srcf0[idx];
            a_im = srcf0[idx + qn];
            idx = f + (u << 1);
            srcf[idx] = a_re + b_re;
            srcf[idx++ + hn] = a_im + b_im;
            srcf[idx] = a_re - b_re;
            srcf[idx + hn] = a_im - b_im;
        }
    }
}

