/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import java.security.SecureRandom;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.falcon.FalconCodec;
import org.bouncycastle.pqc.crypto.falcon.FalconCommon;
import org.bouncycastle.pqc.crypto.falcon.FalconKeyGen;
import org.bouncycastle.pqc.crypto.falcon.FalconSign;
import org.bouncycastle.pqc.crypto.falcon.FalconVrfy;
import org.bouncycastle.util.Arrays;

class FalconNIST {
    final int NONCELEN;
    final int LOGN;
    private final int N;
    private final SecureRandom rand;
    private final int CRYPTO_SECRETKEYBYTES;
    private final int CRYPTO_PUBLICKEYBYTES;
    final int CRYPTO_BYTES;

    FalconNIST(int logn, int noncelen, SecureRandom random) {
        this.rand = random;
        this.LOGN = logn;
        this.NONCELEN = noncelen;
        this.N = 1 << logn;
        this.CRYPTO_PUBLICKEYBYTES = 1 + 14 * this.N / 8;
        if (logn == 10) {
            this.CRYPTO_SECRETKEYBYTES = 2305;
            this.CRYPTO_BYTES = 1330;
        } else if (logn == 9 || logn == 8) {
            this.CRYPTO_SECRETKEYBYTES = 1 + 6 * this.N * 2 / 8 + this.N;
            this.CRYPTO_BYTES = 690;
        } else if (logn == 7 || logn == 6) {
            this.CRYPTO_SECRETKEYBYTES = 1 + 7 * this.N * 2 / 8 + this.N;
            this.CRYPTO_BYTES = 690;
        } else {
            this.CRYPTO_SECRETKEYBYTES = 1 + this.N * 2 + this.N;
            this.CRYPTO_BYTES = 690;
        }
    }

    byte[][] crypto_sign_keypair(byte[] srcpk, byte[] srcsk) {
        byte[] f = new byte[this.N];
        byte[] g = new byte[this.N];
        byte[] F2 = new byte[this.N];
        short[] h = new short[this.N];
        byte[] seed = new byte[48];
        SHAKEDigest rng = new SHAKEDigest(256);
        this.rand.nextBytes(seed);
        rng.update(seed, 0, seed.length);
        FalconKeyGen.keygen(rng, f, g, F2, h, this.LOGN);
        srcsk[0] = (byte)(80 + this.LOGN);
        int u = 1;
        int v = FalconCodec.trim_i8_encode(srcsk, u, this.CRYPTO_SECRETKEYBYTES - u, f, this.LOGN, FalconCodec.max_fg_bits[this.LOGN]);
        if (v == 0) {
            throw new IllegalStateException("f encode failed");
        }
        byte[] fEnc = Arrays.copyOfRange(srcsk, u, u + v);
        if ((v = FalconCodec.trim_i8_encode(srcsk, u += v, this.CRYPTO_SECRETKEYBYTES - u, g, this.LOGN, FalconCodec.max_fg_bits[this.LOGN])) == 0) {
            throw new IllegalStateException("g encode failed");
        }
        byte[] gEnc = Arrays.copyOfRange(srcsk, u, u + v);
        if ((v = FalconCodec.trim_i8_encode(srcsk, u += v, this.CRYPTO_SECRETKEYBYTES - u, F2, this.LOGN, FalconCodec.max_FG_bits[this.LOGN])) == 0) {
            throw new IllegalStateException("F encode failed");
        }
        byte[] FEnc = Arrays.copyOfRange(srcsk, u, u + v);
        if ((u += v) != this.CRYPTO_SECRETKEYBYTES) {
            throw new IllegalStateException("secret key encoding failed");
        }
        srcpk[0] = (byte)this.LOGN;
        v = FalconCodec.modq_encode(srcpk, this.CRYPTO_PUBLICKEYBYTES - 1, h, this.LOGN);
        if (v != this.CRYPTO_PUBLICKEYBYTES - 1) {
            throw new IllegalStateException("public key encoding failed");
        }
        return new byte[][]{Arrays.copyOfRange(srcpk, 1, srcpk.length), fEnc, gEnc, FEnc};
    }

    byte[] crypto_sign(byte[] srcsm, byte[] srcm, int mlen, byte[] srcsk) {
        byte[] f = new byte[this.N];
        byte[] g = new byte[this.N];
        byte[] F2 = new byte[this.N];
        byte[] G = new byte[this.N];
        short[] sig = new short[this.N];
        short[] hm = new short[this.N];
        byte[] seed = new byte[48];
        byte[] nonce = new byte[this.NONCELEN];
        SHAKEDigest sc = new SHAKEDigest(256);
        FalconSign sign = new FalconSign();
        int u = 0;
        int v = FalconCodec.trim_i8_decode(f, this.LOGN, FalconCodec.max_fg_bits[this.LOGN], srcsk, 0, this.CRYPTO_SECRETKEYBYTES - u);
        if (v == 0) {
            throw new IllegalStateException("f decode failed");
        }
        if ((v = FalconCodec.trim_i8_decode(g, this.LOGN, FalconCodec.max_fg_bits[this.LOGN], srcsk, u += v, this.CRYPTO_SECRETKEYBYTES - u)) == 0) {
            throw new IllegalStateException("g decode failed");
        }
        if ((v = FalconCodec.trim_i8_decode(F2, this.LOGN, FalconCodec.max_FG_bits[this.LOGN], srcsk, u += v, this.CRYPTO_SECRETKEYBYTES - u)) == 0) {
            throw new IllegalArgumentException("F decode failed");
        }
        if ((u += v) != this.CRYPTO_SECRETKEYBYTES - 1) {
            throw new IllegalStateException("full key not used");
        }
        if (!FalconVrfy.complete_private(G, f, g, F2, this.LOGN, new short[2 * this.N])) {
            throw new IllegalStateException("complete_private failed");
        }
        this.rand.nextBytes(nonce);
        sc.update(nonce, 0, this.NONCELEN);
        sc.update(srcm, 0, mlen);
        FalconCommon.hash_to_point_vartime(sc, hm, this.LOGN);
        this.rand.nextBytes(seed);
        sc.reset();
        sc.update(seed, 0, seed.length);
        sign.sign_dyn(sig, sc, f, g, F2, G, hm, this.LOGN, new double[10 * this.N]);
        byte[] esig = new byte[this.CRYPTO_BYTES - 2 - this.NONCELEN];
        int sig_len = FalconCodec.comp_encode(esig, esig.length, sig, this.LOGN);
        if (sig_len == 0) {
            throw new IllegalStateException("signature failed to generate");
        }
        srcsm[0] = (byte)(48 + this.LOGN);
        System.arraycopy(nonce, 0, srcsm, 1, this.NONCELEN);
        System.arraycopy(esig, 0, srcsm, 1 + this.NONCELEN, sig_len);
        return Arrays.copyOfRange(srcsm, 0, 1 + this.NONCELEN + sig_len);
    }

    int crypto_sign_open(byte[] sig_encoded, byte[] nonce, byte[] msg, byte[] srcpk) {
        short[] h = new short[this.N];
        short[] hm = new short[this.N];
        short[] sig = new short[this.N];
        SHAKEDigest sc = new SHAKEDigest(256);
        if (FalconCodec.modq_decode(h, this.LOGN, srcpk, this.CRYPTO_PUBLICKEYBYTES - 1) != this.CRYPTO_PUBLICKEYBYTES - 1) {
            return -1;
        }
        FalconVrfy.to_ntt_monty(h, this.LOGN);
        int sig_len = sig_encoded.length;
        int msg_len = msg.length;
        if (sig_len < 1 || FalconCodec.comp_decode(sig, this.LOGN, sig_encoded, sig_len) != sig_len) {
            return -1;
        }
        sc.update(nonce, 0, this.NONCELEN);
        sc.update(msg, 0, msg_len);
        FalconCommon.hash_to_point_vartime(sc, hm, this.LOGN);
        if (FalconVrfy.verify_raw(hm, sig, h, this.LOGN, new short[this.N]) == 0) {
            return -1;
        }
        return 0;
    }
}

