/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.snova;

import org.bouncycastle.pqc.crypto.snova.SnovaParameters;
import org.bouncycastle.util.GF16;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class MapGroup1 {
    public final byte[][][][] p11;
    public final byte[][][][] p12;
    public final byte[][][][] p21;
    public final byte[][][] aAlpha;
    public final byte[][][] bAlpha;
    public final byte[][][] qAlpha1;
    public final byte[][][] qAlpha2;

    public MapGroup1(SnovaParameters params) {
        int m = params.getM();
        int v = params.getV();
        int o = params.getO();
        int alpha = params.getAlpha();
        int lsq = params.getLsq();
        this.p11 = new byte[m][v][v][lsq];
        this.p12 = new byte[m][v][o][lsq];
        this.p21 = new byte[m][o][v][lsq];
        this.aAlpha = new byte[m][alpha][lsq];
        this.bAlpha = new byte[m][alpha][lsq];
        this.qAlpha1 = new byte[m][alpha][lsq];
        this.qAlpha2 = new byte[m][alpha][lsq];
    }

    void decode(byte[] input, int len, boolean isl4or5) {
        int inOff = MapGroup1.decodeP(input, 0, this.p11, len);
        inOff += MapGroup1.decodeP(input, inOff, this.p12, len - inOff);
        inOff += MapGroup1.decodeP(input, inOff, this.p21, len - inOff);
        if (isl4or5) {
            inOff += MapGroup1.decodeAlpha(input, inOff, this.aAlpha, len - inOff);
            inOff += MapGroup1.decodeAlpha(input, inOff, this.bAlpha, len - inOff);
            inOff += MapGroup1.decodeAlpha(input, inOff, this.qAlpha1, len - inOff);
            MapGroup1.decodeAlpha(input, inOff, this.qAlpha2, len - inOff);
        }
    }

    static int decodeP(byte[] input, int inOff, byte[][][][] p, int len) {
        int rlt = 0;
        for (int i = 0; i < p.length; ++i) {
            rlt += MapGroup1.decodeAlpha(input, inOff + rlt, p[i], len);
        }
        return rlt;
    }

    private static int decodeAlpha(byte[] input, int inOff, byte[][][] alpha, int len) {
        int rlt = 0;
        for (int i = 0; i < alpha.length; ++i) {
            rlt += MapGroup1.decodeArray(input, inOff + rlt, alpha[i], len - rlt);
        }
        return rlt;
    }

    static int decodeArray(byte[] input, int inOff, byte[][] array, int len) {
        int rlt = 0;
        for (int j = 0; j < array.length; ++j) {
            int tmp = Math.min(array[j].length, len << 1);
            GF16.decode(input, inOff + rlt, array[j], 0, tmp);
            tmp = tmp + 1 >> 1;
            rlt += tmp;
            len -= tmp;
        }
        return rlt;
    }

    void fill(byte[] input, boolean isl4or5) {
        int inOff = MapGroup1.fillP(input, 0, this.p11, input.length);
        inOff += MapGroup1.fillP(input, inOff, this.p12, input.length - inOff);
        inOff += MapGroup1.fillP(input, inOff, this.p21, input.length - inOff);
        if (isl4or5) {
            inOff += MapGroup1.fillAlpha(input, inOff, this.aAlpha, input.length - inOff);
            inOff += MapGroup1.fillAlpha(input, inOff, this.bAlpha, input.length - inOff);
            inOff += MapGroup1.fillAlpha(input, inOff, this.qAlpha1, input.length - inOff);
            MapGroup1.fillAlpha(input, inOff, this.qAlpha2, input.length - inOff);
        }
    }

    static int fillP(byte[] input, int inOff, byte[][][][] p, int len) {
        int rlt = 0;
        for (int i = 0; i < p.length; ++i) {
            rlt += MapGroup1.fillAlpha(input, inOff + rlt, p[i], len - rlt);
        }
        return rlt;
    }

    static int fillAlpha(byte[] input, int inOff, byte[][][] alpha, int len) {
        int rlt = 0;
        for (int i = 0; i < alpha.length; ++i) {
            for (int j = 0; j < alpha[i].length; ++j) {
                int tmp = Math.min(alpha[i][j].length, len - rlt);
                System.arraycopy(input, inOff + rlt, alpha[i][j], 0, tmp);
                rlt += tmp;
            }
        }
        return rlt;
    }
}

