/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.util;

import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class BaseKeyFactorySpi
extends KeyFactorySpi
implements AsymmetricKeyInfoConverter {
    private final Set<ASN1ObjectIdentifier> keyOids;
    private final ASN1ObjectIdentifier keyOid;

    protected BaseKeyFactorySpi(Set<ASN1ObjectIdentifier> keyOids) {
        this.keyOid = null;
        this.keyOids = keyOids;
    }

    protected BaseKeyFactorySpi(ASN1ObjectIdentifier keyOid) {
        this.keyOid = keyOid;
        this.keyOids = null;
    }

    @Override
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] encKey = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            try {
                PrivateKeyInfo keyInfo = PrivateKeyInfo.getInstance(encKey);
                this.checkAlgorithm(keyInfo.getPrivateKeyAlgorithm().getAlgorithm());
                return this.generatePrivate(keyInfo);
            }
            catch (InvalidKeySpecException e) {
                throw e;
            }
            catch (IllegalStateException e) {
                throw new InvalidKeySpecException(e.getMessage());
            }
            catch (Exception e) {
                throw new InvalidKeySpecException(e.toString());
            }
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + keySpec.getClass() + ".");
    }

    @Override
    public PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] encKey = ((X509EncodedKeySpec)keySpec).getEncoded();
            try {
                SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance(encKey);
                this.checkAlgorithm(keyInfo.getAlgorithm().getAlgorithm());
                return this.generatePublic(keyInfo);
            }
            catch (InvalidKeySpecException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidKeySpecException(e.toString());
            }
        }
        throw new InvalidKeySpecException("Unknown key specification: " + keySpec + ".");
    }

    private void checkAlgorithm(ASN1ObjectIdentifier algOid) throws InvalidKeySpecException {
        if (this.keyOid != null ? !this.keyOid.equals(algOid) : !this.keyOids.contains(algOid)) {
            throw new InvalidKeySpecException("incorrect algorithm OID for key: " + algOid);
        }
    }
}

