/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.ASN1Private;

public class BERPrivate
extends ASN1Private {
    BERPrivate(boolean isConstructed, int tag, byte[] octets) {
        super(isConstructed, tag, octets);
    }

    public BERPrivate(int tag, ASN1Encodable object) throws IOException {
        this(true, tag, object);
    }

    public BERPrivate(boolean constructed, int tag, ASN1Encodable object) throws IOException {
        super(constructed || object.toASN1Primitive().isConstructed(), tag, BERPrivate.getEncoding(constructed, object));
    }

    private static byte[] getEncoding(boolean explicit, ASN1Encodable object) throws IOException {
        byte[] data = object.toASN1Primitive().getEncoded("BER");
        if (explicit) {
            return data;
        }
        int lenBytes = BERPrivate.getLengthOfHeader(data);
        byte[] tmp = new byte[data.length - lenBytes];
        System.arraycopy(data, lenBytes, tmp, 0, tmp.length);
        return tmp;
    }

    public BERPrivate(int tagNo, ASN1EncodableVector vec) {
        super(true, tagNo, BERPrivate.getEncodedVector(vec));
    }

    private static byte[] getEncodedVector(ASN1EncodableVector vec) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        for (int i = 0; i != vec.size(); ++i) {
            try {
                bOut.write(((ASN1Object)vec.get(i)).getEncoded("BER"));
                continue;
            }
            catch (IOException e) {
                throw new ASN1ParsingException("malformed object: " + e, e);
            }
        }
        return bOut.toByteArray();
    }

    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        int flags = 192;
        if (this.isConstructed) {
            flags |= 0x20;
        }
        out.writeEncodedIndef(withTag, flags, this.tag, this.octets);
    }
}

