/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.Permission;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.bouncycastle.jcajce.provider.config.ProviderConfigurationPermission;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;

class BouncyCastleProviderConfiguration
implements ProviderConfiguration {
    private static Permission BC_EC_LOCAL_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "threadLocalEcImplicitlyCa");
    private static Permission BC_EC_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "ecImplicitlyCa");
    private static Permission BC_DH_LOCAL_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "threadLocalDhDefaultParams");
    private static Permission BC_DH_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "DhDefaultParams");
    private ThreadLocal ecThreadSpec = new ThreadLocal();
    private ThreadLocal dhThreadSpec = new ThreadLocal();
    private volatile ECParameterSpec ecImplicitCaParams;
    private volatile DHParameterSpec dhDefaultParams;

    BouncyCastleProviderConfiguration() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setParameter(String string, Object object) {
        SecurityManager securityManager = System.getSecurityManager();
        if (string.equals("threadLocalEcImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_LOCAL_PERMISSION);
            }
            if (!(object instanceof ECParameterSpec) && object != null) {
                throw new IllegalArgumentException("not a valid ECParameterSpec");
            }
            ECParameterSpec eCParameterSpec = (ECParameterSpec)object;
            if (eCParameterSpec == null) {
                this.ecThreadSpec.set(null);
                return;
            } else {
                this.ecThreadSpec.set(eCParameterSpec);
            }
            return;
        } else if (string.equals("ecImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_PERMISSION);
            }
            if (!(object instanceof ECParameterSpec) && object != null) throw new IllegalArgumentException("not a valid ECParameterSpec");
            this.ecImplicitCaParams = (ECParameterSpec)object;
            return;
        } else if (string.equals("threadLocalDhDefaultParams")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_LOCAL_PERMISSION);
            }
            if (!(object instanceof DHParameterSpec) && object != null) {
                throw new IllegalArgumentException("not a valid DHParameterSpec");
            }
            DHParameterSpec dHParameterSpec = (DHParameterSpec)object;
            if (dHParameterSpec == null) {
                this.dhThreadSpec.set(null);
                return;
            } else {
                this.dhThreadSpec.set(dHParameterSpec);
            }
            return;
        } else {
            if (!string.equals("DhDefaultParams")) return;
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_PERMISSION);
            }
            if (!(object instanceof DHParameterSpec) && object != null) throw new IllegalArgumentException("not a valid DHParameterSpec");
            this.dhDefaultParams = (DHParameterSpec)object;
        }
    }

    public ECParameterSpec getEcImplicitlyCa() {
        ECParameterSpec eCParameterSpec = (ECParameterSpec)this.ecThreadSpec.get();
        if (eCParameterSpec != null) {
            return eCParameterSpec;
        }
        return this.ecImplicitCaParams;
    }

    public DHParameterSpec getDHDefaultParameters() {
        DHParameterSpec dHParameterSpec = (DHParameterSpec)this.dhThreadSpec.get();
        if (dHParameterSpec != null) {
            return dHParameterSpec;
        }
        return this.dhDefaultParams;
    }
}

