/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.X509Name;

public class GeneralName
extends ASN1Encodable
implements ASN1Choice {
    public static final int otherName = 0;
    public static final int rfc822Name = 1;
    public static final int dNSName = 2;
    public static final int x400Address = 3;
    public static final int directoryName = 4;
    public static final int ediPartyName = 5;
    public static final int uniformResourceIdentifier = 6;
    public static final int iPAddress = 7;
    public static final int registeredID = 8;
    DEREncodable obj;
    int tag;

    public GeneralName(int n, String string) {
        if (n == 1 || n == 2 || n == 6) {
            this.tag = n;
            this.obj = new DERIA5String(string);
        } else if (n == 8) {
            this.tag = n;
            this.obj = new DERObjectIdentifier(string);
        } else {
            throw new IllegalArgumentException("can't process String for tag: " + n);
        }
    }

    public GeneralName(int n, ASN1Encodable aSN1Encodable) {
        this.obj = aSN1Encodable;
        this.tag = n;
    }

    public GeneralName(DERObject dERObject, int n) {
        this.obj = dERObject;
        this.tag = n;
    }

    public GeneralName(X509Name x509Name) {
        this.obj = x509Name;
        this.tag = 4;
    }

    public static GeneralName getInstance(Object object) {
        if (object == null || object instanceof GeneralName) {
            return (GeneralName)object;
        }
        if (object instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object;
            int n = aSN1TaggedObject.getTagNo();
            switch (n) {
                case 0: {
                    return new GeneralName(ASN1Sequence.getInstance(aSN1TaggedObject, false), n);
                }
                case 1: {
                    return new GeneralName(DERIA5String.getInstance(aSN1TaggedObject, false), n);
                }
                case 2: {
                    return new GeneralName(DERIA5String.getInstance(aSN1TaggedObject, false), n);
                }
                case 3: {
                    throw new IllegalArgumentException("unknown tag: " + n);
                }
                case 4: {
                    return new GeneralName(ASN1Sequence.getInstance(aSN1TaggedObject, true), n);
                }
                case 5: {
                    return new GeneralName(ASN1Sequence.getInstance(aSN1TaggedObject, false), n);
                }
                case 6: {
                    return new GeneralName(DERIA5String.getInstance(aSN1TaggedObject, false), n);
                }
                case 7: {
                    return new GeneralName(ASN1OctetString.getInstance(aSN1TaggedObject, false), n);
                }
                case 8: {
                    return new GeneralName(DERObjectIdentifier.getInstance(aSN1TaggedObject, false), n);
                }
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static GeneralName getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return GeneralName.getInstance(ASN1TaggedObject.getInstance(aSN1TaggedObject, true));
    }

    public DEREncodable getName() {
        return this.obj;
    }

    public int getTagNo() {
        return this.tag;
    }

    public DERObject toASN1Object() {
        if (this.tag == 4) {
            return new DERTaggedObject(true, this.tag, this.obj);
        }
        return new DERTaggedObject(false, this.tag, this.obj);
    }
}

