/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class AESLightEngine
implements BlockCipher {
    private static final byte[] S;
    private static final byte[] Si;
    private static final int[] rcon;
    private static final int m1 = -2139062144;
    private static final int m2 = 0x7F7F7F7F;
    private static final int m3 = 27;
    private int ROUNDS;
    private int[][] WorkingKey = null;
    private int C0;
    private int C1;
    private int C2;
    private int C3;
    private boolean forEncryption;
    private static final int BLOCK_SIZE = 16;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = 99;
        byArray[1] = 124;
        byArray[2] = 119;
        byArray[3] = 123;
        byArray[4] = -14;
        byArray[5] = 107;
        byArray[6] = 111;
        byArray[7] = -59;
        byArray[8] = 48;
        byArray[9] = 1;
        byArray[10] = 103;
        byArray[11] = 43;
        byArray[12] = -2;
        byArray[13] = -41;
        byArray[14] = -85;
        byArray[15] = 118;
        byArray[16] = -54;
        byArray[17] = -126;
        byArray[18] = -55;
        byArray[19] = 125;
        byArray[20] = -6;
        byArray[21] = 89;
        byArray[22] = 71;
        byArray[23] = -16;
        byArray[24] = -83;
        byArray[25] = -44;
        byArray[26] = -94;
        byArray[27] = -81;
        byArray[28] = -100;
        byArray[29] = -92;
        byArray[30] = 114;
        byArray[31] = -64;
        byArray[32] = -73;
        byArray[33] = -3;
        byArray[34] = -109;
        byArray[35] = 38;
        byArray[36] = 54;
        byArray[37] = 63;
        byArray[38] = -9;
        byArray[39] = -52;
        byArray[40] = 52;
        byArray[41] = -91;
        byArray[42] = -27;
        byArray[43] = -15;
        byArray[44] = 113;
        byArray[45] = -40;
        byArray[46] = 49;
        byArray[47] = 21;
        byArray[48] = 4;
        byArray[49] = -57;
        byArray[50] = 35;
        byArray[51] = -61;
        byArray[52] = 24;
        byArray[53] = -106;
        byArray[54] = 5;
        byArray[55] = -102;
        byArray[56] = 7;
        byArray[57] = 18;
        byArray[58] = -128;
        byArray[59] = -30;
        byArray[60] = -21;
        byArray[61] = 39;
        byArray[62] = -78;
        byArray[63] = 117;
        byArray[64] = 9;
        byArray[65] = -125;
        byArray[66] = 44;
        byArray[67] = 26;
        byArray[68] = 27;
        byArray[69] = 110;
        byArray[70] = 90;
        byArray[71] = -96;
        byArray[72] = 82;
        byArray[73] = 59;
        byArray[74] = -42;
        byArray[75] = -77;
        byArray[76] = 41;
        byArray[77] = -29;
        byArray[78] = 47;
        byArray[79] = -124;
        byArray[80] = 83;
        byArray[81] = -47;
        byArray[83] = -19;
        byArray[84] = 32;
        byArray[85] = -4;
        byArray[86] = -79;
        byArray[87] = 91;
        byArray[88] = 106;
        byArray[89] = -53;
        byArray[90] = -66;
        byArray[91] = 57;
        byArray[92] = 74;
        byArray[93] = 76;
        byArray[94] = 88;
        byArray[95] = -49;
        byArray[96] = -48;
        byArray[97] = -17;
        byArray[98] = -86;
        byArray[99] = -5;
        byArray[100] = 67;
        byArray[101] = 77;
        byArray[102] = 51;
        byArray[103] = -123;
        byArray[104] = 69;
        byArray[105] = -7;
        byArray[106] = 2;
        byArray[107] = 127;
        byArray[108] = 80;
        byArray[109] = 60;
        byArray[110] = -97;
        byArray[111] = -88;
        byArray[112] = 81;
        byArray[113] = -93;
        byArray[114] = 64;
        byArray[115] = -113;
        byArray[116] = -110;
        byArray[117] = -99;
        byArray[118] = 56;
        byArray[119] = -11;
        byArray[120] = -68;
        byArray[121] = -74;
        byArray[122] = -38;
        byArray[123] = 33;
        byArray[124] = 16;
        byArray[125] = -1;
        byArray[126] = -13;
        byArray[127] = -46;
        byArray[128] = -51;
        byArray[129] = 12;
        byArray[130] = 19;
        byArray[131] = -20;
        byArray[132] = 95;
        byArray[133] = -105;
        byArray[134] = 68;
        byArray[135] = 23;
        byArray[136] = -60;
        byArray[137] = -89;
        byArray[138] = 126;
        byArray[139] = 61;
        byArray[140] = 100;
        byArray[141] = 93;
        byArray[142] = 25;
        byArray[143] = 115;
        byArray[144] = 96;
        byArray[145] = -127;
        byArray[146] = 79;
        byArray[147] = -36;
        byArray[148] = 34;
        byArray[149] = 42;
        byArray[150] = -112;
        byArray[151] = -120;
        byArray[152] = 70;
        byArray[153] = -18;
        byArray[154] = -72;
        byArray[155] = 20;
        byArray[156] = -34;
        byArray[157] = 94;
        byArray[158] = 11;
        byArray[159] = -37;
        byArray[160] = -32;
        byArray[161] = 50;
        byArray[162] = 58;
        byArray[163] = 10;
        byArray[164] = 73;
        byArray[165] = 6;
        byArray[166] = 36;
        byArray[167] = 92;
        byArray[168] = -62;
        byArray[169] = -45;
        byArray[170] = -84;
        byArray[171] = 98;
        byArray[172] = -111;
        byArray[173] = -107;
        byArray[174] = -28;
        byArray[175] = 121;
        byArray[176] = -25;
        byArray[177] = -56;
        byArray[178] = 55;
        byArray[179] = 109;
        byArray[180] = -115;
        byArray[181] = -43;
        byArray[182] = 78;
        byArray[183] = -87;
        byArray[184] = 108;
        byArray[185] = 86;
        byArray[186] = -12;
        byArray[187] = -22;
        byArray[188] = 101;
        byArray[189] = 122;
        byArray[190] = -82;
        byArray[191] = 8;
        byArray[192] = -70;
        byArray[193] = 120;
        byArray[194] = 37;
        byArray[195] = 46;
        byArray[196] = 28;
        byArray[197] = -90;
        byArray[198] = -76;
        byArray[199] = -58;
        byArray[200] = -24;
        byArray[201] = -35;
        byArray[202] = 116;
        byArray[203] = 31;
        byArray[204] = 75;
        byArray[205] = -67;
        byArray[206] = -117;
        byArray[207] = -118;
        byArray[208] = 112;
        byArray[209] = 62;
        byArray[210] = -75;
        byArray[211] = 102;
        byArray[212] = 72;
        byArray[213] = 3;
        byArray[214] = -10;
        byArray[215] = 14;
        byArray[216] = 97;
        byArray[217] = 53;
        byArray[218] = 87;
        byArray[219] = -71;
        byArray[220] = -122;
        byArray[221] = -63;
        byArray[222] = 29;
        byArray[223] = -98;
        byArray[224] = -31;
        byArray[225] = -8;
        byArray[226] = -104;
        byArray[227] = 17;
        byArray[228] = 105;
        byArray[229] = -39;
        byArray[230] = -114;
        byArray[231] = -108;
        byArray[232] = -101;
        byArray[233] = 30;
        byArray[234] = -121;
        byArray[235] = -23;
        byArray[236] = -50;
        byArray[237] = 85;
        byArray[238] = 40;
        byArray[239] = -33;
        byArray[240] = -116;
        byArray[241] = -95;
        byArray[242] = -119;
        byArray[243] = 13;
        byArray[244] = -65;
        byArray[245] = -26;
        byArray[246] = 66;
        byArray[247] = 104;
        byArray[248] = 65;
        byArray[249] = -103;
        byArray[250] = 45;
        byArray[251] = 15;
        byArray[252] = -80;
        byArray[253] = 84;
        byArray[254] = -69;
        byArray[255] = 22;
        S = byArray;
        byte[] byArray2 = new byte[256];
        byArray2[0] = 82;
        byArray2[1] = 9;
        byArray2[2] = 106;
        byArray2[3] = -43;
        byArray2[4] = 48;
        byArray2[5] = 54;
        byArray2[6] = -91;
        byArray2[7] = 56;
        byArray2[8] = -65;
        byArray2[9] = 64;
        byArray2[10] = -93;
        byArray2[11] = -98;
        byArray2[12] = -127;
        byArray2[13] = -13;
        byArray2[14] = -41;
        byArray2[15] = -5;
        byArray2[16] = 124;
        byArray2[17] = -29;
        byArray2[18] = 57;
        byArray2[19] = -126;
        byArray2[20] = -101;
        byArray2[21] = 47;
        byArray2[22] = -1;
        byArray2[23] = -121;
        byArray2[24] = 52;
        byArray2[25] = -114;
        byArray2[26] = 67;
        byArray2[27] = 68;
        byArray2[28] = -60;
        byArray2[29] = -34;
        byArray2[30] = -23;
        byArray2[31] = -53;
        byArray2[32] = 84;
        byArray2[33] = 123;
        byArray2[34] = -108;
        byArray2[35] = 50;
        byArray2[36] = -90;
        byArray2[37] = -62;
        byArray2[38] = 35;
        byArray2[39] = 61;
        byArray2[40] = -18;
        byArray2[41] = 76;
        byArray2[42] = -107;
        byArray2[43] = 11;
        byArray2[44] = 66;
        byArray2[45] = -6;
        byArray2[46] = -61;
        byArray2[47] = 78;
        byArray2[48] = 8;
        byArray2[49] = 46;
        byArray2[50] = -95;
        byArray2[51] = 102;
        byArray2[52] = 40;
        byArray2[53] = -39;
        byArray2[54] = 36;
        byArray2[55] = -78;
        byArray2[56] = 118;
        byArray2[57] = 91;
        byArray2[58] = -94;
        byArray2[59] = 73;
        byArray2[60] = 109;
        byArray2[61] = -117;
        byArray2[62] = -47;
        byArray2[63] = 37;
        byArray2[64] = 114;
        byArray2[65] = -8;
        byArray2[66] = -10;
        byArray2[67] = 100;
        byArray2[68] = -122;
        byArray2[69] = 104;
        byArray2[70] = -104;
        byArray2[71] = 22;
        byArray2[72] = -44;
        byArray2[73] = -92;
        byArray2[74] = 92;
        byArray2[75] = -52;
        byArray2[76] = 93;
        byArray2[77] = 101;
        byArray2[78] = -74;
        byArray2[79] = -110;
        byArray2[80] = 108;
        byArray2[81] = 112;
        byArray2[82] = 72;
        byArray2[83] = 80;
        byArray2[84] = -3;
        byArray2[85] = -19;
        byArray2[86] = -71;
        byArray2[87] = -38;
        byArray2[88] = 94;
        byArray2[89] = 21;
        byArray2[90] = 70;
        byArray2[91] = 87;
        byArray2[92] = -89;
        byArray2[93] = -115;
        byArray2[94] = -99;
        byArray2[95] = -124;
        byArray2[96] = -112;
        byArray2[97] = -40;
        byArray2[98] = -85;
        byArray2[100] = -116;
        byArray2[101] = -68;
        byArray2[102] = -45;
        byArray2[103] = 10;
        byArray2[104] = -9;
        byArray2[105] = -28;
        byArray2[106] = 88;
        byArray2[107] = 5;
        byArray2[108] = -72;
        byArray2[109] = -77;
        byArray2[110] = 69;
        byArray2[111] = 6;
        byArray2[112] = -48;
        byArray2[113] = 44;
        byArray2[114] = 30;
        byArray2[115] = -113;
        byArray2[116] = -54;
        byArray2[117] = 63;
        byArray2[118] = 15;
        byArray2[119] = 2;
        byArray2[120] = -63;
        byArray2[121] = -81;
        byArray2[122] = -67;
        byArray2[123] = 3;
        byArray2[124] = 1;
        byArray2[125] = 19;
        byArray2[126] = -118;
        byArray2[127] = 107;
        byArray2[128] = 58;
        byArray2[129] = -111;
        byArray2[130] = 17;
        byArray2[131] = 65;
        byArray2[132] = 79;
        byArray2[133] = 103;
        byArray2[134] = -36;
        byArray2[135] = -22;
        byArray2[136] = -105;
        byArray2[137] = -14;
        byArray2[138] = -49;
        byArray2[139] = -50;
        byArray2[140] = -16;
        byArray2[141] = -76;
        byArray2[142] = -26;
        byArray2[143] = 115;
        byArray2[144] = -106;
        byArray2[145] = -84;
        byArray2[146] = 116;
        byArray2[147] = 34;
        byArray2[148] = -25;
        byArray2[149] = -83;
        byArray2[150] = 53;
        byArray2[151] = -123;
        byArray2[152] = -30;
        byArray2[153] = -7;
        byArray2[154] = 55;
        byArray2[155] = -24;
        byArray2[156] = 28;
        byArray2[157] = 117;
        byArray2[158] = -33;
        byArray2[159] = 110;
        byArray2[160] = 71;
        byArray2[161] = -15;
        byArray2[162] = 26;
        byArray2[163] = 113;
        byArray2[164] = 29;
        byArray2[165] = 41;
        byArray2[166] = -59;
        byArray2[167] = -119;
        byArray2[168] = 111;
        byArray2[169] = -73;
        byArray2[170] = 98;
        byArray2[171] = 14;
        byArray2[172] = -86;
        byArray2[173] = 24;
        byArray2[174] = -66;
        byArray2[175] = 27;
        byArray2[176] = -4;
        byArray2[177] = 86;
        byArray2[178] = 62;
        byArray2[179] = 75;
        byArray2[180] = -58;
        byArray2[181] = -46;
        byArray2[182] = 121;
        byArray2[183] = 32;
        byArray2[184] = -102;
        byArray2[185] = -37;
        byArray2[186] = -64;
        byArray2[187] = -2;
        byArray2[188] = 120;
        byArray2[189] = -51;
        byArray2[190] = 90;
        byArray2[191] = -12;
        byArray2[192] = 31;
        byArray2[193] = -35;
        byArray2[194] = -88;
        byArray2[195] = 51;
        byArray2[196] = -120;
        byArray2[197] = 7;
        byArray2[198] = -57;
        byArray2[199] = 49;
        byArray2[200] = -79;
        byArray2[201] = 18;
        byArray2[202] = 16;
        byArray2[203] = 89;
        byArray2[204] = 39;
        byArray2[205] = -128;
        byArray2[206] = -20;
        byArray2[207] = 95;
        byArray2[208] = 96;
        byArray2[209] = 81;
        byArray2[210] = 127;
        byArray2[211] = -87;
        byArray2[212] = 25;
        byArray2[213] = -75;
        byArray2[214] = 74;
        byArray2[215] = 13;
        byArray2[216] = 45;
        byArray2[217] = -27;
        byArray2[218] = 122;
        byArray2[219] = -97;
        byArray2[220] = -109;
        byArray2[221] = -55;
        byArray2[222] = -100;
        byArray2[223] = -17;
        byArray2[224] = -96;
        byArray2[225] = -32;
        byArray2[226] = 59;
        byArray2[227] = 77;
        byArray2[228] = -82;
        byArray2[229] = 42;
        byArray2[230] = -11;
        byArray2[231] = -80;
        byArray2[232] = -56;
        byArray2[233] = -21;
        byArray2[234] = -69;
        byArray2[235] = 60;
        byArray2[236] = -125;
        byArray2[237] = 83;
        byArray2[238] = -103;
        byArray2[239] = 97;
        byArray2[240] = 23;
        byArray2[241] = 43;
        byArray2[242] = 4;
        byArray2[243] = 126;
        byArray2[244] = -70;
        byArray2[245] = 119;
        byArray2[246] = -42;
        byArray2[247] = 38;
        byArray2[248] = -31;
        byArray2[249] = 105;
        byArray2[250] = 20;
        byArray2[251] = 99;
        byArray2[252] = 85;
        byArray2[253] = 33;
        byArray2[254] = 12;
        byArray2[255] = 125;
        Si = byArray2;
        rcon = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145};
    }

    private int FFmulX(int n) {
        return (n & 0x7F7F7F7F) << 1 ^ ((n & 0x80808080) >>> 7) * 27;
    }

    private final void decryptBlock(int[][] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        this.C0 ^= nArray[this.ROUNDS][0];
        this.C1 ^= nArray[this.ROUNDS][1];
        this.C2 ^= nArray[this.ROUNDS][2];
        this.C3 ^= nArray[this.ROUNDS][3];
        int n5 = this.ROUNDS - 1;
        while (n5 > 1) {
            n4 = this.inv_mcol(Si[this.C0 & 0xFF] & 0xFF ^ (Si[this.C3 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C2 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C1 >> 24 & 0xFF] << 24) ^ nArray[n5][0];
            n3 = this.inv_mcol(Si[this.C1 & 0xFF] & 0xFF ^ (Si[this.C0 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C3 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C2 >> 24 & 0xFF] << 24) ^ nArray[n5][1];
            n2 = this.inv_mcol(Si[this.C2 & 0xFF] & 0xFF ^ (Si[this.C1 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C0 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C3 >> 24 & 0xFF] << 24) ^ nArray[n5][2];
            n = this.inv_mcol(Si[this.C3 & 0xFF] & 0xFF ^ (Si[this.C2 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C1 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C0 >> 24 & 0xFF] << 24) ^ nArray[n5--][3];
            this.C0 = this.inv_mcol(Si[n4 & 0xFF] & 0xFF ^ (Si[n >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n2 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n3 >> 24 & 0xFF] << 24) ^ nArray[n5][0];
            this.C1 = this.inv_mcol(Si[n3 & 0xFF] & 0xFF ^ (Si[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n2 >> 24 & 0xFF] << 24) ^ nArray[n5][1];
            this.C2 = this.inv_mcol(Si[n2 & 0xFF] & 0xFF ^ (Si[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n >> 24 & 0xFF] << 24) ^ nArray[n5][2];
            this.C3 = this.inv_mcol(Si[n & 0xFF] & 0xFF ^ (Si[n2 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n4 >> 24 & 0xFF] << 24) ^ nArray[n5--][3];
        }
        n4 = this.inv_mcol(Si[this.C0 & 0xFF] & 0xFF ^ (Si[this.C3 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C2 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C1 >> 24 & 0xFF] << 24) ^ nArray[n5][0];
        n3 = this.inv_mcol(Si[this.C1 & 0xFF] & 0xFF ^ (Si[this.C0 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C3 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C2 >> 24 & 0xFF] << 24) ^ nArray[n5][1];
        n2 = this.inv_mcol(Si[this.C2 & 0xFF] & 0xFF ^ (Si[this.C1 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C0 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C3 >> 24 & 0xFF] << 24) ^ nArray[n5][2];
        n = this.inv_mcol(Si[this.C3 & 0xFF] & 0xFF ^ (Si[this.C2 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C1 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C0 >> 24 & 0xFF] << 24) ^ nArray[n5--][3];
        this.C0 = Si[n4 & 0xFF] & 0xFF ^ (Si[n >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n2 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n3 >> 24 & 0xFF] << 24 ^ nArray[0][0];
        this.C1 = Si[n3 & 0xFF] & 0xFF ^ (Si[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n2 >> 24 & 0xFF] << 24 ^ nArray[0][1];
        this.C2 = Si[n2 & 0xFF] & 0xFF ^ (Si[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n >> 24 & 0xFF] << 24 ^ nArray[0][2];
        this.C3 = Si[n & 0xFF] & 0xFF ^ (Si[n2 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n4 >> 24 & 0xFF] << 24 ^ nArray[0][3];
    }

    private void encryptBlock(int[][] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        this.C0 ^= nArray[0][0];
        this.C1 ^= nArray[0][1];
        this.C2 ^= nArray[0][2];
        this.C3 ^= nArray[0][3];
        int n5 = 1;
        while (n5 < this.ROUNDS - 1) {
            n4 = this.mcol(S[this.C0 & 0xFF] & 0xFF ^ (S[this.C1 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C2 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C3 >> 24 & 0xFF] << 24) ^ nArray[n5][0];
            n3 = this.mcol(S[this.C1 & 0xFF] & 0xFF ^ (S[this.C2 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C3 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C0 >> 24 & 0xFF] << 24) ^ nArray[n5][1];
            n2 = this.mcol(S[this.C2 & 0xFF] & 0xFF ^ (S[this.C3 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C0 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C1 >> 24 & 0xFF] << 24) ^ nArray[n5][2];
            n = this.mcol(S[this.C3 & 0xFF] & 0xFF ^ (S[this.C0 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C1 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C2 >> 24 & 0xFF] << 24) ^ nArray[n5++][3];
            this.C0 = this.mcol(S[n4 & 0xFF] & 0xFF ^ (S[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n2 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n >> 24 & 0xFF] << 24) ^ nArray[n5][0];
            this.C1 = this.mcol(S[n3 & 0xFF] & 0xFF ^ (S[n2 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n >> 16 & 0xFF] & 0xFF) << 16 ^ S[n4 >> 24 & 0xFF] << 24) ^ nArray[n5][1];
            this.C2 = this.mcol(S[n2 & 0xFF] & 0xFF ^ (S[n >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n3 >> 24 & 0xFF] << 24) ^ nArray[n5][2];
            this.C3 = this.mcol(S[n & 0xFF] & 0xFF ^ (S[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n2 >> 24 & 0xFF] << 24) ^ nArray[n5++][3];
        }
        n4 = this.mcol(S[this.C0 & 0xFF] & 0xFF ^ (S[this.C1 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C2 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C3 >> 24 & 0xFF] << 24) ^ nArray[n5][0];
        n3 = this.mcol(S[this.C1 & 0xFF] & 0xFF ^ (S[this.C2 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C3 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C0 >> 24 & 0xFF] << 24) ^ nArray[n5][1];
        n2 = this.mcol(S[this.C2 & 0xFF] & 0xFF ^ (S[this.C3 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C0 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C1 >> 24 & 0xFF] << 24) ^ nArray[n5][2];
        n = this.mcol(S[this.C3 & 0xFF] & 0xFF ^ (S[this.C0 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C1 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C2 >> 24 & 0xFF] << 24) ^ nArray[n5++][3];
        this.C0 = S[n4 & 0xFF] & 0xFF ^ (S[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n2 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n >> 24 & 0xFF] << 24 ^ nArray[n5][0];
        this.C1 = S[n3 & 0xFF] & 0xFF ^ (S[n2 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n >> 16 & 0xFF] & 0xFF) << 16 ^ S[n4 >> 24 & 0xFF] << 24 ^ nArray[n5][1];
        this.C2 = S[n2 & 0xFF] & 0xFF ^ (S[n >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n3 >> 24 & 0xFF] << 24 ^ nArray[n5][2];
        this.C3 = S[n & 0xFF] & 0xFF ^ (S[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n2 >> 24 & 0xFF] << 24 ^ nArray[n5][3];
    }

    private int[][] generateWorkingKey(byte[] byArray, boolean bl) {
        int n;
        int n2 = byArray.length / 4;
        if (n2 != 4 && n2 != 6 && n2 != 8 || n2 * 4 != byArray.length) {
            throw new IllegalArgumentException("Key length not 128/192/256 bits.");
        }
        this.ROUNDS = n2 + 6;
        int[][] nArray = new int[this.ROUNDS + 1][4];
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            nArray[n3 >> 2][n3 & 3] = byArray[n4] & 0xFF | (byArray[n4 + 1] & 0xFF) << 8 | (byArray[n4 + 2] & 0xFF) << 16 | byArray[n4 + 3] << 24;
            n4 += 4;
            ++n3;
        }
        int n5 = this.ROUNDS + 1 << 2;
        int n6 = n2;
        while (n6 < n5) {
            n = nArray[n6 - 1 >> 2][n6 - 1 & 3];
            if (n6 % n2 == 0) {
                n = this.subWord(this.shift(n, 8)) ^ rcon[n6 / n2 - 1];
            } else if (n2 > 6 && n6 % n2 == 4) {
                n = this.subWord(n);
            }
            nArray[n6 >> 2][n6 & 3] = nArray[n6 - n2 >> 2][n6 - n2 & 3] ^ n;
            ++n6;
        }
        if (!bl) {
            n = 1;
            while (n < this.ROUNDS) {
                int n7 = 0;
                while (n7 < 4) {
                    nArray[n][n7] = this.inv_mcol(nArray[n][n7]);
                    ++n7;
                }
                ++n;
            }
        }
        return nArray;
    }

    public String getAlgorithmName() {
        return "AES";
    }

    public int getBlockSize() {
        return 16;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.WorkingKey = this.generateWorkingKey(((KeyParameter)cipherParameters).getKey(), bl);
            this.forEncryption = bl;
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to AES init - " + cipherParameters.getClass().getName());
    }

    private int inv_mcol(int n) {
        int n2 = this.FFmulX(n);
        int n3 = this.FFmulX(n2);
        int n4 = this.FFmulX(n3);
        int n5 = n ^ n4;
        return n2 ^ n3 ^ n4 ^ this.shift(n2 ^ n5, 8) ^ this.shift(n3 ^ n5, 16) ^ this.shift(n5, 24);
    }

    private int mcol(int n) {
        int n2 = this.FFmulX(n);
        return n2 ^ this.shift(n ^ n2, 8) ^ this.shift(n, 16) ^ this.shift(n, 24);
    }

    private final void packBlock(byte[] byArray, int n) {
        int n2 = n;
        byArray[n2++] = (byte)this.C0;
        byArray[n2++] = (byte)(this.C0 >> 8);
        byArray[n2++] = (byte)(this.C0 >> 16);
        byArray[n2++] = (byte)(this.C0 >> 24);
        byArray[n2++] = (byte)this.C1;
        byArray[n2++] = (byte)(this.C1 >> 8);
        byArray[n2++] = (byte)(this.C1 >> 16);
        byArray[n2++] = (byte)(this.C1 >> 24);
        byArray[n2++] = (byte)this.C2;
        byArray[n2++] = (byte)(this.C2 >> 8);
        byArray[n2++] = (byte)(this.C2 >> 16);
        byArray[n2++] = (byte)(this.C2 >> 24);
        byArray[n2++] = (byte)this.C3;
        byArray[n2++] = (byte)(this.C3 >> 8);
        byArray[n2++] = (byte)(this.C3 >> 16);
        byArray[n2++] = (byte)(this.C3 >> 24);
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.WorkingKey == null) {
            throw new IllegalStateException("AES engine not initialised");
        }
        if (n + 16 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 + 16 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.forEncryption) {
            this.unpackBlock(byArray, n);
            this.encryptBlock(this.WorkingKey);
            this.packBlock(byArray2, n2);
        } else {
            this.unpackBlock(byArray, n);
            this.decryptBlock(this.WorkingKey);
            this.packBlock(byArray2, n2);
        }
        return 16;
    }

    public void reset() {
    }

    private int shift(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    private int subWord(int n) {
        return S[n & 0xFF] & 0xFF | (S[n >> 8 & 0xFF] & 0xFF) << 8 | (S[n >> 16 & 0xFF] & 0xFF) << 16 | S[n >> 24 & 0xFF] << 24;
    }

    private final void unpackBlock(byte[] byArray, int n) {
        int n2 = n;
        this.C0 = byArray[n2++] & 0xFF;
        this.C0 |= (byArray[n2++] & 0xFF) << 8;
        this.C0 |= (byArray[n2++] & 0xFF) << 16;
        this.C0 |= byArray[n2++] << 24;
        this.C1 = byArray[n2++] & 0xFF;
        this.C1 |= (byArray[n2++] & 0xFF) << 8;
        this.C1 |= (byArray[n2++] & 0xFF) << 16;
        this.C1 |= byArray[n2++] << 24;
        this.C2 = byArray[n2++] & 0xFF;
        this.C2 |= (byArray[n2++] & 0xFF) << 8;
        this.C2 |= (byArray[n2++] & 0xFF) << 16;
        this.C2 |= byArray[n2++] << 24;
        this.C3 = byArray[n2++] & 0xFF;
        this.C3 |= (byArray[n2++] & 0xFF) << 8;
        this.C3 |= (byArray[n2++] & 0xFF) << 16;
        this.C3 |= byArray[n2++] << 24;
    }
}

