/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public AsymmetricCipherKeyPair generateKeyPair() {
        int n = this.param.getStrength() - 1;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHParameters.getP();
        BigInteger bigInteger2 = dHParameters.getG();
        BigInteger bigInteger3 = new BigInteger(n, this.param.getRandom());
        BigInteger bigInteger4 = bigInteger2.modPow(bigInteger3, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger4, dHParameters), new DHPrivateKeyParameters(bigInteger3, dHParameters));
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
    }
}

