/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECConstants;

public abstract class ECFieldElement
implements ECConstants {
    BigInteger x;
    BigInteger p;

    protected ECFieldElement(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.compareTo(bigInteger) >= 0) {
            throw new IllegalArgumentException("x value too large in field element");
        }
        this.x = bigInteger2;
        this.p = bigInteger;
    }

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement divide(ECFieldElement var1);

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECFieldElement)) {
            return false;
        }
        ECFieldElement eCFieldElement = (ECFieldElement)object;
        return this.p.equals(eCFieldElement.p) && this.x.equals(eCFieldElement.x);
    }

    public abstract String getFieldName();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public abstract ECFieldElement sqrt();

    public abstract ECFieldElement square();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public BigInteger toBigInteger() {
        return this.x;
    }

    public static class Fp
    extends ECFieldElement {
        public Fp(BigInteger bigInteger, BigInteger bigInteger2) {
            super(bigInteger, bigInteger2);
        }

        public ECFieldElement add(ECFieldElement eCFieldElement) {
            return new Fp(this.p, this.x.add(eCFieldElement.x).mod(this.p));
        }

        public ECFieldElement divide(ECFieldElement eCFieldElement) {
            return new Fp(this.p, this.x.multiply(eCFieldElement.x.modInverse(this.p)).mod(this.p));
        }

        public String getFieldName() {
            return "Fp";
        }

        public ECFieldElement invert() {
            return new Fp(this.p, this.x.modInverse(this.p));
        }

        public ECFieldElement multiply(ECFieldElement eCFieldElement) {
            return new Fp(this.p, this.x.multiply(eCFieldElement.x).mod(this.p));
        }

        public ECFieldElement negate() {
            return new Fp(this.p, this.x.negate().mod(this.p));
        }

        public ECFieldElement sqrt() {
            if (this.p.testBit(1)) {
                Fp fp = new Fp(this.p, this.x.modPow(this.p.shiftRight(2).add(ECConstants.ONE), this.p));
                return ((ECFieldElement)fp).square().equals(this) ? fp : null;
            }
            throw new RuntimeException("not done yet");
        }

        public ECFieldElement square() {
            return new Fp(this.p, this.x.multiply(this.x).mod(this.p));
        }

        public ECFieldElement subtract(ECFieldElement eCFieldElement) {
            return new Fp(this.p, this.x.subtract(eCFieldElement.x).mod(this.p));
        }
    }
}

