/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.ECGOST3410NamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPointEncoder;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.ProviderUtil;
import org.bouncycastle.jce.provider.asymmetric.ec.ECUtil;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class JCEECPublicKey
implements ECPublicKey,
ECPointEncoder {
    private String algorithm = "EC";
    private ECPoint q;
    private ECParameterSpec ecSpec;
    private boolean withCompression;
    private GOST3410PublicKeyAlgParameters gostParams;

    public JCEECPublicKey(String string, JCEECPublicKey jCEECPublicKey) {
        this.algorithm = string;
        this.q = jCEECPublicKey.q;
        this.ecSpec = jCEECPublicKey.ecSpec;
        this.withCompression = jCEECPublicKey.withCompression;
        this.gostParams = jCEECPublicKey.gostParams;
    }

    public JCEECPublicKey(String string, ECPublicKeySpec eCPublicKeySpec) {
        this.algorithm = string;
        this.q = eCPublicKeySpec.getQ();
        if (eCPublicKeySpec.getParams() != null) {
            this.ecSpec = eCPublicKeySpec.getParams();
        } else {
            if (this.q.getCurve() == null) {
                ECParameterSpec eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
                this.q = eCParameterSpec.getCurve().createPoint(this.q.getX().toBigInteger(), this.q.getY().toBigInteger(), false);
            }
            this.ecSpec = null;
        }
    }

    public JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        this.ecSpec = eCParameterSpec == null ? new ECParameterSpec(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed()) : eCParameterSpec;
    }

    public JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters) {
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        this.ecSpec = null;
    }

    JCEECPublicKey(ECPublicKey eCPublicKey) {
        this.q = eCPublicKey.getQ();
        this.algorithm = eCPublicKey.getAlgorithm();
        this.ecSpec = eCPublicKey.getParameters();
    }

    JCEECPublicKey(String string, ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        this.algorithm = string;
        this.q = eCPoint;
        this.ecSpec = eCParameterSpec;
    }

    JCEECPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.populateFromPubKeyInfo(subjectPublicKeyInfo);
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        if (subjectPublicKeyInfo.getAlgorithmId().getObjectId().equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            int n;
            ASN1OctetString aSN1OctetString;
            DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
            this.algorithm = "ECGOST3410";
            try {
                aSN1OctetString = (ASN1OctetString)ASN1Object.fromByteArray(dERBitString.getBytes());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
            byte[] byArray = aSN1OctetString.getOctets();
            byte[] byArray2 = new byte[32];
            byte[] byArray3 = new byte[32];
            for (n = 0; n != byArray2.length; ++n) {
                byArray2[n] = byArray[31 - n];
            }
            for (n = 0; n != byArray3.length; ++n) {
                byArray3[n] = byArray[63 - n];
            }
            this.gostParams = new GOST3410PublicKeyAlgParameters((ASN1Sequence)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()));
            this.ecSpec = eCNamedCurveParameterSpec;
            this.q = eCNamedCurveParameterSpec.getCurve().createPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3), false);
        } else {
            int n;
            ECCurve eCCurve;
            Object object;
            ASN1Encodable aSN1Encodable;
            X962Parameters x962Parameters = new X962Parameters((DERObject)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            if (x962Parameters.isNamedCurve()) {
                aSN1Encodable = (DERObjectIdentifier)x962Parameters.getParameters();
                object = ECUtil.getNamedCurveByOid((DERObjectIdentifier)aSN1Encodable);
                this.ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName((DERObjectIdentifier)aSN1Encodable), ((X9ECParameters)object).getCurve(), ((X9ECParameters)object).getG(), ((X9ECParameters)object).getN(), ((X9ECParameters)object).getH(), ((X9ECParameters)object).getSeed());
                eCCurve = this.ecSpec.getCurve();
            } else if (x962Parameters.isImplicitlyCA()) {
                this.ecSpec = null;
                eCCurve = ProviderUtil.getEcImplicitlyCa().getCurve();
            } else {
                aSN1Encodable = new X9ECParameters((ASN1Sequence)x962Parameters.getParameters());
                this.ecSpec = new ECParameterSpec(((X9ECParameters)aSN1Encodable).getCurve(), ((X9ECParameters)aSN1Encodable).getG(), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH(), ((X9ECParameters)aSN1Encodable).getSeed());
                eCCurve = this.ecSpec.getCurve();
            }
            aSN1Encodable = subjectPublicKeyInfo.getPublicKeyData();
            object = ((DERBitString)aSN1Encodable).getBytes();
            ASN1OctetString aSN1OctetString = new DEROctetString((byte[])object);
            if (object[0] == 4 && object[1] == ((Object)object).length - 2 && (object[2] == 2 || object[2] == 3) && (n = new X9IntegerConverter().getByteLength(eCCurve)) >= ((Object)object).length - 3) {
                try {
                    aSN1OctetString = (ASN1OctetString)ASN1Object.fromByteArray((byte[])object);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
            X9ECPoint x9ECPoint = new X9ECPoint(eCCurve, aSN1OctetString);
            this.q = x9ECPoint.getPoint();
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        if (this.algorithm.equals("ECGOST3410")) {
            int n;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ASN1Encodable aSN1Encodable = null;
            if (this.gostParams != null) {
                aSN1Encodable = this.gostParams;
            } else if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
                aSN1Encodable = new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveParameterSpec)this.ecSpec).getName()), CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet);
            } else {
                object4 = this.ecSpec;
                object3 = ((ECParameterSpec)object4).getG().getCurve();
                object2 = ((ECCurve)object3).createPoint(((ECParameterSpec)object4).getG().getX().toBigInteger(), ((ECParameterSpec)object4).getG().getY().toBigInteger(), this.withCompression);
                object = new X9ECParameters(((ECParameterSpec)object4).getCurve(), (ECPoint)object2, ((ECParameterSpec)object4).getN(), ((ECParameterSpec)object4).getH(), ((ECParameterSpec)object4).getSeed());
                aSN1Encodable = new X962Parameters((X9ECParameters)object);
            }
            object4 = this.getQ();
            object3 = ((ECPoint)object4).getCurve().createPoint(((ECPoint)object4).getX().toBigInteger(), ((ECPoint)object4).getY().toBigInteger(), false);
            object2 = (ASN1OctetString)new X9ECPoint((ECPoint)object3).getDERObject();
            object = this.q.getX().toBigInteger();
            BigInteger bigInteger = this.q.getY().toBigInteger();
            byte[] byArray = new byte[64];
            byte[] byArray2 = ((BigInteger)object).toByteArray();
            for (n = 0; n != 32; ++n) {
                byArray[n] = byArray2[byArray2.length - 1 - n];
            }
            byArray2 = bigInteger.toByteArray();
            for (n = 0; n != 32; ++n) {
                byArray[32 + n] = byArray2[byArray2.length - 1 - n];
            }
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, aSN1Encodable.getDERObject()), new DEROctetString(byArray));
        } else {
            Object object;
            Object object5;
            Object object6;
            X962Parameters x962Parameters = null;
            if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
                object6 = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)this.ecSpec).getName());
                x962Parameters = new X962Parameters((DERObjectIdentifier)object6);
            } else if (this.ecSpec == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else {
                object6 = this.ecSpec;
                object5 = ((ECParameterSpec)object6).getG().getCurve();
                object = ((ECCurve)object5).createPoint(((ECParameterSpec)object6).getG().getX().toBigInteger(), ((ECParameterSpec)object6).getG().getY().toBigInteger(), this.withCompression);
                X9ECParameters x9ECParameters = new X9ECParameters(((ECParameterSpec)object6).getCurve(), (ECPoint)object, ((ECParameterSpec)object6).getN(), ((ECParameterSpec)object6).getH(), ((ECParameterSpec)object6).getSeed());
                x962Parameters = new X962Parameters(x9ECParameters);
            }
            object6 = this.engineGetQ().getCurve();
            object5 = ((ECCurve)object6).createPoint(this.getQ().getX().toBigInteger(), this.getQ().getY().toBigInteger(), this.withCompression);
            object = (ASN1OctetString)new X9ECPoint((ECPoint)object5).getDERObject();
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters.getDERObject()), ((ASN1OctetString)object).getOctets());
        }
        return subjectPublicKeyInfo.getDEREncoded();
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public ECParameterSpec getParameters() {
        return this.ecSpec;
    }

    public ECPoint getQ() {
        if (this.ecSpec == null) {
            if (this.q instanceof ECPoint.Fp) {
                return new ECPoint.Fp(null, this.q.getX(), this.q.getY());
            }
            return new ECPoint.F2m(null, this.q.getX(), this.q.getY());
        }
        return this.q;
    }

    public ECPoint engineGetQ() {
        return this.q;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("EC Public Key").append(string);
        stringBuffer.append("            X: ").append(this.getQ().getX().toBigInteger().toString(16)).append(string);
        stringBuffer.append("            Y: ").append(this.getQ().getY().toBigInteger().toString(16)).append(string);
        return stringBuffer.toString();
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return this.ecSpec;
        }
        return ProviderUtil.getEcImplicitlyCa();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JCEECPublicKey)) {
            return false;
        }
        JCEECPublicKey jCEECPublicKey = (JCEECPublicKey)object;
        return this.getQ().equals(jCEECPublicKey.getQ()) && this.engineGetSpec().equals(jCEECPublicKey.engineGetSpec());
    }

    public int hashCode() {
        return this.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(byArray)));
        this.algorithm = (String)objectInputStream.readObject();
        this.withCompression = objectInputStream.readBoolean();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getEncoded());
        objectOutputStream.writeObject(this.algorithm);
        objectOutputStream.writeBoolean(this.withCompression);
    }
}

