/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.drbg;

import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

public class DRBG {
    private static final String PREFIX = DRBG.class.getName();

    private static byte[] generateDefaultPersonalizationString(SecureRandom secureRandom) {
        return Arrays.concatenate(Strings.toByteArray("Default"), secureRandom.generateSeed(16), Strings.toByteArray(Thread.currentThread().toString()), Pack.longToBigEndian(System.currentTimeMillis()));
    }

    private static byte[] generateNonceIVPersonalizationString(SecureRandom secureRandom) {
        return Arrays.concatenate(Strings.toByteArray("Nonce"), secureRandom.generateSeed(16), Strings.toByteArray(Thread.currentThread().toString()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }

    static /* synthetic */ byte[] access$000(SecureRandom secureRandom) {
        return DRBG.generateDefaultPersonalizationString(secureRandom);
    }

    static /* synthetic */ byte[] access$100(SecureRandom secureRandom) {
        return DRBG.generateNonceIVPersonalizationString(secureRandom);
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("SecureRandom.DEFAULT", PREFIX + "$Default");
            configurableProvider.addAlgorithm("SecureRandom.NONCEANDIV", PREFIX + "$NonceAndIV");
        }
    }

    public static class NonceAndIV
    extends SecureRandomSpi {
        private SecureRandom randomSource = new SecureRandom();
        private SecureRandom random = new SP800SecureRandomBuilder(this.randomSource, true).setPersonalizationString(DRBG.access$100(this.randomSource)).buildHash(new SHA512Digest(), this.randomSource.generateSeed(32), false);

        protected void engineSetSeed(byte[] byArray) {
            this.random.setSeed(byArray);
        }

        protected void engineNextBytes(byte[] byArray) {
            this.random.nextBytes(byArray);
        }

        protected byte[] engineGenerateSeed(int n) {
            return this.randomSource.generateSeed(n);
        }
    }

    public static class Default
    extends SecureRandomSpi {
        private SecureRandom randomSource = new SecureRandom();
        private SecureRandom random = new SP800SecureRandomBuilder(this.randomSource, true).setPersonalizationString(DRBG.access$000(this.randomSource)).buildHash(new SHA512Digest(), this.randomSource.generateSeed(32), true);

        protected void engineSetSeed(byte[] byArray) {
            this.random.setSeed(byArray);
        }

        protected void engineNextBytes(byte[] byArray) {
            this.random.nextBytes(byArray);
        }

        protected byte[] engineGenerateSeed(int n) {
            return this.randomSource.generateSeed(n);
        }
    }
}

