/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PSSParameterSpec;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSParamSpec;
import org.bouncycastle.jcajce.util.MessageDigestUtils;

public abstract class AlgorithmParametersSpi
extends java.security.AlgorithmParametersSpi {
    static /* synthetic */ Class class$java$security$spec$AlgorithmParameterSpec;
    static /* synthetic */ Class class$java$security$spec$PSSParameterSpec;

    protected boolean isASN1FormatString(String string) {
        return string == null || string.equals("ASN.1");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz == null) {
            throw new NullPointerException("argument to getParameterSpec must not be null");
        }
        return this.localEngineGetParameterSpec(clazz);
    }

    protected abstract AlgorithmParameterSpec localEngineGetParameterSpec(Class var1) throws InvalidParameterSpecException;

    public static class PSS
    extends AlgorithmParametersSpi {
        PSSParameterSpec currentSpec;

        protected byte[] engineGetEncoded() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            PSSParameterSpec pSSParameterSpec = this.currentSpec;
            RSASSAPSSparams rSASSAPSSparams = new RSASSAPSSparams(RSASSAPSSparams.DEFAULT_HASH_ALGORITHM, RSASSAPSSparams.DEFAULT_MASK_GEN_FUNCTION, new ASN1Integer(pSSParameterSpec.getSaltLength()), RSASSAPSSparams.DEFAULT_TRAILER_FIELD);
            dEROutputStream.writeObject(rSASSAPSSparams);
            dEROutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }

        protected byte[] engineGetEncoded(String string) throws IOException {
            if (string.equalsIgnoreCase("X.509") || string.equalsIgnoreCase("ASN.1")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$java$security$spec$PSSParameterSpec == null ? (class$java$security$spec$PSSParameterSpec = AlgorithmParametersSpi.class$("java.security.spec.PSSParameterSpec")) : class$java$security$spec$PSSParameterSpec) || clazz == (class$java$security$spec$AlgorithmParameterSpec == null ? (class$java$security$spec$AlgorithmParameterSpec = AlgorithmParametersSpi.class$("java.security.spec.AlgorithmParameterSpec")) : class$java$security$spec$AlgorithmParameterSpec)) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to PSS parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
                throw new InvalidParameterSpecException("PSSParameterSpec required to initialise an PSS algorithm parameters object");
            }
            this.currentSpec = (PSSParameterSpec)algorithmParameterSpec;
        }

        protected void engineInit(byte[] byArray) throws IOException {
            try {
                RSASSAPSSparams rSASSAPSSparams = RSASSAPSSparams.getInstance(byArray);
                String string = MessageDigestUtils.getDigestName(rSASSAPSSparams.getHashAlgorithm().getAlgorithm());
                this.currentSpec = new PSSParamSpec(rSASSAPSSparams.getSaltLength().intValue(), string);
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Not a valid PSS Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Not a valid PSS Parameter encoding.");
            }
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (!this.isASN1FormatString(string) && !string.equalsIgnoreCase("X.509")) {
                throw new IOException("Unknown parameter format " + string);
            }
            this.engineInit(byArray);
        }

        protected String engineToString() {
            return "PSS Parameters";
        }
    }

    public static class OAEP
    extends AlgorithmParametersSpi {
        AlgorithmParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            return null;
        }

        protected byte[] engineGetEncoded(String string) {
            if (this.isASN1FormatString(string) || string.equalsIgnoreCase("X.509")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$java$security$spec$AlgorithmParameterSpec == null ? (class$java$security$spec$AlgorithmParameterSpec = AlgorithmParametersSpi.class$("java.security.spec.AlgorithmParameterSpec")) : class$java$security$spec$AlgorithmParameterSpec)) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to OAEP parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            this.currentSpec = algorithmParameterSpec;
        }

        protected void engineInit(byte[] byArray) throws IOException {
            try {
                RSAESOAEPparams rSAESOAEPparams = RSAESOAEPparams.getInstance(byArray);
                throw new IOException("Operation not supported");
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Not a valid OAEP Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Not a valid OAEP Parameter encoding.");
            }
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (!string.equalsIgnoreCase("X.509") && !string.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown parameter format " + string);
            }
            this.engineInit(byArray);
        }

        protected String engineToString() {
            return "OAEP Parameters";
        }
    }
}

