/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import org.bouncycastle.math.raw.Bits;

public class Integers {
    private static final byte[] DEBRUIJN_TZ = new byte[]{0, 1, 2, 24, 3, 19, 6, 25, 22, 4, 20, 10, 16, 7, 12, 26, 31, 23, 18, 5, 21, 9, 15, 11, 30, 17, 8, 14, 29, 13, 28, 27};

    public static int numberOfLeadingZeros(int n) {
        if (n <= 0) {
            return ~n >>> 26 & 0x20;
        }
        int n2 = 1;
        if (0 == n >>> 16) {
            n2 += 16;
            n <<= 16;
        }
        if (0 == n >>> 24) {
            n2 += 8;
            n <<= 8;
        }
        if (0 == n >>> 28) {
            n2 += 4;
            n <<= 4;
        }
        if (0 == n >>> 30) {
            n2 += 2;
            n <<= 2;
        }
        return n2 -= n >>> 31;
    }

    public static int numberOfTrailingZeros(int n) {
        return DEBRUIJN_TZ[(n & -n) * 81224991 >>> 27];
    }

    public static int reverse(int n) {
        n = Bits.bitPermuteStepSimple(n, 0x55555555, 1);
        n = Bits.bitPermuteStepSimple(n, 0x33333333, 2);
        n = Bits.bitPermuteStepSimple(n, 0xF0F0F0F, 4);
        return Integers.reverseBytes(n);
    }

    public static int reverseBytes(int n) {
        return Integers.rotateLeft(n & 0xFF00FF00, 8) | Integers.rotateLeft(n & 0xFF00FF, 24);
    }

    public static int rotateLeft(int n, int n2) {
        return n << n2 ^ n >>> -n2;
    }

    public static int rotateRight(int n, int n2) {
        return n >>> n2 ^ n << -n2;
    }

    public static Integer valueOf(int n) {
        return new Integer(n);
    }
}

