/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.LimitedInputStream;

class DefiniteLengthInputStream
extends LimitedInputStream {
    private int _length;

    DefiniteLengthInputStream(InputStream inputStream, int n) {
        super(inputStream);
        if (n < 0) {
            throw new IllegalArgumentException("negative lengths not allowed");
        }
        this._length = n;
    }

    @Override
    public int read() throws IOException {
        if (this._length > 0) {
            int n = this._in.read();
            if (n < 0) {
                throw new EOFException();
            }
            --this._length;
            return n;
        }
        this.setParentEofDetect(true);
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this._length > 0) {
            int n3 = Math.min(n2, this._length);
            int n4 = this._in.read(byArray, n, n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            this._length -= n4;
            return n4;
        }
        this.setParentEofDetect(true);
        return -1;
    }

    byte[] toByteArray() throws IOException {
        byte[] byArray = new byte[this._length];
        if (this._length > 0) {
            int n;
            int n2 = 0;
            do {
                if ((n = this._in.read(byArray, n2, this._length - n2)) >= 0) continue;
                throw new EOFException();
            } while ((n2 += n) < this._length);
            this._length = 0;
        }
        this.setParentEofDetect(true);
        return byArray;
    }
}

