/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class NativeFeatures {
    private static final Logger LOG = Logger.getLogger(NativeFeatures.class.getName());

    NativeFeatures() {
    }

    static boolean hasCTRHardwareSupport() {
        try {
            return NativeFeatures.nativeCTR();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native ctr exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeCTR();

    static boolean hasCFBHardwareSupport() {
        try {
            return NativeFeatures.nativeCFB();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native cfb exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeCFB();

    static boolean hasCBCHardwareSupport() {
        try {
            return NativeFeatures.nativeCBC();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native cbc exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeCBC();

    static boolean hasAESHardwareSupport() {
        try {
            return NativeFeatures.nativeAES();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native aes exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeAES();

    static boolean hasGCMHardwareSupport() {
        try {
            return NativeFeatures.nativeGCM();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native gcm exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeGCM();

    static boolean hasGCMSIVHardwareSupport() {
        try {
            return NativeFeatures.nativeGCMSIV();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native gcm-siv exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeGCMSIV();

    static boolean hasCCMHardwareSupport() {
        try {
            return NativeFeatures.nativeCCM();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native ccm exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeCCM();

    static boolean hasCCMPCHardwareSupport() {
        try {
            return NativeFeatures.nativeCCMPC();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "native ccm packet cipher exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeCCMPC();

    static boolean hasCBCPCHardwareSupport() {
        try {
            return NativeFeatures.nativeCBCPC();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "native cbc packet cipher exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeCBCPC();

    static boolean hasCFBPCHardwareSupport() {
        try {
            return NativeFeatures.nativeCFBPC();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "native cfb packet cipher exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeCFBPC();

    static boolean hasCTRPCHardwareSupport() {
        try {
            return NativeFeatures.nativeCTRPC();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "native ctr packet cipher exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeCTRPC();

    static boolean hasGCMPCHardwareSupport() {
        try {
            return NativeFeatures.nativeGCMPC();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "native gcm packet cipher exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeGCMPC();

    static boolean hasGCMSIVPCHardwareSupport() {
        try {
            return NativeFeatures.nativeGCMSIVPC();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "native gcm-siv packet cipher exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeGCMSIVPC();

    static boolean hasHardwareRand() {
        try {
            return NativeFeatures.nativeRand();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native rand exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeRand();

    static boolean hasHardwareSeed() {
        try {
            return NativeFeatures.nativeSeed();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native seed exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeSeed();

    static boolean hasHardwareSHA256() {
        try {
            return NativeFeatures.nativeSHA256();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native sha exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    static boolean hasHardwareSHA224() {
        try {
            return NativeFeatures.nativeSHA224();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native sha exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    static boolean hasHardwareSHA384() {
        try {
            return NativeFeatures.nativeSHA384();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native sha exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    static boolean hasHardwareSHA512() {
        try {
            return NativeFeatures.nativeSHA512();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native sha exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    static boolean hasMultiplyAcc() {
        try {
            return NativeFeatures.nativeMulAcc();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native multiply and accumulate exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    static boolean hasSHA3() {
        try {
            return NativeFeatures.nativeSHA3();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native sha3 exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    static boolean hasSHAKE() {
        try {
            return NativeFeatures.nativeSHAKE();
        }
        catch (UnsatisfiedLinkError ule) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "native shake exception: " + ule.getMessage(), ule);
            }
            return false;
        }
    }

    private static native boolean nativeSHAKE();

    private static native boolean nativeSHA3();

    private static native boolean nativeSHA256();

    private static native boolean nativeSHA224();

    private static native boolean nativeSHA384();

    private static native boolean nativeSHA512();

    private static native boolean nativeMulAcc();

    private static native boolean nativeRSA();
}

