/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipher;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.modes.AESCCMModePacketCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AESNativeCCMPacketCipher
implements PacketCipher,
AESCCMModePacketCipher {
    @Override
    public int getOutputSize(boolean encryption, CipherParameters params, int len) {
        int macSize = this.getMacSize(encryption, params);
        return AESNativeCCMPacketCipher.getOutputSize(encryption, len, macSize);
    }

    @Override
    public int processPacket(boolean forEncryption, CipherParameters params, byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        KeyParameter keyParam;
        byte[] initialAssociatedText;
        byte[] nonce;
        int macSize;
        block4: {
            try {
                if (params instanceof AEADParameters) {
                    AEADParameters param = (AEADParameters)params;
                    macSize = this.getCCMMacSize(forEncryption, param.getMacSize());
                    nonce = param.getNonce();
                    initialAssociatedText = param.getAssociatedText();
                    keyParam = param.getKey();
                    break block4;
                }
                if (params instanceof ParametersWithIV) {
                    ParametersWithIV param = (ParametersWithIV)params;
                    macSize = 8;
                    nonce = param.getIV();
                    initialAssociatedText = null;
                    keyParam = (KeyParameter)param.getParameters();
                    break block4;
                }
                throw new IllegalArgumentException("invalid parameters passed to CCM");
            }
            catch (Exception e) {
                throw PacketCipherException.from(e);
            }
        }
        byte[] key = keyParam.getKey();
        return AESNativeCCMPacketCipher.processAEADPacketCipher(forEncryption, input, inOff, len, output, outOff, initialAssociatedText, key, nonce, macSize);
    }

    private static int processAEADPacketCipher(boolean forEncryption, byte[] input, int inOff, int len, byte[] output, int outOff, byte[] initialAssociatedText, byte[] key, byte[] nonce, int macSize) throws PacketCipherException {
        int result;
        int outLen = output != null ? output.length - outOff : 0;
        try {
            result = AESNativeCCMPacketCipher.processPacket(forEncryption, key, nonce, initialAssociatedText, macSize, input, inOff, len, output, outOff, outLen);
        }
        catch (Exception e) {
            throw PacketCipherException.from(e);
        }
        return result;
    }

    static native int getOutputSize(boolean var0, int var1, int var2);

    static native int processPacket(boolean var0, byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10);

    public String toString() {
        return "CCM-PS[Native](AES[Native])";
    }
}

