/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.modes.AESCFBModePacketCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AESNativeCFBPacketCipher
implements AESCFBModePacketCipher {
    @Override
    public int getOutputSize(boolean encryption, CipherParameters parameters, int len) {
        this.checkCFBParameter(parameters);
        return AESNativeCFBPacketCipher.getOutputSize(len);
    }

    @Override
    public int processPacket(boolean encryption, CipherParameters parameters, byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        int result;
        byte[] key;
        ParametersWithIV ivParam;
        if (parameters instanceof ParametersWithIV) {
            ivParam = (ParametersWithIV)parameters;
            if (ivParam.getParameters() == null) {
                throw new IllegalArgumentException("CFB cipher unitialized");
            }
            key = ((KeyParameter)ivParam.getParameters()).getKey();
        } else {
            throw new IllegalArgumentException("CFB cipher unitialized");
        }
        byte[] iv = (byte[])ivParam.getIV().clone();
        try {
            result = AESNativeCFBPacketCipher.processPacket(encryption, key, iv, input, inOff, len, output, outOff, output.length - outOff);
        }
        catch (Exception e) {
            throw PacketCipherException.from(e);
        }
        return result;
    }

    static native int getOutputSize(int var0);

    static native int processPacket(boolean var0, byte[] var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8);

    public String toString() {
        return "CFB-PS[Native](AES[Native])";
    }
}

