/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public interface AESCCMModePacketCipher
extends PacketCipher {
    default public int getMacSize(boolean encryption, CipherParameters params) {
        byte[] nonce;
        KeyParameter keyParam;
        int macSize;
        CipherParameters param;
        if (params instanceof AEADParameters) {
            param = (AEADParameters)params;
            macSize = this.getCCMMacSize(encryption, ((AEADParameters)param).getMacSize());
            keyParam = ((AEADParameters)param).getKey();
            nonce = ((AEADParameters)param).getNonce();
        } else if (params instanceof ParametersWithIV) {
            param = (ParametersWithIV)params;
            macSize = 8;
            keyParam = (KeyParameter)((ParametersWithIV)param).getParameters();
            nonce = ((ParametersWithIV)param).getIV();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to CCM");
        }
        if (nonce == null || nonce.length < 7 || nonce.length > 13) {
            throw new IllegalArgumentException("nonce must have length from 7 to 13 octets");
        }
        if (keyParam != null) {
            int keyLen = keyParam.getKeyLength();
            if (keyLen < 16 || keyLen > 32 || (keyLen & 7) != 0) {
                throw new IllegalArgumentException("key must be only 16, 24 or 32 bytes long");
            }
        } else {
            throw new IllegalArgumentException("CCM cipher unitialized");
        }
        return macSize;
    }

    default public int getCCMMacSize(boolean forEncryption, int requestedMacBits) {
        if (forEncryption && (requestedMacBits < 32 || requestedMacBits > 128 || 0 != (requestedMacBits & 0xF))) {
            throw new IllegalArgumentException("tag length in octets must be one of {4,6,8,10,12,14,16}");
        }
        return requestedMacBits >>> 3;
    }
}

