/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CCMModeCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

class AESNativeCCM
implements CCMModeCipher {
    private CCMRefWrapper refWrapper;
    private byte[] lastKey;
    private boolean forEncryption = false;
    private boolean initialised = false;
    private final ExposedByteArrayOutputStream associatedText = new ExposedByteArrayOutputStream();
    private final ExposedByteArrayOutputStream data = new ExposedByteArrayOutputStream();

    AESNativeCCM() {
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        MultiBlockCipher multiBlockCipher = AESEngine.newInstance();
        if (this.lastKey != null) {
            multiBlockCipher.init(true, new KeyParameter(this.lastKey));
        }
        return multiBlockCipher;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        CipherParameters cipherParameters2;
        int n;
        byte[] byArray;
        byte[] byArray2;
        CipherParameters cipherParameters3;
        this.forEncryption = bl;
        CipherParameters cipherParameters4 = null;
        if (cipherParameters instanceof AEADParameters) {
            cipherParameters3 = (AEADParameters)cipherParameters;
            byArray2 = ((AEADParameters)cipherParameters3).getNonce();
            byArray = ((AEADParameters)cipherParameters3).getAssociatedText();
            n = this.getMacSize(bl, ((AEADParameters)cipherParameters3).getMacSize());
            cipherParameters2 = ((AEADParameters)cipherParameters3).getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters3 = (ParametersWithIV)cipherParameters;
            byArray2 = ((ParametersWithIV)cipherParameters3).getIV();
            byArray = null;
            n = this.getMacSize(bl, 64);
            cipherParameters2 = ((ParametersWithIV)cipherParameters3).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to CCM");
        }
        if (cipherParameters2 != null) {
            cipherParameters4 = cipherParameters2;
        }
        if (cipherParameters4 != null) {
            this.lastKey = ((KeyParameter)cipherParameters4).getKey();
            if (this.lastKey == null) {
                throw new IllegalArgumentException("key was null");
            }
            this.initRef(this.lastKey.length);
        }
        int n2 = byArray != null ? byArray.length : 0;
        AESNativeCCM.initNative(this.refWrapper.getReference(), bl, this.lastKey, byArray2, byArray, n2, n * 8);
        this.reset();
        this.initialised = true;
    }

    private void initRef(int n) {
        this.refWrapper = new CCMRefWrapper(AESNativeCCM.makeInstance());
    }

    @Override
    public String getAlgorithmName() {
        return "AES/CCM";
    }

    @Override
    public void processAADByte(byte by) {
        this.associatedText.write(by);
    }

    @Override
    public void processAADBytes(byte[] byArray, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("offset is negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len is negative");
        }
        if (byArray.length < n + n2) {
            throw new IllegalArgumentException("array too short for offset + len");
        }
        this.associatedText.write(byArray, n, n2);
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
        if (n < 0) {
            throw new IllegalArgumentException("offset is negative");
        }
        if (byArray != null && byArray.length < n) {
            throw new DataLengthException("offset past end");
        }
        this.data.write(by);
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        if (n < 0 || n3 < 0) {
            throw new IllegalArgumentException("offset is negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len is negative");
        }
        if (byArray == null) {
            throw new NullPointerException("input was null");
        }
        if (byArray.length < n + n2) {
            throw new DataLengthException("array too short for offset + len");
        }
        this.data.write(byArray, n, n2);
        return 0;
    }

    @Override
    public int doFinal(byte[] byArray, int n) throws IllegalStateException, InvalidCipherTextException {
        int n2;
        try {
            this.checkStatus();
            if (byArray == null) {
                throw new NullPointerException("output was null");
            }
            if (n < 0) {
                throw new IllegalArgumentException("offset is negative");
            }
            byte[] byArray2 = this.data.toByteArray();
            byte[] byArray3 = this.associatedText.toByteArray();
            if (this.getOutputSize(0) > byArray.length - n) {
                throw new OutputLengthException("output buffer too short");
            }
            n2 = AESNativeCCM.processPacket(this.refWrapper.getReference(), byArray2, 0, byArray2.length, byArray3, 0, byArray3.length, byArray, n);
            this.resetKeepMac();
        }
        catch (IllegalStateException illegalStateException) {
            this.reset();
            throw illegalStateException;
        }
        return n2;
    }

    @Override
    public byte[] getMac() {
        return AESNativeCCM.getMac(this.refWrapper.getReference());
    }

    @Override
    public int getUpdateOutputSize(int n) {
        return 0;
    }

    @Override
    public int getOutputSize(int n) {
        return AESNativeCCM.getOutputSize(this.refWrapper.getReference(), n + this.data.size());
    }

    @Override
    public void reset() {
        if (this.refWrapper == null) {
            return;
        }
        this.associatedText.reset();
        this.data.reset();
        this.reset(this.refWrapper.getReference(), false);
    }

    private void resetKeepMac() {
        if (this.refWrapper == null) {
            return;
        }
        this.associatedText.reset();
        this.data.reset();
        this.reset(this.refWrapper.getReference(), true);
    }

    private void checkStatus() {
        if (!this.initialised) {
            if (this.forEncryption) {
                throw new IllegalStateException("CCM cipher cannot be reused for encryption");
            }
            throw new IllegalStateException("CCM cipher needs to be initialised");
        }
    }

    private native void reset(long var1, boolean var3);

    static native void initNative(long var0, boolean var2, byte[] var3, byte[] var4, byte[] var5, int var6, int var7);

    static native long makeInstance();

    static native void dispose(long var0);

    static native int getOutputSize(long var0, int var2);

    static native byte[] getMac(long var0);

    static native int processPacket(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7, byte[] var8, int var9);

    @Override
    public int processPacket(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws InvalidCipherTextException {
        byte[] byArray3 = this.associatedText.toByteArray();
        int n4 = AESNativeCCM.processPacket(this.refWrapper.getReference(), byArray, n, n2, byArray3, 0, byArray3.length, byArray2, n3);
        this.reset();
        return n4;
    }

    @Override
    public byte[] processPacket(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        byte[] byArray2 = new byte[this.getOutputSize(n2)];
        this.processPacket(byArray, n, n2, byArray2, 0);
        this.reset();
        return byArray2;
    }

    public String toString() {
        if (this.lastKey != null) {
            return "CCM[Native](AES[Native](" + this.lastKey.length * 8 + "))";
        }
        return "CCM[Native](AES[Native](not initialized))";
    }

    private int getMacSize(boolean bl, int n) {
        if (bl && (n < 32 || n > 128 || 0 != (n & 0xF))) {
            throw new IllegalArgumentException("invalid value for MAC size");
        }
        return n >>> 3;
    }

    private class CCMRefWrapper
    extends NativeReference {
        public CCMRefWrapper(long l) {
            super(l, "CCM");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    private class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            AESNativeCCM.this.data.reset();
            AESNativeCCM.this.associatedText.reset();
            AESNativeCCM.dispose(l);
        }
    }

    private static class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

