/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public interface AESGCMModePacketCipher
extends PacketCipher,
Destroyable {
    default public int checkParameters(CipherParameters cipherParameters) {
        int n;
        KeyParameter keyParameter;
        byte[] byArray;
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof AEADParameters) {
            cipherParameters2 = (AEADParameters)cipherParameters;
            byArray = ((AEADParameters)cipherParameters2).getNonce();
            int n2 = ((AEADParameters)cipherParameters2).getMacSize();
            if (n2 < 32 || n2 > 128 || (n2 & 7) != 0) {
                throw new IllegalArgumentException("invalid mac size: " + n2);
            }
            keyParameter = ((AEADParameters)cipherParameters2).getKey();
            n = n2 >> 3;
        } else if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters2 = (ParametersWithIV)cipherParameters;
            byArray = ((ParametersWithIV)cipherParameters2).getIV();
            keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters2).getParameters();
            n = 16;
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        if (byArray == null || byArray.length < 12) {
            throw new IllegalArgumentException("nonce must be at least 12 byte");
        }
        if (keyParameter != null) {
            int n3 = keyParameter.getKeyLength();
            if (n3 < 16 || n3 > 32 || (n3 & 7) != 0) {
                throw new IllegalArgumentException("key must be only 16, 24 or 32 bytes long");
            }
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        return n;
    }
}

