/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.slhdsa;

import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.pqc.crypto.slhdsa.ADRS;
import org.bouncycastle.pqc.crypto.slhdsa.IndexedDigest;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

class SLHDSASha2NativeEngine
extends SLHDSAEngine {
    private SLHDSARefWrapper ref;
    private final HMac treeHMac;
    private final byte[] hmacBuf;
    private final byte[] msgDigestBuf;
    private final int bl;
    private final byte[] sha256Buf = new byte[32];

    protected SLHDSASha2NativeEngine(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.ref = new SLHDSARefWrapper(SLHDSASha2NativeEngine.makeInstance());
        assert (n == 16);
        this.treeHMac = new HMac(SHA256Digest.newInstance());
        this.bl = 64;
        this.hmacBuf = new byte[this.treeHMac.getMacSize()];
        this.msgDigestBuf = new byte[32];
    }

    @Override
    void init(byte[] byArray) {
        byte[] byArray2 = new byte[this.bl];
        SLHDSASha2NativeEngine.initMemoStates(this.ref.getReference(), byArray, byArray2, this.bl - this.N, 64 - byArray.length);
    }

    static native void initMemoStates(long var0, byte[] var2, byte[] var3, int var4, int var5);

    @Override
    public byte[] F(byte[] byArray, ADRS aDRS, byte[] byArray2) {
        byte[] byArray3 = this.compressedADRS(aDRS);
        return SLHDSASha2NativeEngine.sha256DigestAndReturnRange(this.ref.getReference(), true, this.sha256Buf, new byte[this.N], byArray3, byArray2, null, null);
    }

    @Override
    public byte[] H(byte[] byArray, ADRS aDRS, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = this.compressedADRS(aDRS);
        return SLHDSASha2NativeEngine.msgDigestAndReturnRange(this.ref.getReference(), true, this.msgDigestBuf, new byte[this.N], byArray4, byArray2, byArray3, null, null);
    }

    @Override
    IndexedDigest H_msg(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        int n = (this.A * this.K + 7) / 8;
        int n2 = this.H / this.D;
        int n3 = this.H - n2;
        int n4 = (n2 + 7) / 8;
        int n5 = (n3 + 7) / 8;
        int n6 = n + n4 + n5;
        byte[] byArray6 = new byte[n6];
        byte[] byArray7 = new byte[32];
        SLHDSASha2NativeEngine.msgDigestAndReturnRange(this.ref.getReference(), false, byArray7, null, byArray, byArray2, byArray3, byArray4, byArray5);
        byArray6 = this.bitmask(Arrays.concatenate(byArray, byArray2, byArray7), byArray6);
        byte[] byArray8 = new byte[8];
        System.arraycopy(byArray6, n, byArray8, 8 - n5, n5);
        long l = Pack.bigEndianToLong(byArray8, 0);
        byte[] byArray9 = new byte[4];
        System.arraycopy(byArray6, n + n5, byArray9, 4 - n4, n4);
        int n7 = Pack.bigEndianToInt(byArray9, 0);
        return new IndexedDigest(l &= -1L >>> 64 - n3, n7 &= -1 >>> 32 - n2, Arrays.copyOfRange(byArray6, 0, n));
    }

    @Override
    public byte[] T_l(byte[] byArray, ADRS aDRS, byte[] byArray2) {
        byte[] byArray3 = this.compressedADRS(aDRS);
        SLHDSASha2NativeEngine.msgDigestAndReturnRange(this.ref.getReference(), true, this.msgDigestBuf, new byte[this.N], byArray3, byArray2, null, null, null);
        return Arrays.copyOfRange(this.msgDigestBuf, 0, this.N);
    }

    @Override
    byte[] PRF(byte[] byArray, byte[] byArray2, ADRS aDRS) {
        int n = byArray2.length;
        byte[] byArray3 = this.compressedADRS(aDRS);
        return SLHDSASha2NativeEngine.sha256DigestAndReturnRange(this.ref.getReference(), true, this.sha256Buf, new byte[n], byArray3, byArray2, null, null);
    }

    @Override
    public byte[] PRF_msg(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.treeHMac.init(new KeyParameter(byArray));
        this.treeHMac.update(byArray2, 0, byArray2.length);
        if (byArray3 != null) {
            this.treeHMac.update(byArray3, 0, byArray3.length);
        }
        this.treeHMac.update(byArray4, 0, byArray4.length);
        this.treeHMac.doFinal(this.hmacBuf, 0);
        return Arrays.copyOfRange(this.hmacBuf, 0, this.N);
    }

    private byte[] compressedADRS(ADRS aDRS) {
        byte[] byArray = new byte[22];
        System.arraycopy(aDRS.value, 3, byArray, 0, 1);
        System.arraycopy(aDRS.value, 8, byArray, 1, 8);
        System.arraycopy(aDRS.value, 19, byArray, 9, 1);
        System.arraycopy(aDRS.value, 20, byArray, 10, 12);
        return byArray;
    }

    protected byte[] bitmask(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray2.length];
        SLHDSASha2NativeEngine.bitmask(this.ref.getReference(), byArray, byArray3, byArray2, null, null, null);
        return byArray3;
    }

    public String toString() {
        return "SLHDSA[Native](SHA252[Native]())";
    }

    static native long makeInstance();

    static native void dispose(long var0);

    static native byte[] sha256DigestAndReturnRange(long var0, boolean var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8);

    static native byte[] msgDigestAndReturnRange(long var0, boolean var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9);

    static native void bitmask(long var0, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7);

    private class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            SLHDSASha2NativeEngine.dispose(l);
        }
    }

    private class SLHDSARefWrapper
    extends NativeReference {
        public SLHDSARefWrapper(long l) {
            super(l, "SLHDSA_SHA256_NATIVE");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }
}

