/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import java.lang.ref.Reference;
import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.SavableDigest;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SHA384NativeDigest
implements SavableDigest {
    private final CryptoServicePurpose purpose;
    protected DigestRefWrapper nativeRef = null;

    SHA384NativeDigest(CryptoServicePurpose cryptoServicePurpose) {
        this.purpose = cryptoServicePurpose;
        this.nativeRef = new DigestRefWrapper(SHA384NativeDigest.makeNative());
        this.reset();
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
    }

    SHA384NativeDigest() {
        this(CryptoServicePurpose.ANY);
    }

    SHA384NativeDigest(SHA384NativeDigest sHA384NativeDigest) {
        this(CryptoServicePurpose.ANY);
        byte[] byArray = sHA384NativeDigest.getEncodedState();
        SHA384NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, 0);
    }

    SHA384NativeDigest restoreState(byte[] byArray, int n) {
        SHA384NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
        return this;
    }

    @Override
    public String getAlgorithmName() {
        try {
            String string = "SHA-384";
            return string;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public int getDigestSize() {
        try {
            int n = SHA384NativeDigest.getDigestSize(this.nativeRef.getReference());
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public void update(byte by) {
        try {
            SHA384NativeDigest.update(this.nativeRef.getReference(), by);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(byte[] byArray, int n, int n2) {
        try {
            SHA384NativeDigest.update(this.nativeRef.getReference(), byArray, n, n2);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] byArray, int n) {
        try {
            int n2 = SHA384NativeDigest.doFinal(this.nativeRef.getReference(), byArray, n);
            return n2;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public void reset() {
        try {
            SHA384NativeDigest.reset(this.nativeRef.getReference());
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public int getByteLength() {
        try {
            int n = SHA384NativeDigest.getByteLength(this.nativeRef.getReference());
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public Memoable copy() {
        return new SHA384NativeDigest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        try {
            SHA384NativeDigest sHA384NativeDigest = (SHA384NativeDigest)memoable;
            SHA384NativeDigest.restoreFullState(this.nativeRef.getReference(), sHA384NativeDigest.getEncodedState(), 0);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEncodedState() {
        try {
            int n = SHA384NativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
            byte[] byArray = new byte[n];
            SHA384NativeDigest.encodeFullState(this.nativeRef.getReference(), byArray, 0);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    void restoreFullState(byte[] byArray, int n) {
        try {
            SHA384NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public String toString() {
        return "SHA384[Native]()";
    }

    static native long makeNative();

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, 384, this.purpose);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long l) {
            super(l, "SHA384");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            SHA384NativeDigest.destroy(l);
        }
    }
}

