/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.modes.AESCTRModePacketCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

public class AESNativeCTRPacketCipher
implements AESCTRModePacketCipher {
    @Override
    public int getOutputSize(boolean bl, CipherParameters cipherParameters, int n) {
        this.checkParameters(cipherParameters);
        return AESNativeCTRPacketCipher.getOutputSize(n);
    }

    @Override
    public int processPacket(boolean bl, CipherParameters cipherParameters, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        int n4;
        KeyParameter keyParameter;
        byte[] byArray3;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byArray3 = Arrays.clone(parametersWithIV.getIV());
            keyParameter = (KeyParameter)parametersWithIV.getParameters();
            if (keyParameter == null) {
                throw PacketCipherException.from(new IllegalStateException("CTR/SIC cipher unitialized."));
            }
        } else {
            throw new IllegalArgumentException("CTR/SIC mode requires ParametersWithIV");
        }
        byte[] byArray4 = keyParameter.getKey();
        try {
            n4 = AESNativeCTRPacketCipher.processPacket(bl, byArray4, byArray3, byArray, n, n2, byArray2, n3, byArray2.length - n3);
        }
        catch (Exception exception) {
            throw PacketCipherException.from(exception);
        }
        return n4;
    }

    static native int getOutputSize(int var0);

    static native int processPacket(boolean var0, byte[] var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8);

    public String toString() {
        return "CTR-PS[Native](AES[Native])";
    }
}

