/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.GCMModeCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class AESNativeGCM
implements GCMModeCipher {
    private GCMRefWrapper refWrapper;
    private byte[] oldNonce;
    private boolean forEncryption = false;
    private boolean initialised = false;
    private byte[] keptMac = null;

    AESNativeGCM() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockCipher getUnderlyingCipher() {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            MultiBlockCipher multiBlockCipher = AESEngine.newInstance();
            if (this.refWrapper != null && this.refWrapper.key != null) {
                multiBlockCipher.init(true, new KeyParameter(this.refWrapper.key));
            }
            return multiBlockCipher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            KeyParameter keyParameter;
            int n;
            byte[] byArray;
            Object object;
            this.forEncryption = bl;
            byte[] byArray2 = null;
            this.keptMac = null;
            if (cipherParameters instanceof AEADParameters) {
                object = (AEADParameters)cipherParameters;
                byArray2 = ((AEADParameters)object).getNonce();
                byArray = ((AEADParameters)object).getAssociatedText();
                int n2 = ((AEADParameters)object).getMacSize();
                if (n2 < 32 || n2 > 128 || n2 % 8 != 0) {
                    throw new IllegalArgumentException("invalid value for MAC size: " + n2);
                }
                n = n2;
                keyParameter = ((AEADParameters)object).getKey();
            } else if (cipherParameters instanceof ParametersWithIV) {
                object = (ParametersWithIV)cipherParameters;
                byArray2 = ((ParametersWithIV)object).getIV();
                byArray = null;
                n = 128;
                keyParameter = (KeyParameter)((ParametersWithIV)object).getParameters();
            } else {
                throw new IllegalArgumentException("invalid parameters passed to GCM");
            }
            if (byArray2 == null || byArray2.length < 12) {
                throw new IllegalArgumentException("IV must be at least 12 bytes");
            }
            object = null;
            if (bl && this.oldNonce != null && Arrays.areEqual(this.oldNonce, byArray2)) {
                if (keyParameter == null) {
                    throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
                }
                if (this.refWrapper != null && this.refWrapper.key != null && Arrays.areEqual(this.refWrapper.key, keyParameter.getKey())) {
                    throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
                }
                if (this.refWrapper != null && this.refWrapper.key != null) {
                    object = Arrays.clone(this.refWrapper.key);
                }
            }
            this.oldNonce = byArray2;
            if (keyParameter != null) {
                object = keyParameter.getKey();
                switch (((Object)object).length) {
                    case 16: 
                    case 24: 
                    case 32: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("key must be only 16,24,or 32 bytes long.");
                    }
                }
            }
            this.initRef((byte[])object);
            AESNativeGCM.initNative(this.refWrapper.getReference(), bl, (byte[])object, this.oldNonce, byArray, n);
            this.initialised = true;
        }
    }

    private void initRef(byte[] byArray) {
        this.refWrapper = new GCMRefWrapper(AESNativeGCM.makeInstance(byArray.length, this.forEncryption), byArray);
    }

    @Override
    public String getAlgorithmName() {
        return "AES/GCM";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAADByte(byte by) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            AESNativeGCM.processAADByte(this.refWrapper.getReference(), by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAADBytes(byte[] byArray, int n, int n2) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM is uninitialized");
            }
            AESNativeGCM.processAADBytes(this.refWrapper.getReference(), byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM is uninitialized");
            }
            return AESNativeGCM.processByte(this.refWrapper.getReference(), by, byArray, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM is uninitialized");
            }
            return AESNativeGCM.processBytes(this.refWrapper.getReference(), byArray, n, n2, byArray2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] byArray, int n) throws IllegalStateException, InvalidCipherTextException {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            this.checkStatus();
            int n2 = AESNativeGCM.doFinal(this.refWrapper.getReference(), byArray, n);
            this.resetKeepMac();
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getMac() {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.keptMac != null) {
                return Arrays.clone(this.keptMac);
            }
            return AESNativeGCM.getMac(this.refWrapper.getReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateOutputSize(int n) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            return AESNativeGCM.getUpdateOutputSize(this.refWrapper.getReference(), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOutputSize(int n) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            return AESNativeGCM.getOutputSize(this.refWrapper.getReference(), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                return;
            }
            this.reset(this.refWrapper.getReference());
            this.initialised = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetKeepMac() {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                return;
            }
            this.keptMac = this.getMac();
            this.reset(this.refWrapper.getReference());
            this.initialised = false;
        }
    }

    private void checkStatus() {
        if (!this.initialised) {
            if (this.forEncryption) {
                throw new IllegalStateException("GCM cipher cannot be reused for encryption");
            }
            throw new IllegalStateException("GCM cipher needs to be initialised");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper.key != null) {
                return "GCM[Native](AES[Native](" + this.refWrapper.key.length * 8 + "))";
            }
            return "GCM[Native](AES[Native](not initialized))";
        }
    }

    private native void reset(long var1);

    static native void initNative(long var0, boolean var2, byte[] var3, byte[] var4, byte[] var5, int var6);

    static native long makeInstance(int var0, boolean var1);

    static native void dispose(long var0);

    private static native void processAADByte(long var0, byte var2);

    private static native void processAADBytes(long var0, byte[] var2, int var3, int var4);

    private static native int processByte(long var0, byte var2, byte[] var3, int var4);

    private static native int processBytes(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native int doFinal(long var0, byte[] var2, int var3);

    private static native int getUpdateOutputSize(long var0, int var2);

    private static native int getOutputSize(long var0, int var2);

    public static native byte[] getMac(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBlocksRemainingDown(long l) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            this.setBlocksRemainingDown(this.refWrapper.getReference(), l);
        }
    }

    private native void setBlocksRemainingDown(long var1, long var3);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        private final byte[] key;

        Disposer(long l, byte[] byArray) {
            super(l);
            this.key = byArray;
        }

        @Override
        protected void dispose(long l) {
            Arrays.clear(this.key);
            AESNativeGCM.dispose(l);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class GCMRefWrapper
    extends NativeReference {
        private final byte[] key;

        public GCMRefWrapper(long l, byte[] byArray) {
            super(l, "GCM");
            this.key = byArray;
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference, this.key);
        }
    }
}

