/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import java.lang.ref.Reference;
import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.SavableDigest;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SHA3NativeDigest
implements SavableDigest {
    private final CryptoServicePurpose purpose;
    protected DigestRefWrapper nativeRef = null;
    private int bitLen;

    public SHA3NativeDigest(CryptoServicePurpose cryptoServicePurpose) {
        this(256, cryptoServicePurpose);
    }

    public SHA3NativeDigest(int n, CryptoServicePurpose cryptoServicePurpose) {
        if (!CryptoServicesRegistrar.hasEnabledService("SHA3")) {
            throw new IllegalStateException("no native SHA3 support");
        }
        this.purpose = cryptoServicePurpose;
        this.bitLen = n;
        this.nativeRef = new DigestRefWrapper(SHA3NativeDigest.makeNative(n));
        this.reset();
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
    }

    public SHA3NativeDigest(int n) {
        this(n, CryptoServicePurpose.ANY);
    }

    public SHA3NativeDigest() {
        this(CryptoServicePurpose.ANY);
    }

    public SHA3NativeDigest(SHA3NativeDigest sHA3NativeDigest) {
        this(CryptoServicePurpose.ANY);
        byte[] byArray = sHA3NativeDigest.getEncodedState();
        SHA3NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, 0);
    }

    public SHA3NativeDigest(byte[] byArray, CryptoServicePurpose cryptoServicePurpose) {
        this(cryptoServicePurpose);
        SHA3NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, 0);
    }

    public SHA3NativeDigest(byte[] byArray) {
        this();
        SHA3NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SHA3NativeDigest restoreState(byte[] byArray, int n) {
        try {
            SHA3NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
            SHA3NativeDigest sHA3NativeDigest = this;
            return sHA3NativeDigest;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public String getAlgorithmName() {
        try {
            String string = "SHA3-" + this.bitLen;
            return string;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public int getDigestSize() {
        try {
            int n = SHA3NativeDigest.getDigestSize(this.nativeRef.getReference());
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public void update(byte by) {
        try {
            SHA3NativeDigest.update(this.nativeRef.getReference(), by);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(byte[] byArray, int n, int n2) {
        try {
            SHA3NativeDigest.update(this.nativeRef.getReference(), byArray, n, n2);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] byArray, int n) {
        try {
            int n2 = SHA3NativeDigest.doFinal(this.nativeRef.getReference(), byArray, n);
            this.reset();
            int n3 = n2;
            return n3;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public void reset() {
        try {
            SHA3NativeDigest.reset(this.nativeRef.getReference());
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public int getByteLength() {
        try {
            int n = SHA3NativeDigest.getByteLength(this.nativeRef.getReference());
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public Memoable copy() {
        try {
            SHA3NativeDigest sHA3NativeDigest = new SHA3NativeDigest(this);
            return sHA3NativeDigest;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public void reset(Memoable memoable) {
        try {
            SHA3NativeDigest sHA3NativeDigest = (SHA3NativeDigest)memoable;
            SHA3NativeDigest.restoreFullState(this.nativeRef.getReference(), sHA3NativeDigest.getEncodedState(), 0);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEncodedState() {
        try {
            int n = SHA3NativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
            byte[] byArray = new byte[n];
            SHA3NativeDigest.encodeFullState(this.nativeRef.getReference(), byArray, 0);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    void restoreFullState(byte[] byArray, int n) {
        try {
            SHA3NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public String toString() {
        return "SHA3[Native]()";
    }

    static native long makeNative(int var0);

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, this.bitLen, this.purpose);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long l) {
            super(l, "SHA3");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            SHA3NativeDigest.destroy(l);
        }
    }
}

