/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCApplicationProtocolSelector;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ProvAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.tls.TlsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ProvSSLParameters {
    private final ProvSSLContextSpi context;
    private String[] cipherSuites;
    private String[] protocols;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    private BCAlgorithmConstraints algorithmConstraints = ProvAlgorithmConstraints.DEFAULT;
    private String endpointIdentificationAlgorithm;
    private boolean useCipherSuitesOrder = true;
    private List<BCSNIMatcher> sniMatchers;
    private List<BCSNIServerName> sniServerNames;
    private String[] applicationProtocols = TlsUtils.EMPTY_STRINGS;
    private BCApplicationProtocolSelector<SSLEngine> engineAPSelector;
    private BCApplicationProtocolSelector<SSLSocket> socketAPSelector;
    private ProvSSLSession sessionToResume;

    private static <T> List<T> copyList(Collection<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    ProvSSLParameters(ProvSSLContextSpi context, String[] cipherSuites, String[] protocols) {
        this.context = context;
        this.cipherSuites = cipherSuites;
        this.protocols = protocols;
    }

    ProvSSLParameters copy() {
        ProvSSLParameters p = new ProvSSLParameters(this.context, this.cipherSuites, this.protocols);
        p.needClientAuth = this.needClientAuth;
        p.wantClientAuth = this.wantClientAuth;
        p.algorithmConstraints = this.algorithmConstraints;
        p.endpointIdentificationAlgorithm = this.endpointIdentificationAlgorithm;
        p.useCipherSuitesOrder = this.useCipherSuitesOrder;
        p.sniMatchers = this.sniMatchers;
        p.sniServerNames = this.sniServerNames;
        p.applicationProtocols = this.applicationProtocols;
        p.engineAPSelector = this.engineAPSelector;
        p.socketAPSelector = this.socketAPSelector;
        p.sessionToResume = this.sessionToResume;
        return p;
    }

    ProvSSLParameters copyForConnection() {
        ProvSSLParameters p = this.copy();
        if (ProvAlgorithmConstraints.DEFAULT != p.algorithmConstraints) {
            p.algorithmConstraints = new ProvAlgorithmConstraints(p.algorithmConstraints, true);
        }
        return p;
    }

    public String[] getCipherSuites() {
        return (String[])this.cipherSuites.clone();
    }

    String[] getCipherSuitesArray() {
        return this.cipherSuites;
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = this.context.getSupportedCipherSuites(cipherSuites);
    }

    void setCipherSuitesArray(String[] cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public String[] getProtocols() {
        return (String[])this.protocols.clone();
    }

    String[] getProtocolsArray() {
        return this.protocols;
    }

    public void setProtocols(String[] protocols) {
        if (!this.context.isSupportedProtocols(protocols)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.protocols = (String[])protocols.clone();
    }

    void setProtocolsArray(String[] protocols) {
        this.protocols = protocols;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        this.wantClientAuth = false;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.needClientAuth = false;
        this.wantClientAuth = wantClientAuth;
    }

    public BCAlgorithmConstraints getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(BCAlgorithmConstraints algorithmConstraints) {
        this.algorithmConstraints = algorithmConstraints;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String endpointIdentificationAlgorithm) {
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
    }

    public boolean getUseCipherSuitesOrder() {
        return this.useCipherSuitesOrder;
    }

    public void setUseCipherSuitesOrder(boolean useCipherSuitesOrder) {
        this.useCipherSuitesOrder = useCipherSuitesOrder;
    }

    public List<BCSNIServerName> getServerNames() {
        return ProvSSLParameters.copyList(this.sniServerNames);
    }

    public void setServerNames(List<BCSNIServerName> serverNames) {
        this.sniServerNames = ProvSSLParameters.copyList(serverNames);
    }

    public Collection<BCSNIMatcher> getSNIMatchers() {
        return ProvSSLParameters.copyList(this.sniMatchers);
    }

    public void setSNIMatchers(Collection<BCSNIMatcher> matchers) {
        this.sniMatchers = ProvSSLParameters.copyList(matchers);
    }

    public String[] getApplicationProtocols() {
        return (String[])this.applicationProtocols.clone();
    }

    public void setApplicationProtocols(String[] applicationProtocols) {
        this.applicationProtocols = (String[])applicationProtocols.clone();
    }

    public BCApplicationProtocolSelector<SSLEngine> getEngineAPSelector() {
        return this.engineAPSelector;
    }

    public void setEngineAPSelector(BCApplicationProtocolSelector<SSLEngine> engineAPSelector) {
        this.engineAPSelector = engineAPSelector;
    }

    public BCApplicationProtocolSelector<SSLSocket> getSocketAPSelector() {
        return this.socketAPSelector;
    }

    public void setSocketAPSelector(BCApplicationProtocolSelector<SSLSocket> socketAPSelector) {
        this.socketAPSelector = socketAPSelector;
    }

    public ProvSSLSession getSessionToResume() {
        return this.sessionToResume;
    }

    public void setSessionToResume(ProvSSLSession sessionToResume) {
        this.sessionToResume = sessionToResume;
    }
}

