/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsPeer;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.MaxFragmentLength;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPSKIdentityManager;
import org.bouncycastle.tls.TlsSRPLoginParameters;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContext;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsECConfig;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractTlsServer
extends AbstractTlsPeer
implements TlsServer {
    protected TlsServerContext context;
    protected ProtocolVersion[] protocolVersions;
    protected int[] cipherSuites;
    protected int[] offeredCipherSuites;
    protected Hashtable clientExtensions;
    protected boolean encryptThenMACOffered;
    protected short maxFragmentLengthOffered;
    protected boolean truncatedHMacOffered;
    protected boolean clientSentECPointFormats;
    protected CertificateStatusRequest certificateStatusRequest;
    protected Vector statusRequestV2;
    protected Vector trustedCAKeys;
    protected int selectedCipherSuite;
    protected Vector clientProtocolNames;
    protected ProtocolName selectedProtocolName;
    protected final Hashtable serverExtensions = new Hashtable();

    public AbstractTlsServer(TlsCrypto crypto) {
        super(crypto);
    }

    protected boolean allowCertificateStatus() {
        return true;
    }

    protected boolean allowEncryptThenMAC() {
        return true;
    }

    protected boolean allowMultiCertStatus() {
        return false;
    }

    protected boolean allowTruncatedHMac() {
        return false;
    }

    protected boolean allowTrustedCAIndication() {
        return false;
    }

    protected Hashtable checkServerExtensions() {
        return this.serverExtensions;
    }

    protected int getMaximumNegotiableCurveBits() {
        int[] clientSupportedGroups = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (clientSupportedGroups == null) {
            return NamedGroup.getMaximumCurveBits();
        }
        int maxBits = 0;
        for (int i = 0; i < clientSupportedGroups.length; ++i) {
            maxBits = Math.max(maxBits, NamedGroup.getCurveBits(clientSupportedGroups[i]));
        }
        return maxBits;
    }

    protected int getMaximumNegotiableFiniteFieldBits() {
        int[] clientSupportedGroups = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (clientSupportedGroups == null) {
            return NamedGroup.getMaximumFiniteFieldBits();
        }
        int maxBits = 0;
        for (int i = 0; i < clientSupportedGroups.length; ++i) {
            maxBits = Math.max(maxBits, NamedGroup.getFiniteFieldBits(clientSupportedGroups[i]));
        }
        return maxBits;
    }

    protected Vector getProtocolNames() {
        return null;
    }

    protected boolean isSelectableCipherSuite(int cipherSuite, int availCurveBits, int availFiniteFieldBits, Vector sigAlgs) {
        return TlsUtils.isValidVersionForCipherSuite(cipherSuite, this.context.getServerVersion()) && availCurveBits >= TlsECCUtils.getMinimumCurveBits(cipherSuite) && availFiniteFieldBits >= TlsDHUtils.getMinimumFiniteFieldBits(cipherSuite) && TlsUtils.isValidCipherSuiteForSignatureAlgorithms(cipherSuite, sigAlgs);
    }

    protected boolean preferLocalCipherSuites() {
        return false;
    }

    protected boolean selectCipherSuite(int cipherSuite) throws IOException {
        this.selectedCipherSuite = cipherSuite;
        return true;
    }

    protected int selectDH(int minimumFiniteFieldBits) {
        int[] clientSupportedGroups = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (clientSupportedGroups == null) {
            return this.selectDHDefault(minimumFiniteFieldBits);
        }
        for (int i = 0; i < clientSupportedGroups.length; ++i) {
            int namedGroup = clientSupportedGroups[i];
            if (NamedGroup.getFiniteFieldBits(namedGroup) < minimumFiniteFieldBits) continue;
            return namedGroup;
        }
        return -1;
    }

    protected int selectDHDefault(int minimumFiniteFieldBits) {
        return minimumFiniteFieldBits <= 2048 ? 256 : (minimumFiniteFieldBits <= 3072 ? 257 : (minimumFiniteFieldBits <= 4096 ? 258 : (minimumFiniteFieldBits <= 6144 ? 259 : (minimumFiniteFieldBits <= 8192 ? 260 : -1))));
    }

    protected int selectECDH(int minimumCurveBits) {
        int[] clientSupportedGroups = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (clientSupportedGroups == null) {
            return this.selectECDHDefault(minimumCurveBits);
        }
        for (int i = 0; i < clientSupportedGroups.length; ++i) {
            int namedGroup = clientSupportedGroups[i];
            if (NamedGroup.getCurveBits(namedGroup) < minimumCurveBits) continue;
            return namedGroup;
        }
        return -1;
    }

    protected int selectECDHDefault(int minimumCurveBits) {
        return minimumCurveBits <= 256 ? 23 : (minimumCurveBits <= 384 ? 24 : (minimumCurveBits <= 521 ? 25 : -1));
    }

    protected ProtocolName selectProtocolName() throws IOException {
        Vector serverProtocolNames = this.getProtocolNames();
        if (null == serverProtocolNames || serverProtocolNames.isEmpty()) {
            return null;
        }
        ProtocolName result = this.selectProtocolName(this.clientProtocolNames, serverProtocolNames);
        if (null == result) {
            throw new TlsFatalAlert(120);
        }
        return result;
    }

    protected ProtocolName selectProtocolName(Vector clientProtocolNames, Vector serverProtocolNames) {
        for (int i = 0; i < serverProtocolNames.size(); ++i) {
            ProtocolName serverProtocolName = (ProtocolName)serverProtocolNames.elementAt(i);
            if (!clientProtocolNames.contains(serverProtocolName)) continue;
            return serverProtocolName;
        }
        return null;
    }

    protected boolean shouldSelectProtocolNameEarly() {
        return true;
    }

    public void init(TlsServerContext context) {
        this.context = context;
        this.protocolVersions = this.getSupportedVersions();
        this.cipherSuites = this.getSupportedCipherSuites();
    }

    public ProtocolVersion[] getProtocolVersions() {
        return this.protocolVersions;
    }

    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        this.offeredCipherSuites = null;
        this.clientExtensions = null;
        this.encryptThenMACOffered = false;
        this.maxFragmentLengthOffered = 0;
        this.truncatedHMacOffered = false;
        this.clientSentECPointFormats = false;
        this.certificateStatusRequest = null;
        this.selectedCipherSuite = -1;
        this.selectedProtocolName = null;
        this.serverExtensions.clear();
    }

    public TlsSession getSessionToResume(byte[] sessionID) {
        return null;
    }

    public byte[] getNewSessionID() {
        return null;
    }

    public void notifySession(TlsSession session) {
    }

    public void notifyClientVersion(ProtocolVersion clientVersion) throws IOException {
    }

    public void notifyFallback(boolean isFallback) throws IOException {
        if (isFallback) {
            ProtocolVersion latestServerVersion;
            ProtocolVersion[] serverVersions = this.getProtocolVersions();
            ProtocolVersion clientVersion = this.context.getClientVersion();
            if (clientVersion.isTLS()) {
                latestServerVersion = ProtocolVersion.getLatestTLS(serverVersions);
            } else if (clientVersion.isDTLS()) {
                latestServerVersion = ProtocolVersion.getLatestDTLS(serverVersions);
            } else {
                throw new TlsFatalAlert(80);
            }
            if (null != latestServerVersion && latestServerVersion.isLaterVersionOf(clientVersion)) {
                throw new TlsFatalAlert(86);
            }
        }
    }

    public void notifyOfferedCipherSuites(int[] offeredCipherSuites) throws IOException {
        this.offeredCipherSuites = offeredCipherSuites;
    }

    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        this.clientExtensions = clientExtensions;
        if (null != clientExtensions) {
            this.clientProtocolNames = TlsExtensionsUtils.getALPNExtensionClient(clientExtensions);
            if (this.shouldSelectProtocolNameEarly() && null != this.clientProtocolNames && !this.clientProtocolNames.isEmpty()) {
                this.selectedProtocolName = this.selectProtocolName();
            }
            this.encryptThenMACOffered = TlsExtensionsUtils.hasEncryptThenMACExtension(clientExtensions);
            this.truncatedHMacOffered = TlsExtensionsUtils.hasTruncatedHMacExtension(clientExtensions);
            this.statusRequestV2 = TlsExtensionsUtils.getStatusRequestV2Extension(clientExtensions);
            this.trustedCAKeys = TlsExtensionsUtils.getTrustedCAKeysExtensionClient(clientExtensions);
            this.clientSentECPointFormats = null != TlsExtensionsUtils.getSupportedPointFormatsExtension(clientExtensions);
            this.certificateStatusRequest = TlsExtensionsUtils.getStatusRequestExtension(clientExtensions);
            this.maxFragmentLengthOffered = TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions);
            if (this.maxFragmentLengthOffered >= 0 && !MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
                throw new TlsFatalAlert(47);
            }
        }
    }

    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion[] serverVersions = this.getProtocolVersions();
        ProtocolVersion[] clientVersions = this.context.getClientSupportedVersions();
        for (int i = 0; i < clientVersions.length; ++i) {
            ProtocolVersion clientVersion = clientVersions[i];
            if (!ProtocolVersion.contains(serverVersions, clientVersion)) continue;
            return clientVersion;
        }
        throw new TlsFatalAlert(70);
    }

    public int[] getSupportedGroups() throws IOException {
        return new int[]{29, 30, 23, 24, 256, 257, 258};
    }

    public int getSelectedCipherSuite() throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        if (TlsUtils.isTLSv13(negotiatedVersion)) {
            int commonCipherSuite13 = TlsUtils.getCommonCipherSuite13(negotiatedVersion, this.offeredCipherSuites, this.getCipherSuites(), this.preferLocalCipherSuites());
            if (commonCipherSuite13 >= 0 && this.selectCipherSuite(commonCipherSuite13)) {
                return commonCipherSuite13;
            }
        } else {
            Vector sigAlgs = TlsUtils.getUsableSignatureAlgorithms(securityParameters.getClientSigAlgs());
            int availCurveBits = this.getMaximumNegotiableCurveBits();
            int availFiniteFieldBits = this.getMaximumNegotiableFiniteFieldBits();
            int[] cipherSuites = TlsUtils.getCommonCipherSuites(this.offeredCipherSuites, this.getCipherSuites(), this.preferLocalCipherSuites());
            for (int i = 0; i < cipherSuites.length; ++i) {
                int cipherSuite = cipherSuites[i];
                if (!this.isSelectableCipherSuite(cipherSuite, availCurveBits, availFiniteFieldBits, sigAlgs) || !this.selectCipherSuite(cipherSuite)) continue;
                return cipherSuite;
            }
        }
        throw new TlsFatalAlert(40, "No selectable cipher suite");
    }

    public Hashtable getServerExtensions() throws IOException {
        boolean isTLSv13 = TlsUtils.isTLSv13(this.context);
        if (isTLSv13) {
            if (null != this.certificateStatusRequest && this.allowCertificateStatus()) {
                // empty if block
            }
        } else {
            if (this.encryptThenMACOffered && this.allowEncryptThenMAC() && TlsUtils.isBlockCipherSuite(this.selectedCipherSuite)) {
                TlsExtensionsUtils.addEncryptThenMACExtension(this.serverExtensions);
            }
            if (this.truncatedHMacOffered && this.allowTruncatedHMac()) {
                TlsExtensionsUtils.addTruncatedHMacExtension(this.serverExtensions);
            }
            if (this.clientSentECPointFormats && TlsECCUtils.isECCCipherSuite(this.selectedCipherSuite)) {
                TlsExtensionsUtils.addSupportedPointFormatsExtension(this.serverExtensions, new short[]{0});
            }
            if (null != this.statusRequestV2 && this.allowMultiCertStatus()) {
                TlsExtensionsUtils.addEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request_v2);
            } else if (null != this.certificateStatusRequest && this.allowCertificateStatus()) {
                TlsExtensionsUtils.addEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request);
            }
            if (null != this.trustedCAKeys && this.allowTrustedCAIndication()) {
                TlsExtensionsUtils.addTrustedCAKeysExtensionServer(this.serverExtensions);
            }
        }
        if (this.maxFragmentLengthOffered >= 0 && MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
            TlsExtensionsUtils.addMaxFragmentLengthExtension(this.serverExtensions, this.maxFragmentLengthOffered);
        }
        return this.serverExtensions;
    }

    public void getServerExtensionsForConnection(Hashtable serverExtensions) throws IOException {
        if (!this.shouldSelectProtocolNameEarly() && null != this.clientProtocolNames && !this.clientProtocolNames.isEmpty()) {
            this.selectedProtocolName = this.selectProtocolName();
        }
        if (null == this.selectedProtocolName) {
            serverExtensions.remove(TlsExtensionsUtils.EXT_application_layer_protocol_negotiation);
        } else {
            TlsExtensionsUtils.addALPNExtensionServer(serverExtensions, this.selectedProtocolName);
        }
    }

    public Vector getServerSupplementalData() throws IOException {
        return null;
    }

    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        return null;
    }

    public TlsPSKIdentityManager getPSKIdentityManager() throws IOException {
        return null;
    }

    public TlsSRPLoginParameters getSRPLoginParameters() throws IOException {
        return null;
    }

    public TlsDHConfig getDHConfig() throws IOException {
        int minimumFiniteFieldBits = TlsDHUtils.getMinimumFiniteFieldBits(this.selectedCipherSuite);
        int namedGroup = this.selectDH(minimumFiniteFieldBits);
        return TlsDHUtils.createNamedDHConfig(this.context, namedGroup);
    }

    public TlsECConfig getECDHConfig() throws IOException {
        int minimumCurveBits = TlsECCUtils.getMinimumCurveBits(this.selectedCipherSuite);
        int namedGroup = this.selectECDH(minimumCurveBits);
        return TlsECCUtils.createNamedECConfig(this.context, namedGroup);
    }

    public void processClientSupplementalData(Vector clientSupplementalData) throws IOException {
        if (clientSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public NewSessionTicket getNewSessionTicket() throws IOException {
        return new NewSessionTicket(0L, TlsUtils.EMPTY_BYTES);
    }
}

