/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.io.TeeInputStream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsECDHEKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsECConfig ecConfig;
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsCertificate serverCertificate = null;
    protected TlsAgreement agreement;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 17: 
            case 19: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsECDHEKeyExchange(int keyExchange) {
        this(keyExchange, null);
    }

    public TlsECDHEKeyExchange(int keyExchange, TlsECConfig ecConfig) {
        super(TlsECDHEKeyExchange.checkKeyExchange(keyExchange));
        this.ecConfig = ecConfig;
    }

    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.serverCredentials = TlsUtils.requireSignerCredentials(serverCredentials);
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        this.serverCertificate = serverCertificate.getCertificateAt(0);
    }

    public boolean requiresServerKeyExchange() {
        return true;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        DigestInputBuffer digestBuffer = new DigestInputBuffer();
        TlsECCUtils.writeECConfig(this.ecConfig, digestBuffer);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.generateEphemeral(digestBuffer);
        TlsUtils.generateServerKeyExchangeSignature(this.context, this.serverCredentials, null, digestBuffer);
        return digestBuffer.toByteArray();
    }

    public void processServerKeyExchange(InputStream input) throws IOException {
        DigestInputBuffer digestBuffer = new DigestInputBuffer();
        TeeInputStream teeIn = new TeeInputStream(input, (OutputStream)digestBuffer);
        this.ecConfig = TlsECCUtils.receiveECDHConfig(this.context, (InputStream)teeIn);
        byte[] point = TlsUtils.readOpaque8((InputStream)teeIn, 1);
        TlsUtils.verifyServerKeyExchangeSignature(this.context, input, this.serverCertificate, null, digestBuffer);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.processEphemeral(point);
    }

    public short[] getClientCertificateTypes() {
        return new short[]{2, 64, 1};
    }

    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        TlsUtils.requireSignerCredentials(clientCredentials);
    }

    public void generateClientKeyExchange(OutputStream output) throws IOException {
        this.generateEphemeral(output);
    }

    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] point = TlsUtils.readOpaque8(input, 1);
        this.processEphemeral(point);
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreement.calculateSecret();
    }

    protected void generateEphemeral(OutputStream output) throws IOException {
        byte[] point = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque8(point, output);
    }

    protected void processEphemeral(byte[] point) throws IOException {
        TlsECCUtils.checkPointEncoding(this.ecConfig.getNamedGroup(), point);
        this.agreement.receivePeerValue(point);
    }
}

