/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsEncryptor;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class JcaTlsRSAEncryptor
implements TlsEncryptor {
    private final JcaTlsCrypto crypto;
    private final PublicKey pubKeyRSA;

    JcaTlsRSAEncryptor(JcaTlsCrypto crypto, PublicKey pubKeyRSA) {
        this.crypto = crypto;
        this.pubKeyRSA = pubKeyRSA;
    }

    public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
        try {
            Cipher c = this.crypto.createRSAEncryptionCipher();
            try {
                c.init(3, (Key)this.pubKeyRSA, this.crypto.getSecureRandom());
                return c.wrap(new SecretKeySpec(input, inOff, length, "TLS"));
            }
            catch (Exception e) {
                try {
                    c.init(1, (Key)this.pubKeyRSA, this.crypto.getSecureRandom());
                    return c.doFinal(input, inOff, length);
                }
                catch (Exception ex) {
                    throw new TlsFatalAlert(80, (Throwable)e);
                }
            }
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

