/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.Utils;
import org.bouncycastle.util.Arrays;

public class ServerNameList {
    protected Vector serverNameList;

    public ServerNameList(Vector serverNameList) {
        if (null == serverNameList) {
            throw new NullPointerException("'serverNameList' cannot be null");
        }
        this.serverNameList = serverNameList;
    }

    public Vector getServerNameList() {
        return this.serverNameList;
    }

    public void encode(OutputStream output) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        short[] nameTypesSeen = TlsUtils.EMPTY_SHORTS;
        for (int i = 0; i < this.serverNameList.size(); ++i) {
            ServerName entry = (ServerName)this.serverNameList.elementAt(i);
            if (null == (nameTypesSeen = ServerNameList.checkNameType(nameTypesSeen, entry.getNameType()))) {
                throw new TlsFatalAlert(80);
            }
            entry.encode(buf);
        }
        TlsUtils.checkUint16(buf.size());
        TlsUtils.writeUint16(buf.size(), output);
        Utils.writeBufTo(buf, output);
    }

    public static ServerNameList parse(InputStream input) throws IOException {
        byte[] data = TlsUtils.readOpaque16(input, 1);
        ByteArrayInputStream buf = new ByteArrayInputStream(data);
        short[] nameTypesSeen = TlsUtils.EMPTY_SHORTS;
        Vector<ServerName> server_name_list = new Vector<ServerName>();
        while (buf.available() > 0) {
            ServerName entry = ServerName.parse(buf);
            if (null == (nameTypesSeen = ServerNameList.checkNameType(nameTypesSeen, entry.getNameType()))) {
                throw new TlsFatalAlert(47);
            }
            server_name_list.addElement(entry);
        }
        return new ServerNameList(server_name_list);
    }

    private static short[] checkNameType(short[] nameTypesSeen, short nameType) {
        if (Arrays.contains((short[])nameTypesSeen, (short)nameType)) {
            return null;
        }
        return Arrays.append((short[])nameTypesSeen, (short)nameType);
    }
}

