/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsSecret;

public class TlsDHanonKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsDHGroupVerifier dhGroupVerifier;
    protected TlsDHConfig dhConfig;
    protected TlsAgreement agreement;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 11: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsDHanonKeyExchange(int keyExchange, TlsDHGroupVerifier dhGroupVerifier) {
        this(keyExchange, dhGroupVerifier, null);
    }

    public TlsDHanonKeyExchange(int keyExchange, TlsDHConfig dhConfig) {
        this(keyExchange, null, dhConfig);
    }

    private TlsDHanonKeyExchange(int keyExchange, TlsDHGroupVerifier dhGroupVerifier, TlsDHConfig dhConfig) {
        super(TlsDHanonKeyExchange.checkKeyExchange(keyExchange));
        this.dhGroupVerifier = dhGroupVerifier;
        this.dhConfig = dhConfig;
    }

    public void skipServerCredentials() throws IOException {
    }

    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public boolean requiresServerKeyExchange() {
        return true;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsDHUtils.writeDHConfig(this.dhConfig, buf);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        byte[] y = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(y, buf);
        return buf.toByteArray();
    }

    public void processServerKeyExchange(InputStream input) throws IOException {
        this.dhConfig = TlsDHUtils.receiveDHConfig(this.context, this.dhGroupVerifier, input);
        byte[] y = TlsUtils.readOpaque16(input, 1);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.agreement.receivePeerValue(y);
    }

    public short[] getClientCertificateTypes() {
        return null;
    }

    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void generateClientKeyExchange(OutputStream output) throws IOException {
        byte[] y = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(y, output);
    }

    public void processClientCertificate(Certificate clientCertificate) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] y = TlsUtils.readOpaque16(input, 1);
        this.agreement.receivePeerValue(y);
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreement.calculateSecret();
    }
}

