/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.util.Arrays;

public class TlsECCUtils {
    public static TlsECConfig createNamedECConfig(TlsContext context, int namedGroup) throws IOException {
        if (NamedGroup.getCurveBits(namedGroup) < 1) {
            throw new TlsFatalAlert(80);
        }
        return new TlsECConfig(namedGroup);
    }

    public static int getMinimumCurveBits(int cipherSuite) {
        return TlsECCUtils.isECCCipherSuite(cipherSuite) ? 1 : 0;
    }

    public static boolean isECCCipherSuite(int cipherSuite) {
        switch (TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static void checkPointEncoding(int namedGroup, byte[] encoding) throws IOException {
        if (TlsUtils.isNullOrEmpty(encoding)) {
            throw new TlsFatalAlert(47);
        }
        switch (namedGroup) {
            case 29: 
            case 30: {
                return;
            }
        }
        switch (encoding[0]) {
            case 4: {
                return;
            }
        }
        throw new TlsFatalAlert(47);
    }

    public static TlsECConfig receiveECDHConfig(TlsContext context, InputStream input) throws IOException {
        int[] clientSupportedGroups;
        short curveType = TlsUtils.readUint8(input);
        if (curveType != 3) {
            throw new TlsFatalAlert(40);
        }
        int namedGroup = TlsUtils.readUint16(input);
        if (NamedGroup.refersToAnECDHCurve(namedGroup) && (null == (clientSupportedGroups = context.getSecurityParametersHandshake().getClientSupportedGroups()) || Arrays.contains((int[])clientSupportedGroups, (int)namedGroup))) {
            return new TlsECConfig(namedGroup);
        }
        throw new TlsFatalAlert(47);
    }

    public static void writeECConfig(TlsECConfig ecConfig, OutputStream output) throws IOException {
        TlsECCUtils.writeNamedECParameters(ecConfig.getNamedGroup(), output);
    }

    public static void writeNamedECParameters(int namedGroup, OutputStream output) throws IOException {
        if (!NamedGroup.refersToASpecificCurve(namedGroup)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeUint8((short)3, output);
        TlsUtils.checkUint16(namedGroup);
        TlsUtils.writeUint16(namedGroup, output);
    }
}

