/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.SRP6Group;
import org.bouncycastle.tls.crypto.Tls13Verifier;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsKemConfig;
import org.bouncycastle.tls.crypto.TlsKemDomain;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.AEADNonceGeneratorFactory;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsNullCipher;
import org.bouncycastle.tls.crypto.impl.jcajce.DHUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.GCMFipsUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaNonceGenerator;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaSSL3HMAC;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTls13Verifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsHash;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JceAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceBlockCipherWithCBCImplicitIVImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceChaCha20Poly1305;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsDHDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsECDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsHMAC;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JceX25519Domain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceX448Domain;
import org.bouncycastle.tls.crypto.impl.jcajce.RSAUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Client;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Server;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6VerifierGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcaTlsCrypto
extends AbstractTlsCrypto {
    private final JcaJceHelper helper;
    private final SecureRandom entropySource;
    private final SecureRandom nonceEntropySource;
    private final Hashtable supportedEncryptionAlgorithms = new Hashtable();
    private final Hashtable supportedNamedGroups = new Hashtable();
    private final Hashtable supportedOther = new Hashtable();

    protected JcaTlsCrypto(JcaJceHelper helper, SecureRandom entropySource, SecureRandom nonceEntropySource) {
        this.helper = helper;
        this.entropySource = entropySource;
        this.nonceEntropySource = nonceEntropySource;
    }

    JceTlsSecret adoptLocalSecret(byte[] data) {
        return new JceTlsSecret(this, data);
    }

    Cipher createRSAEncryptionCipher() throws GeneralSecurityException {
        try {
            return this.getHelper().createCipher("RSA/NONE/PKCS1Padding");
        }
        catch (GeneralSecurityException e) {
            return this.getHelper().createCipher("RSA/ECB/PKCS1Padding");
        }
    }

    @Override
    public TlsNonceGenerator createNonceGenerator(byte[] additionalSeedMaterial) {
        return new JcaNonceGenerator(this.nonceEntropySource, additionalSeedMaterial);
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    public byte[] calculateKeyAgreement(String agreementAlgorithm, PrivateKey privateKey, PublicKey publicKey, String secretAlgorithm) throws GeneralSecurityException {
        KeyAgreement agreement = this.helper.createKeyAgreement(agreementAlgorithm);
        agreement.init(privateKey);
        agreement.doPhase(publicKey, true);
        try {
            return agreement.generateSecret(secretAlgorithm).getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            if ("X25519".equals(agreementAlgorithm) || "X448".equals(agreementAlgorithm)) {
                return agreement.generateSecret();
            }
            throw e;
        }
    }

    @Override
    public TlsCertificate createCertificate(byte[] encoding) throws IOException {
        return this.createCertificate((short)0, encoding);
    }

    @Override
    public TlsCertificate createCertificate(short type, byte[] encoding) throws IOException {
        if (type != 0) {
            throw new TlsFatalAlert(43);
        }
        return new JcaTlsCertificate(this, encoding);
    }

    @Override
    public TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        try {
            switch (encryptionAlgorithm) {
                case 7: {
                    return this.createCipher_CBC(cryptoParams, "DESede", 24, macAlgorithm);
                }
                case 8: {
                    return this.createCipher_CBC(cryptoParams, "AES", 16, macAlgorithm);
                }
                case 15: {
                    return this.createCipher_AES_CCM(cryptoParams, 16, 16);
                }
                case 16: {
                    return this.createCipher_AES_CCM(cryptoParams, 16, 8);
                }
                case 10: {
                    return this.createCipher_AES_GCM(cryptoParams, 16, 16);
                }
                case 9: {
                    return this.createCipher_CBC(cryptoParams, "AES", 32, macAlgorithm);
                }
                case 17: {
                    return this.createCipher_AES_CCM(cryptoParams, 32, 16);
                }
                case 18: {
                    return this.createCipher_AES_CCM(cryptoParams, 32, 8);
                }
                case 11: {
                    return this.createCipher_AES_GCM(cryptoParams, 32, 16);
                }
                case 22: {
                    return this.createCipher_CBC(cryptoParams, "ARIA", 16, macAlgorithm);
                }
                case 24: {
                    return this.createCipher_ARIA_GCM(cryptoParams, 16, 16);
                }
                case 23: {
                    return this.createCipher_CBC(cryptoParams, "ARIA", 32, macAlgorithm);
                }
                case 25: {
                    return this.createCipher_ARIA_GCM(cryptoParams, 32, 16);
                }
                case 12: {
                    return this.createCipher_CBC(cryptoParams, "Camellia", 16, macAlgorithm);
                }
                case 19: {
                    return this.createCipher_Camellia_GCM(cryptoParams, 16, 16);
                }
                case 13: {
                    return this.createCipher_CBC(cryptoParams, "Camellia", 32, macAlgorithm);
                }
                case 20: {
                    return this.createCipher_Camellia_GCM(cryptoParams, 32, 16);
                }
                case 21: {
                    return this.createChaCha20Poly1305(cryptoParams);
                }
                case 0: {
                    return this.createNullCipher(cryptoParams, macAlgorithm);
                }
                case 14: {
                    return this.createCipher_CBC(cryptoParams, "SEED", 16, macAlgorithm);
                }
                case 28: {
                    return this.createCipher_CBC(cryptoParams, "SM4", 16, macAlgorithm);
                }
                case 26: {
                    return this.createCipher_SM4_CCM(cryptoParams);
                }
                case 27: {
                    return this.createCipher_SM4_GCM(cryptoParams);
                }
            }
            throw new TlsFatalAlert(80);
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("cannot create cipher: " + e.getMessage(), e);
        }
    }

    @Override
    public TlsHMAC createHMAC(int macAlgorithm) {
        switch (macAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.createHMACForHash(TlsCryptoUtils.getHashForHMAC(macAlgorithm));
            }
        }
        throw new IllegalArgumentException("invalid MACAlgorithm: " + macAlgorithm);
    }

    @Override
    public TlsHMAC createHMACForHash(int cryptoHashAlgorithm) {
        String hmacName = this.getHMACAlgorithmName(cryptoHashAlgorithm);
        try {
            return new JceTlsHMAC(cryptoHashAlgorithm, this.helper.createMac(hmacName), hmacName);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("cannot create HMAC: " + hmacName, e);
        }
    }

    protected TlsHMAC createHMAC_SSL(int macAlgorithm) throws GeneralSecurityException, IOException {
        switch (macAlgorithm) {
            case 1: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName(1)), 16, 64);
            }
            case 2: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName(2)), 20, 64);
            }
            case 3: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName(4)), 32, 64);
            }
            case 4: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName(5)), 48, 128);
            }
            case 5: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName(6)), 64, 128);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsHMAC createMAC(TlsCryptoParameters cryptoParams, int macAlgorithm) throws GeneralSecurityException, IOException {
        if (TlsImplUtils.isSSL(cryptoParams)) {
            return this.createHMAC_SSL(macAlgorithm);
        }
        return this.createHMAC(macAlgorithm);
    }

    @Override
    public TlsSRP6Client createSRP6Client(TlsSRPConfig srpConfig) {
        final SRP6Client srpClient = new SRP6Client();
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6Group srpGroup = new SRP6Group(ng[0], ng[1]);
        srpClient.init(srpGroup, this.createHash(2), this.getSecureRandom());
        return new TlsSRP6Client(){

            @Override
            public BigInteger calculateSecret(BigInteger serverB) throws TlsFatalAlert {
                try {
                    return srpClient.calculateSecret(serverB);
                }
                catch (IllegalArgumentException e) {
                    throw new TlsFatalAlert(47, (Throwable)e);
                }
            }

            @Override
            public BigInteger generateClientCredentials(byte[] srpSalt, byte[] identity, byte[] password) {
                return srpClient.generateClientCredentials(srpSalt, identity, password);
            }
        };
    }

    @Override
    public TlsSRP6Server createSRP6Server(TlsSRPConfig srpConfig, BigInteger srpVerifier) {
        final SRP6Server srpServer = new SRP6Server();
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6Group srpGroup = new SRP6Group(ng[0], ng[1]);
        srpServer.init(srpGroup, srpVerifier, this.createHash(2), this.getSecureRandom());
        return new TlsSRP6Server(){

            @Override
            public BigInteger generateServerCredentials() {
                return srpServer.generateServerCredentials();
            }

            @Override
            public BigInteger calculateSecret(BigInteger clientA) throws IOException {
                try {
                    return srpServer.calculateSecret(clientA);
                }
                catch (IllegalArgumentException e) {
                    throw new TlsFatalAlert(47, (Throwable)e);
                }
            }
        };
    }

    @Override
    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig srpConfig) {
        BigInteger[] ng = srpConfig.getExplicitNG();
        final SRP6VerifierGenerator verifierGenerator = new SRP6VerifierGenerator();
        verifierGenerator.init(ng[0], ng[1], this.createHash(2));
        return new TlsSRP6VerifierGenerator(){

            @Override
            public BigInteger generateVerifier(byte[] salt, byte[] identity, byte[] password) {
                return verifierGenerator.generateVerifier(salt, identity, password);
            }
        };
    }

    String getHMACAlgorithmName(int cryptoHashAlgorithm) {
        switch (cryptoHashAlgorithm) {
            case 1: {
                return "HmacMD5";
            }
            case 2: {
                return "HmacSHA1";
            }
            case 3: {
                return "HmacSHA224";
            }
            case 4: {
                return "HmacSHA256";
            }
            case 5: {
                return "HmacSHA384";
            }
            case 6: {
                return "HmacSHA512";
            }
            case 7: {
                return "HmacSM3";
            }
            case 8: {
                return "HmacGOST3411-2012-256";
            }
        }
        throw new IllegalArgumentException("invalid CryptoHashAlgorithm: " + cryptoHashAlgorithm);
    }

    public AlgorithmParameters getNamedGroupAlgorithmParameters(int namedGroup) throws GeneralSecurityException {
        if (NamedGroup.refersToAnXDHCurve(namedGroup)) {
            switch (namedGroup) {
                case 29: 
                case 30: {
                    return null;
                }
            }
        } else {
            if (NamedGroup.refersToAnECDSACurve(namedGroup)) {
                return ECUtil.getAlgorithmParameters(this, NamedGroup.getCurveName(namedGroup));
            }
            if (NamedGroup.refersToASpecificFiniteField(namedGroup)) {
                return DHUtil.getAlgorithmParameters(this, TlsDHUtils.getNamedDHGroup(namedGroup));
            }
            if (NamedGroup.refersToASpecificKem(namedGroup)) {
                switch (namedGroup) {
                    case 583: 
                    case 584: 
                    case 585: 
                    case 1298: 
                    case 1896: 
                    case 4132: {
                        return null;
                    }
                }
            }
        }
        throw new IllegalArgumentException("NamedGroup not supported: " + NamedGroup.getText(namedGroup));
    }

    public AlgorithmParameters getSignatureSchemeAlgorithmParameters(int signatureScheme) throws GeneralSecurityException {
        if (!SignatureScheme.isRSAPSS(signatureScheme)) {
            return null;
        }
        int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
        if (cryptoHashAlgorithm < 0) {
            return null;
        }
        String digestName = this.getDigestName(cryptoHashAlgorithm);
        String sigName = RSAUtil.getDigestSigAlgName(digestName) + "WITHRSAANDMGF1";
        AlgorithmParameterSpec pssSpec = RSAUtil.getPSSParameterSpec(cryptoHashAlgorithm, digestName, this.getHelper());
        Signature signer = this.getHelper().createSignature(sigName);
        signer.setParameter(pssSpec);
        return signer.getParameters();
    }

    @Override
    public boolean hasAnyStreamVerifiers(Vector signatureAndHashAlgorithms) {
        boolean isRSAStreamVerifier = JcaUtils.isSunMSCAPIProviderActive();
        int count = signatureAndHashAlgorithms.size();
        for (int i = 0; i < count; ++i) {
            SignatureAndHashAlgorithm algorithm = (SignatureAndHashAlgorithm)signatureAndHashAlgorithms.elementAt(i);
            switch (algorithm.getSignature()) {
                case 1: {
                    if (!isRSAStreamVerifier) break;
                    return true;
                }
                case 2: {
                    if (HashAlgorithm.getOutputSize(algorithm.getHash()) == 20) break;
                    return true;
                }
            }
            switch (SignatureScheme.from(algorithm)) {
                case 2052: 
                case 2053: 
                case 2054: 
                case 2055: 
                case 2056: 
                case 2057: 
                case 2058: 
                case 2059: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasAnyStreamVerifiersLegacy(short[] clientCertificateTypes) {
        return false;
    }

    @Override
    public boolean hasCryptoHashAlgorithm(int cryptoHashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasCryptoSignatureAlgorithm(int cryptoSignatureAlgorithm) {
        switch (cryptoSignatureAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasDHAgreement() {
        return true;
    }

    @Override
    public boolean hasECDHAgreement() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEncryptionAlgorithm(int encryptionAlgorithm) {
        Integer key = Integers.valueOf((int)encryptionAlgorithm);
        Hashtable hashtable = this.supportedEncryptionAlgorithms;
        synchronized (hashtable) {
            Boolean cached = (Boolean)this.supportedEncryptionAlgorithms.get(key);
            if (cached != null) {
                return cached;
            }
        }
        Boolean supported = this.isSupportedEncryptionAlgorithm(encryptionAlgorithm);
        if (null == supported) {
            return false;
        }
        Hashtable hashtable2 = this.supportedEncryptionAlgorithms;
        synchronized (hashtable2) {
            Boolean cached = this.supportedEncryptionAlgorithms.put(key, supported);
            if (null != cached && supported != cached) {
                this.supportedEncryptionAlgorithms.put(key, cached);
                supported = cached;
            }
        }
        return supported;
    }

    @Override
    public boolean hasHKDFAlgorithm(int cryptoHashAlgorithm) {
        switch (cryptoHashAlgorithm) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasKemAgreement() {
        return true;
    }

    @Override
    public boolean hasMacAlgorithm(int macAlgorithm) {
        switch (macAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNamedGroup(int namedGroup) {
        Integer key = Integers.valueOf((int)namedGroup);
        Hashtable hashtable = this.supportedNamedGroups;
        synchronized (hashtable) {
            Boolean cached = (Boolean)this.supportedNamedGroups.get(key);
            if (null != cached) {
                return cached;
            }
        }
        Boolean supported = this.isSupportedNamedGroup(namedGroup);
        if (null == supported) {
            return false;
        }
        Hashtable hashtable2 = this.supportedNamedGroups;
        synchronized (hashtable2) {
            Boolean cached = this.supportedNamedGroups.put(key, supported);
            if (null != cached && supported != cached) {
                this.supportedNamedGroups.put(key, cached);
                supported = cached;
            }
        }
        return supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRSAEncryption() {
        Boolean supported;
        String key = "KE_RSA";
        Hashtable hashtable = this.supportedOther;
        synchronized (hashtable) {
            Boolean cached = (Boolean)this.supportedOther.get("KE_RSA");
            if (cached != null) {
                return cached;
            }
        }
        try {
            this.createRSAEncryptionCipher();
            supported = Boolean.TRUE;
        }
        catch (GeneralSecurityException e) {
            supported = Boolean.FALSE;
        }
        Hashtable hashtable2 = this.supportedOther;
        synchronized (hashtable2) {
            Boolean cached = this.supportedOther.put("KE_RSA", supported);
            if (null != cached && supported != cached) {
                this.supportedOther.put("KE_RSA", cached);
                supported = cached;
            }
        }
        return supported;
    }

    @Override
    public boolean hasSignatureAlgorithm(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm sigAndHashAlgorithm) {
        short signature = sigAndHashAlgorithm.getSignature();
        switch (sigAndHashAlgorithm.getHash()) {
            case 1: {
                return 1 == signature && this.hasSignatureAlgorithm(signature);
            }
            case 3: {
                return !JcaUtils.isSunMSCAPIProviderActive() && this.hasSignatureAlgorithm(signature);
            }
        }
        return this.hasSignatureAlgorithm(signature);
    }

    @Override
    public boolean hasSignatureScheme(int signatureScheme) {
        switch (signatureScheme) {
            case 1800: 
            case 2308: 
            case 2309: 
            case 2310: {
                return false;
            }
        }
        short signature = SignatureScheme.getSignatureAlgorithm(signatureScheme);
        switch (SignatureScheme.getCryptoHashAlgorithm(signatureScheme)) {
            case 1: {
                return 1 == signature && this.hasSignatureAlgorithm(signature);
            }
            case 3: {
                return !JcaUtils.isSunMSCAPIProviderActive() && this.hasSignatureAlgorithm(signature);
            }
        }
        return this.hasSignatureAlgorithm(signature);
    }

    @Override
    public boolean hasSRPAuthentication() {
        return true;
    }

    @Override
    public TlsSecret createSecret(byte[] data) {
        return this.adoptLocalSecret(Arrays.clone((byte[])data));
    }

    @Override
    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion version) {
        byte[] data = new byte[48];
        this.getSecureRandom().nextBytes(data);
        TlsUtils.writeVersion(version, data, 0);
        return this.adoptLocalSecret(data);
    }

    @Override
    public TlsHash createHash(int cryptoHashAlgorithm) {
        try {
            return this.createHash(this.getDigestName(cryptoHashAlgorithm));
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalArgumentException("unable to create message digest:" + e.getMessage(), e);
        }
    }

    @Override
    public TlsDHDomain createDHDomain(TlsDHConfig dhConfig) {
        return new JceTlsDHDomain(this, dhConfig);
    }

    @Override
    public TlsECDomain createECDomain(TlsECConfig ecConfig) {
        switch (ecConfig.getNamedGroup()) {
            case 29: {
                return new JceX25519Domain(this);
            }
            case 30: {
                return new JceX448Domain(this);
            }
        }
        return new JceTlsECDomain(this, ecConfig);
    }

    @Override
    public TlsKemDomain createKemDomain(TlsKemConfig kemConfig) {
        return null;
    }

    @Override
    public TlsSecret hkdfInit(int cryptoHashAlgorithm) {
        return this.adoptLocalSecret(new byte[TlsCryptoUtils.getHashOutputSize(cryptoHashAlgorithm)]);
    }

    protected TlsAEADCipherImpl createAEADCipher(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceAEADCipherImpl(this, this.helper, cipherName, algorithm, keySize, isEncrypting);
    }

    protected TlsBlockCipherImpl createBlockCipher(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceBlockCipherImpl(this, this.helper.createCipher(cipherName), algorithm, keySize, isEncrypting);
    }

    protected TlsBlockCipherImpl createBlockCipherWithCBCImplicitIV(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceBlockCipherWithCBCImplicitIVImpl(this, this.helper.createCipher(cipherName), algorithm, isEncrypting);
    }

    protected TlsHash createHash(String digestName) throws GeneralSecurityException {
        return new JcaTlsHash(this.helper.createDigest(digestName));
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsNullCipher(cryptoParams, this.createMAC(cryptoParams, macAlgorithm), this.createMAC(cryptoParams, macAlgorithm));
    }

    protected TlsStreamSigner createStreamSigner(SignatureAndHashAlgorithm algorithm, PrivateKey privateKey, boolean needsRandom) throws IOException {
        String algorithmName = JcaUtils.getJcaAlgorithmName(algorithm);
        return this.createStreamSigner(algorithmName, null, privateKey, needsRandom);
    }

    protected TlsStreamSigner createStreamSigner(String algorithmName, AlgorithmParameterSpec parameter, PrivateKey privateKey, boolean needsRandom) throws IOException {
        try {
            SecureRandom random = needsRandom ? this.getSecureRandom() : null;
            JcaJceHelper helper = this.getHelper();
            try {
                if (null != parameter) {
                    Signature dummySigner = helper.createSignature(algorithmName);
                    dummySigner.initSign(privateKey, random);
                    helper = new ProviderJcaJceHelper(dummySigner.getProvider());
                }
                Signature signer = helper.createSignature(algorithmName);
                if (null != parameter) {
                    signer.setParameter(parameter);
                }
                signer.initSign(privateKey, random);
                return new JcaTlsStreamSigner(signer);
            }
            catch (InvalidKeyException e) {
                String upperAlg = Strings.toUpperCase((String)algorithmName);
                if (upperAlg.endsWith("MGF1")) {
                    algorithmName = upperAlg.replace("ANDMGF1", "SSA-PSS");
                    return this.createStreamSigner(algorithmName, parameter, privateKey, needsRandom);
                }
                throw e;
            }
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    protected TlsStreamVerifier createStreamVerifier(DigitallySigned digitallySigned, PublicKey publicKey) throws IOException {
        String algorithmName = JcaUtils.getJcaAlgorithmName(digitallySigned.getAlgorithm());
        return this.createStreamVerifier(algorithmName, null, digitallySigned.getSignature(), publicKey);
    }

    protected TlsStreamVerifier createStreamVerifier(String algorithmName, AlgorithmParameterSpec parameter, byte[] signature, PublicKey publicKey) throws IOException {
        try {
            JcaJceHelper helper = this.getHelper();
            if (null != parameter) {
                Signature dummyVerifier = helper.createSignature(algorithmName);
                dummyVerifier.initVerify(publicKey);
                helper = new ProviderJcaJceHelper(dummyVerifier.getProvider());
            }
            Signature verifier = helper.createSignature(algorithmName);
            if (null != parameter) {
                verifier.setParameter(parameter);
            }
            verifier.initVerify(publicKey);
            return new JcaTlsStreamVerifier(verifier, signature);
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    protected Tls13Verifier createTls13Verifier(String algorithmName, AlgorithmParameterSpec parameter, PublicKey publicKey) throws IOException {
        try {
            JcaJceHelper helper = this.getHelper();
            if (null != parameter) {
                Signature dummyVerifier = helper.createSignature(algorithmName);
                dummyVerifier.initVerify(publicKey);
                helper = new ProviderJcaJceHelper(dummyVerifier.getProvider());
            }
            Signature verifier = helper.createSignature(algorithmName);
            if (null != parameter) {
                verifier.setParameter(parameter);
            }
            verifier.initVerify(publicKey);
            return new JcaTls13Verifier(verifier);
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    protected Boolean isSupportedEncryptionAlgorithm(int encryptionAlgorithm) {
        switch (encryptionAlgorithm) {
            case 7: {
                return this.isUsableCipher("DESede/CBC/NoPadding", 192);
            }
            case 8: {
                return this.isUsableCipher("AES/CBC/NoPadding", 128);
            }
            case 15: 
            case 16: {
                return this.isUsableCipher("AES/CCM/NoPadding", 128);
            }
            case 10: {
                return this.isUsableCipher("AES/GCM/NoPadding", 128);
            }
            case 9: {
                return this.isUsableCipher("AES/CBC/NoPadding", 256);
            }
            case 17: 
            case 18: {
                return this.isUsableCipher("AES/CCM/NoPadding", 256);
            }
            case 11: {
                return this.isUsableCipher("AES/GCM/NoPadding", 256);
            }
            case 22: {
                return this.isUsableCipher("ARIA/CBC/NoPadding", 128);
            }
            case 24: {
                return this.isUsableCipher("ARIA/GCM/NoPadding", 128);
            }
            case 23: {
                return this.isUsableCipher("ARIA/CBC/NoPadding", 256);
            }
            case 25: {
                return this.isUsableCipher("ARIA/GCM/NoPadding", 256);
            }
            case 12: {
                return this.isUsableCipher("Camellia/CBC/NoPadding", 128);
            }
            case 19: {
                return this.isUsableCipher("Camellia/GCM/NoPadding", 128);
            }
            case 13: {
                return this.isUsableCipher("Camellia/CBC/NoPadding", 256);
            }
            case 20: {
                return this.isUsableCipher("Camellia/GCM/NoPadding", 256);
            }
            case 21: {
                return this.isUsableCipher("ChaCha7539", 256) && this.isUsableMAC("Poly1305");
            }
            case 0: {
                return Boolean.TRUE;
            }
            case 14: {
                return this.isUsableCipher("SEED/CBC/NoPadding", 128);
            }
            case 28: {
                return this.isUsableCipher("SM4/CBC/NoPadding", 128);
            }
            case 26: {
                return this.isUsableCipher("SM4/CCM/NoPadding", 128);
            }
            case 27: {
                return this.isUsableCipher("SM4/GCM/NoPadding", 128);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 29: 
            case 30: 
            case 31: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected Boolean isSupportedNamedGroup(int namedGroup) {
        try {
            if (NamedGroup.refersToAnXDHCurve(namedGroup)) {
                switch (namedGroup) {
                    case 29: {
                        this.helper.createKeyAgreement("X25519");
                        return Boolean.TRUE;
                    }
                    case 30: {
                        this.helper.createKeyAgreement("X448");
                        return Boolean.TRUE;
                    }
                }
            } else {
                if (NamedGroup.refersToASpecificKem(namedGroup)) {
                    return Boolean.TRUE;
                }
                if (NamedGroup.refersToAnECDSACurve(namedGroup)) {
                    return ECUtil.isCurveSupported(this, NamedGroup.getCurveName(namedGroup));
                }
                if (NamedGroup.refersToASpecificFiniteField(namedGroup)) {
                    return DHUtil.isGroupSupported(this, TlsDHUtils.getNamedDHGroup(namedGroup));
                }
            }
        }
        catch (GeneralSecurityException e) {
            return Boolean.FALSE;
        }
        return null;
    }

    protected boolean isUsableCipher(String cipherAlgorithm, int keySize) {
        try {
            this.helper.createCipher(cipherAlgorithm);
            return Cipher.getMaxAllowedKeyLength(cipherAlgorithm) >= keySize;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    protected boolean isUsableMAC(String macAlgorithm) {
        try {
            this.helper.createMac(macAlgorithm);
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    public JcaJceHelper getHelper() {
        return this.helper;
    }

    protected TlsBlockCipherImpl createCBCBlockCipherImpl(TlsCryptoParameters cryptoParams, String algorithm, int cipherKeySize, boolean forEncryption) throws GeneralSecurityException {
        String cipherName = algorithm + "/CBC/NoPadding";
        if (TlsImplUtils.isTLSv11(cryptoParams)) {
            return this.createBlockCipher(cipherName, algorithm, cipherKeySize, forEncryption);
        }
        return this.createBlockCipherWithCBCImplicitIV(cipherName, algorithm, cipherKeySize, forEncryption);
    }

    private TlsCipher createChaCha20Poly1305(TlsCryptoParameters cryptoParams) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, new JceChaCha20Poly1305(this, this.helper, true), new JceChaCha20Poly1305(this, this.helper, false), 32, 16, 2, null);
    }

    private TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("AES/CCM/NoPadding", "AES", cipherKeySize, true), this.createAEADCipher("AES/CCM/NoPadding", "AES", cipherKeySize, false), cipherKeySize, macSize, 1, null);
    }

    private TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("AES/GCM/NoPadding", "AES", cipherKeySize, true), this.createAEADCipher("AES/GCM/NoPadding", "AES", cipherKeySize, false), cipherKeySize, macSize, 3, this.getFipsGCMNonceGeneratorFactory());
    }

    private TlsAEADCipher createCipher_ARIA_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("ARIA/GCM/NoPadding", "ARIA", cipherKeySize, true), this.createAEADCipher("ARIA/GCM/NoPadding", "ARIA", cipherKeySize, false), cipherKeySize, macSize, 3, this.getFipsGCMNonceGeneratorFactory());
    }

    private TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", cipherKeySize, true), this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", cipherKeySize, false), cipherKeySize, macSize, 3, this.getFipsGCMNonceGeneratorFactory());
    }

    protected TlsCipher createCipher_CBC(TlsCryptoParameters cryptoParams, String algorithm, int cipherKeySize, int macAlgorithm) throws GeneralSecurityException, IOException {
        TlsBlockCipherImpl encrypt = this.createCBCBlockCipherImpl(cryptoParams, algorithm, cipherKeySize, true);
        TlsBlockCipherImpl decrypt = this.createCBCBlockCipherImpl(cryptoParams, algorithm, cipherKeySize, false);
        TlsHMAC clientMAC = this.createMAC(cryptoParams, macAlgorithm);
        TlsHMAC serverMAC = this.createMAC(cryptoParams, macAlgorithm);
        return new TlsBlockCipher(cryptoParams, encrypt, decrypt, clientMAC, serverMAC, cipherKeySize);
    }

    private TlsAEADCipher createCipher_SM4_CCM(TlsCryptoParameters cryptoParams) throws IOException, GeneralSecurityException {
        int cipherKeySize = 16;
        int macSize = 16;
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("SM4/CCM/NoPadding", "SM4", cipherKeySize, true), this.createAEADCipher("SM4/CCM/NoPadding", "SM4", cipherKeySize, false), cipherKeySize, macSize, 1, null);
    }

    private TlsAEADCipher createCipher_SM4_GCM(TlsCryptoParameters cryptoParams) throws IOException, GeneralSecurityException {
        int cipherKeySize = 16;
        int macSize = 16;
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("SM4/GCM/NoPadding", "SM4", cipherKeySize, true), this.createAEADCipher("SM4/GCM/NoPadding", "SM4", cipherKeySize, false), cipherKeySize, macSize, 3, this.getFipsGCMNonceGeneratorFactory());
    }

    public AEADNonceGeneratorFactory getFipsGCMNonceGeneratorFactory() {
        return GCMFipsUtil.getDefaultFipsGCMNonceGeneratorFactory();
    }

    String getDigestName(int cryptoHashAlgorithm) {
        switch (cryptoHashAlgorithm) {
            case 1: {
                return "MD5";
            }
            case 2: {
                return "SHA-1";
            }
            case 3: {
                return "SHA-224";
            }
            case 4: {
                return "SHA-256";
            }
            case 5: {
                return "SHA-384";
            }
            case 6: {
                return "SHA-512";
            }
            case 7: {
                return "SM3";
            }
            case 8: {
                return "GOST3411-2012-256";
            }
        }
        throw new IllegalArgumentException("invalid CryptoHashAlgorithm: " + cryptoHashAlgorithm);
    }
}

