/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Tls13NullCipher
implements TlsCipher {
    private final TlsCryptoParameters cryptoParams;
    private final TlsHMAC readHMAC;
    private final TlsHMAC writeHMAC;
    private final byte[] readNonce;
    private final byte[] writeNonce;

    public Tls13NullCipher(TlsCryptoParameters cryptoParams, TlsHMAC readHMAC, TlsHMAC writeHMAC) throws IOException {
        SecurityParameters securityParameters = cryptoParams.getSecurityParametersHandshake();
        if (!TlsImplUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(80);
        }
        this.cryptoParams = cryptoParams;
        this.readHMAC = readHMAC;
        this.writeHMAC = writeHMAC;
        this.readNonce = new byte[readHMAC.getMacLength()];
        this.writeNonce = new byte[writeHMAC.getMacLength()];
        boolean isServer = cryptoParams.isServer();
        this.rekeyHmac(securityParameters, readHMAC, this.readNonce, !isServer);
        this.rekeyHmac(securityParameters, writeHMAC, this.writeNonce, isServer);
    }

    @Override
    public int getCiphertextDecodeLimit(int plaintextLimit) {
        return plaintextLimit + 1 + this.readHMAC.getMacLength();
    }

    @Override
    public int getCiphertextEncodeLimit(int plaintextLimit) {
        return plaintextLimit + 1 + this.writeHMAC.getMacLength();
    }

    @Override
    public int getPlaintextDecodeLimit(int ciphertextLimit) {
        return ciphertextLimit - this.readHMAC.getMacLength() - 1;
    }

    @Override
    public int getPlaintextEncodeLimit(int ciphertextLimit) {
        return ciphertextLimit - this.writeHMAC.getMacLength() - 1;
    }

    @Override
    public TlsEncodeResult encodePlaintext(long seqNo, short contentType, ProtocolVersion recordVersion, int headerAllocation, byte[] plaintext, int plaintextOffset, int plaintextLength) throws IOException {
        int macLength = this.writeHMAC.getMacLength();
        this.writeHMAC.reset();
        byte[] nonce = Tls13NullCipher.createRecordNonce(this.writeNonce, seqNo);
        this.writeHMAC.update(nonce, 0, nonce.length);
        int innerPlaintextLength = plaintextLength + 1;
        int ciphertextLength = innerPlaintextLength + macLength;
        byte[] output = new byte[headerAllocation + ciphertextLength];
        int outputPos = headerAllocation;
        short recordType = 23;
        byte[] additionalData = Tls13NullCipher.getAdditionalData(seqNo, recordType, recordVersion, ciphertextLength);
        try {
            System.arraycopy(plaintext, plaintextOffset, output, outputPos, plaintextLength);
            output[outputPos + plaintextLength] = (byte)contentType;
            this.writeHMAC.update(additionalData, 0, additionalData.length);
            this.writeHMAC.update(output, outputPos, innerPlaintextLength);
            this.writeHMAC.calculateMAC(output, outputPos + innerPlaintextLength);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        if ((outputPos += innerPlaintextLength + macLength) != output.length) {
            throw new TlsFatalAlert(80);
        }
        return new TlsEncodeResult(output, 0, output.length, recordType);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long seqNo, short recordType, ProtocolVersion recordVersion, byte[] ciphertext, int ciphertextOffset, int ciphertextLength) throws IOException {
        byte octet;
        int macLength = this.readHMAC.getMacLength();
        int innerPlaintextLength = ciphertextLength - macLength;
        if (innerPlaintextLength < 1) {
            throw new TlsFatalAlert(50);
        }
        this.readHMAC.reset();
        byte[] nonce = Tls13NullCipher.createRecordNonce(this.readNonce, seqNo);
        this.readHMAC.update(nonce, 0, nonce.length);
        byte[] additionalData = Tls13NullCipher.getAdditionalData(seqNo, recordType, recordVersion, ciphertextLength);
        try {
            this.readHMAC.update(additionalData, 0, additionalData.length);
            this.readHMAC.update(ciphertext, ciphertextOffset, innerPlaintextLength);
            byte[] calculated = this.readHMAC.calculateMAC();
            if (!Arrays.constantTimeAreEqual((int)macLength, (byte[])calculated, (int)0, (byte[])ciphertext, (int)(ciphertextOffset + innerPlaintextLength))) {
                throw new TlsFatalAlert(20);
            }
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(20, (Throwable)e);
        }
        short contentType = recordType;
        int plaintextLength = innerPlaintextLength;
        do {
            if (--plaintextLength >= 0) continue;
            throw new TlsFatalAlert(10);
        } while (0 == (octet = ciphertext[ciphertextOffset + plaintextLength]));
        contentType = (short)(octet & 0xFF);
        return new TlsDecodeResult(ciphertext, ciphertextOffset, plaintextLength, contentType);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        this.rekeyHmac(this.cryptoParams.getSecurityParametersConnection(), this.readHMAC, this.readNonce, !this.cryptoParams.isServer());
    }

    @Override
    public void rekeyEncoder() throws IOException {
        this.rekeyHmac(this.cryptoParams.getSecurityParametersConnection(), this.writeHMAC, this.writeNonce, this.cryptoParams.isServer());
    }

    @Override
    public boolean usesOpaqueRecordTypeDecode() {
        return true;
    }

    @Override
    public boolean usesOpaqueRecordTypeEncode() {
        return true;
    }

    private void rekeyHmac(SecurityParameters securityParameters, TlsHMAC hmac, byte[] nonce, boolean serverSecret) throws IOException {
        TlsSecret secret;
        TlsSecret tlsSecret = secret = serverSecret ? securityParameters.getTrafficSecretServer() : securityParameters.getTrafficSecretClient();
        if (null == secret) {
            throw new TlsFatalAlert(80);
        }
        this.setupHmac(hmac, nonce, secret, securityParameters.getPRFCryptoHashAlgorithm());
    }

    private void setupHmac(TlsHMAC hmac, byte[] nonce, TlsSecret secret, int cryptoHashAlgorithm) throws IOException {
        int length = hmac.getMacLength();
        byte[] key = Tls13NullCipher.hkdfExpandLabel(secret, cryptoHashAlgorithm, "key", length).extract();
        byte[] iv = Tls13NullCipher.hkdfExpandLabel(secret, cryptoHashAlgorithm, "iv", length).extract();
        hmac.setKey(key, 0, length);
        System.arraycopy(iv, 0, nonce, 0, length);
    }

    private static byte[] createRecordNonce(byte[] fixedNonce, long seqNo) {
        int nonceLength = fixedNonce.length;
        byte[] nonce = new byte[nonceLength];
        TlsUtils.writeUint64(seqNo, nonce, nonceLength - 8);
        Tls13NullCipher.xorTo(nonceLength, fixedNonce, nonce);
        return nonce;
    }

    private static byte[] getAdditionalData(long seqNo, short recordType, ProtocolVersion recordVersion, int ciphertextLength) throws IOException {
        byte[] additional_data = new byte[5];
        TlsUtils.writeUint8(recordType, additional_data, 0);
        TlsUtils.writeVersion(recordVersion, additional_data, 1);
        TlsUtils.writeUint16(ciphertextLength, additional_data, 3);
        return additional_data;
    }

    private static TlsSecret hkdfExpandLabel(TlsSecret secret, int cryptoHashAlgorithm, String label, int length) throws IOException {
        return TlsCryptoUtils.hkdfExpandLabel(secret, cryptoHashAlgorithm, label, TlsUtils.EMPTY_BYTES, length);
    }

    private static void xorTo(int len, byte[] x, byte[] z) {
        for (int i = 0; i < len; ++i) {
            int n = i;
            z[n] = (byte)(z[n] ^ x[i]);
        }
    }
}

