/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsECDH;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;

public class JceTlsECDomain
implements TlsECDomain {
    protected final JcaTlsCrypto crypto;
    protected final TlsECConfig ecConfig;
    protected ECNamedCurveGenParameterSpec ecGenSpec;
    protected ECParameterSpec ecParameterSpec;
    protected ECCurve ecCurve;

    public JceTlsECDomain(JcaTlsCrypto jcaTlsCrypto, TlsECConfig tlsECConfig) {
        this.crypto = jcaTlsCrypto;
        this.ecConfig = tlsECConfig;
        this.init(tlsECConfig.getNamedGroup());
    }

    public JceTlsSecret calculateECDHAgreement(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey) throws IOException {
        try {
            byte[] byArray = this.crypto.calculateKeyAgreement("ECDH", (PrivateKey)eCPrivateKey, (PublicKey)eCPublicKey, "TlsPremasterSecret");
            return this.crypto.adoptLocalSecret(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("cannot calculate secret", generalSecurityException);
        }
    }

    public TlsAgreement createECDH() {
        return new JceTlsECDH(this);
    }

    public ECPoint decodePoint(byte[] byArray) throws IOException {
        return this.ecCurve.decodePoint(byArray);
    }

    public ECPublicKey decodePublicKey(byte[] byArray) throws IOException {
        try {
            KeyFactory keyFactory = this.crypto.getHelper().createKeyFactory("EC");
            ECPoint eCPoint = this.decodePoint(byArray);
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(this.ecParameterSpec.getCurve().createPoint(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger()), this.ecParameterSpec);
            return (ECPublicKey)keyFactory.generatePublic((KeySpec)eCPublicKeySpec);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(47, (Throwable)exception);
        }
    }

    public byte[] encodePoint(ECPoint eCPoint) throws IOException {
        return eCPoint.getEncoded(false);
    }

    public byte[] encodePublicKey(ECPublicKey eCPublicKey) throws IOException {
        ECPoint eCPoint = eCPublicKey.getQ();
        return this.encodePoint(this.ecCurve.createPoint(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger()));
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("EC");
            keyPairGenerator.initialize((AlgorithmParameterSpec)this.ecGenSpec, this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException("unable to create key pair: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private void init(int n) {
        this.ecCurve = null;
        this.ecGenSpec = null;
        this.ecParameterSpec = null;
        if (!NamedGroup.refersToASpecificCurve(n)) {
            return;
        }
        String string = NamedGroup.getName(n);
        if (string == null) {
            return;
        }
        try {
            AlgorithmParameters algorithmParameters = this.crypto.getHelper().createAlgorithmParameters("EC");
            this.ecGenSpec = new ECNamedCurveGenParameterSpec(string);
            try {
                algorithmParameters.init((AlgorithmParameterSpec)this.ecGenSpec);
                ECParameterSpec eCParameterSpec = (ECParameterSpec)algorithmParameters.getParameterSpec(ECParameterSpec.class);
                this.ecCurve = eCParameterSpec.getCurve();
                this.ecParameterSpec = eCParameterSpec;
            }
            catch (Exception exception) {
                KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("EC");
                keyPairGenerator.initialize((AlgorithmParameterSpec)this.ecGenSpec, this.crypto.getSecureRandom());
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                ECParameterSpec eCParameterSpec = (ECParameterSpec)algorithmParameters.getParameterSpec(ECParameterSpec.class);
                this.ecCurve = eCParameterSpec.getCurve();
                this.ecParameterSpec = eCParameterSpec;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException("unable to create key pair: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private static int[] convertMidTerms(int[] nArray) {
        int[] nArray2 = new int[3];
        if (nArray.length == 1) {
            nArray2[0] = nArray[0];
        } else {
            if (nArray.length != 3) {
                throw new IllegalArgumentException("Only Trinomials and pentanomials supported");
            }
            if (nArray[0] < nArray[1] && nArray[0] < nArray[2]) {
                nArray2[0] = nArray[0];
                if (nArray[1] < nArray[2]) {
                    nArray2[1] = nArray[1];
                    nArray2[2] = nArray[2];
                } else {
                    nArray2[1] = nArray[2];
                    nArray2[2] = nArray[1];
                }
            } else if (nArray[1] < nArray[2]) {
                nArray2[0] = nArray[1];
                if (nArray[0] < nArray[2]) {
                    nArray2[1] = nArray[0];
                    nArray2[2] = nArray[2];
                } else {
                    nArray2[1] = nArray[2];
                    nArray2[2] = nArray[0];
                }
            } else {
                nArray2[0] = nArray[2];
                if (nArray[0] < nArray[1]) {
                    nArray2[1] = nArray[0];
                    nArray2[2] = nArray[1];
                } else {
                    nArray2[1] = nArray[1];
                    nArray2[2] = nArray[0];
                }
            }
        }
        return nArray2;
    }
}

