/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.io.SignerOutputStream;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcTlsRSAPSSSigner
extends BcTlsSigner {
    private final short signatureAlgorithm;

    public BcTlsRSAPSSSigner(BcTlsCrypto bcTlsCrypto, RSAKeyParameters rSAKeyParameters, short s) {
        super(bcTlsCrypto, (AsymmetricKeyParameter)rSAKeyParameters);
        if (!SignatureAlgorithm.isRSAPSS(s)) {
            throw new IllegalArgumentException("signatureAlgorithm");
        }
        this.signatureAlgorithm = s;
    }

    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (signatureAndHashAlgorithm == null || signatureAndHashAlgorithm.getSignature() != this.signatureAlgorithm || signatureAndHashAlgorithm.getHash() != 8) {
            throw new IllegalStateException();
        }
        short s = SignatureAlgorithm.getRSAPSSHashAlgorithm(this.signatureAlgorithm);
        Digest digest = this.crypto.createDigest(s);
        PSSSigner pSSSigner = new PSSSigner((AsymmetricBlockCipher)new RSABlindedEngine(), digest, HashAlgorithm.getOutputSize(s));
        pSSSigner.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)this.privateKey, this.crypto.getSecureRandom()));
        final SignerOutputStream signerOutputStream = new SignerOutputStream((Signer)pSSSigner);
        return new TlsStreamSigner(){

            public OutputStream getOutputStream() {
                return signerOutputStream;
            }

            public byte[] getSignature() throws IOException {
                try {
                    return signerOutputStream.getSigner().generateSignature();
                }
                catch (CryptoException cryptoException) {
                    throw new TlsFatalAlert(80, (Throwable)cryptoException);
                }
            }
        };
    }
}

