/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.util.Vector;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ProtocolVersion {
    public static final ProtocolVersion SSLv3 = new ProtocolVersion(768, "SSL 3.0");
    public static final ProtocolVersion TLSv10 = new ProtocolVersion(769, "TLS 1.0");
    public static final ProtocolVersion TLSv11 = new ProtocolVersion(770, "TLS 1.1");
    public static final ProtocolVersion TLSv12 = new ProtocolVersion(771, "TLS 1.2");
    public static final ProtocolVersion TLSv13 = new ProtocolVersion(772, "TLS 1.3");
    public static final ProtocolVersion DTLSv10 = new ProtocolVersion(65279, "DTLS 1.0");
    public static final ProtocolVersion DTLSv12 = new ProtocolVersion(65277, "DTLS 1.2");
    private int version;
    private String name;

    public static boolean contains(ProtocolVersion[] protocolVersionArray, ProtocolVersion protocolVersion) {
        if (protocolVersionArray != null && protocolVersion != null) {
            for (int i = 0; i < protocolVersionArray.length; ++i) {
                if (!protocolVersion.equals(protocolVersionArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static ProtocolVersion getEarliestDTLS(ProtocolVersion[] protocolVersionArray) {
        ProtocolVersion protocolVersion = null;
        if (null != protocolVersionArray) {
            for (int i = 0; i < protocolVersionArray.length; ++i) {
                ProtocolVersion protocolVersion2 = protocolVersionArray[i];
                if (null == protocolVersion2 || !protocolVersion2.isDTLS() || null != protocolVersion && protocolVersion2.getMinorVersion() <= protocolVersion.getMinorVersion()) continue;
                protocolVersion = protocolVersion2;
            }
        }
        return protocolVersion;
    }

    public static ProtocolVersion getEarliestTLS(ProtocolVersion[] protocolVersionArray) {
        ProtocolVersion protocolVersion = null;
        if (null != protocolVersionArray) {
            for (int i = 0; i < protocolVersionArray.length; ++i) {
                ProtocolVersion protocolVersion2 = protocolVersionArray[i];
                if (null == protocolVersion2 || !protocolVersion2.isTLS() || null != protocolVersion && protocolVersion2.getMinorVersion() >= protocolVersion.getMinorVersion()) continue;
                protocolVersion = protocolVersion2;
            }
        }
        return protocolVersion;
    }

    public static ProtocolVersion getLatestDTLS(ProtocolVersion[] protocolVersionArray) {
        ProtocolVersion protocolVersion = null;
        if (null != protocolVersionArray) {
            for (int i = 0; i < protocolVersionArray.length; ++i) {
                ProtocolVersion protocolVersion2 = protocolVersionArray[i];
                if (null == protocolVersion2 || !protocolVersion2.isDTLS() || null != protocolVersion && protocolVersion2.getMinorVersion() >= protocolVersion.getMinorVersion()) continue;
                protocolVersion = protocolVersion2;
            }
        }
        return protocolVersion;
    }

    public static ProtocolVersion getLatestTLS(ProtocolVersion[] protocolVersionArray) {
        ProtocolVersion protocolVersion = null;
        if (null != protocolVersionArray) {
            for (int i = 0; i < protocolVersionArray.length; ++i) {
                ProtocolVersion protocolVersion2 = protocolVersionArray[i];
                if (null == protocolVersion2 || !protocolVersion2.isTLS() || null != protocolVersion && protocolVersion2.getMinorVersion() <= protocolVersion.getMinorVersion()) continue;
                protocolVersion = protocolVersion2;
            }
        }
        return protocolVersion;
    }

    private ProtocolVersion(int n, String string) {
        this.version = n & 0xFFFF;
        this.name = string;
    }

    public ProtocolVersion[] downTo(ProtocolVersion protocolVersion) {
        if (!this.isEqualOrLaterVersionOf(protocolVersion)) {
            throw new IllegalArgumentException("'min' must be an equal or earlier version of this one");
        }
        Vector<ProtocolVersion> vector = new Vector<ProtocolVersion>();
        vector.addElement(this);
        ProtocolVersion protocolVersion2 = this;
        while (!protocolVersion2.equals(protocolVersion)) {
            protocolVersion2 = protocolVersion2.getPreviousVersion();
            vector.addElement(protocolVersion2);
        }
        ProtocolVersion[] protocolVersionArray = new ProtocolVersion[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            protocolVersionArray[i] = (ProtocolVersion)vector.elementAt(i);
        }
        return protocolVersionArray;
    }

    public int getFullVersion() {
        return this.version;
    }

    public int getMajorVersion() {
        return this.version >> 8;
    }

    public int getMinorVersion() {
        return this.version & 0xFF;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDTLS() {
        return this.getMajorVersion() == 254;
    }

    public boolean isTLS() {
        return this.getMajorVersion() == 3;
    }

    public ProtocolVersion getEquivalentTLSVersion() {
        switch (this.getMajorVersion()) {
            case 3: {
                return this;
            }
            case 254: {
                switch (this.getMinorVersion()) {
                    case 255: {
                        return TLSv11;
                    }
                    case 253: {
                        return TLSv12;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public ProtocolVersion getNextVersion() {
        int n = this.getMajorVersion();
        int n2 = this.getMinorVersion();
        switch (n) {
            case 3: {
                switch (n2) {
                    case 255: {
                        return null;
                    }
                }
                return ProtocolVersion.get(n, n2 + 1);
            }
            case 254: {
                switch (n2) {
                    case 0: {
                        return null;
                    }
                    case 255: {
                        return DTLSv12;
                    }
                }
                return ProtocolVersion.get(n, n2 - 1);
            }
        }
        return null;
    }

    public ProtocolVersion getPreviousVersion() {
        int n = this.getMajorVersion();
        int n2 = this.getMinorVersion();
        switch (n) {
            case 3: {
                switch (n2) {
                    case 0: {
                        return null;
                    }
                }
                return ProtocolVersion.get(n, n2 - 1);
            }
            case 254: {
                switch (n2) {
                    case 255: {
                        return null;
                    }
                    case 253: {
                        return DTLSv10;
                    }
                }
                return ProtocolVersion.get(n, n2 + 1);
            }
        }
        return null;
    }

    public boolean isEarlierVersionOf(ProtocolVersion protocolVersion) {
        if (null == protocolVersion || this.getMajorVersion() != protocolVersion.getMajorVersion()) {
            return false;
        }
        int n = this.getMinorVersion() - protocolVersion.getMinorVersion();
        return this.isDTLS() ? n > 0 : n < 0;
    }

    public boolean isEqualOrEarlierVersionOf(ProtocolVersion protocolVersion) {
        if (null == protocolVersion || this.getMajorVersion() != protocolVersion.getMajorVersion()) {
            return false;
        }
        int n = this.getMinorVersion() - protocolVersion.getMinorVersion();
        return this.isDTLS() ? n >= 0 : n <= 0;
    }

    public boolean isEqualOrLaterVersionOf(ProtocolVersion protocolVersion) {
        if (null == protocolVersion || this.getMajorVersion() != protocolVersion.getMajorVersion()) {
            return false;
        }
        int n = this.getMinorVersion() - protocolVersion.getMinorVersion();
        return this.isDTLS() ? n <= 0 : n >= 0;
    }

    public boolean isLaterVersionOf(ProtocolVersion protocolVersion) {
        if (null == protocolVersion || this.getMajorVersion() != protocolVersion.getMajorVersion()) {
            return false;
        }
        int n = this.getMinorVersion() - protocolVersion.getMinorVersion();
        return this.isDTLS() ? n < 0 : n > 0;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ProtocolVersion && this.equals((ProtocolVersion)object);
    }

    public boolean equals(ProtocolVersion protocolVersion) {
        return protocolVersion != null && this.version == protocolVersion.version;
    }

    public int hashCode() {
        return this.version;
    }

    public static ProtocolVersion get(int n, int n2) {
        switch (n) {
            case 3: {
                switch (n2) {
                    case 0: {
                        return SSLv3;
                    }
                    case 1: {
                        return TLSv10;
                    }
                    case 2: {
                        return TLSv11;
                    }
                    case 3: {
                        return TLSv12;
                    }
                    case 4: {
                        return TLSv13;
                    }
                }
                return ProtocolVersion.getUnknownVersion(n, n2, "TLS");
            }
            case 254: {
                switch (n2) {
                    case 255: {
                        return DTLSv10;
                    }
                    case 254: {
                        throw new IllegalArgumentException("{0xFE, 0xFE} is a reserved protocol version");
                    }
                    case 253: {
                        return DTLSv12;
                    }
                }
                return ProtocolVersion.getUnknownVersion(n, n2, "DTLS");
            }
        }
        return ProtocolVersion.getUnknownVersion(n, n2, "UNKNOWN");
    }

    public ProtocolVersion[] only() {
        return new ProtocolVersion[]{this};
    }

    public String toString() {
        return this.name;
    }

    private static void checkUint8(int n) {
        if (!TlsUtils.isValidUint8(n)) {
            throw new IllegalArgumentException("'versionOctet' is not a valid octet");
        }
    }

    private static ProtocolVersion getUnknownVersion(int n, int n2, String string) {
        ProtocolVersion.checkUint8(n);
        ProtocolVersion.checkUint8(n2);
        int n3 = n << 8 | n2;
        String string2 = Strings.toUpperCase((String)Integer.toHexString(0x10000 | n3).substring(1));
        return new ProtocolVersion(n3, string + " 0x" + string2);
    }
}

