/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCApplicationProtocolSelector;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.RecordPreview;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServerProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLEngine
extends SSLEngine
implements BCSSLEngine,
ProvTlsManager {
    private static final Logger LOG = Logger.getLogger(ProvSSLEngine.class.getName());
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = false;
    protected boolean closedEarly = false;
    protected boolean initialHandshakeBegun = false;
    protected SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected ProvSSLConnection connection = null;
    protected ProvSSLSessionHandshake handshakeSession = null;
    protected SSLException deferredException = null;

    protected ProvSSLEngine(ProvSSLContextSpi provSSLContextSpi, ContextData contextData) {
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = provSSLContextSpi.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLEngine(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, String string, int n) {
        super(string, n);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = provSSLContextSpi.getDefaultParameters(!this.useClientMode);
    }

    @Override
    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (this.closedEarly) {
            throw new SSLException("Connection is already closed");
        }
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol tlsClientProtocol = new TlsClientProtocol();
                this.protocol = tlsClientProtocol;
                ProvTlsClient provTlsClient = new ProvTlsClient(this, this.sslParameters);
                this.protocolPeer = provTlsClient;
                tlsClientProtocol.connect(provTlsClient);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else {
                TlsServerProtocol tlsServerProtocol = new TlsServerProtocol();
                this.protocol = tlsServerProtocol;
                ProvTlsServer provTlsServer = new ProvTlsServer(this, this.sslParameters);
                this.protocolPeer = provTlsServer;
                tlsServerProtocol.accept(provTlsServer);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (IOException iOException) {
            throw new SSLException(iOException);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkClientTrusted((X509Certificate[])x509CertificateArray.clone(), string, this);
        }
        catch (CertificateException certificateException) {
            throw new TlsFatalAlert(46, (Throwable)certificateException);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkServerTrusted((X509Certificate[])x509CertificateArray.clone(), string, this);
        }
        catch (CertificateException certificateException) {
            throw new TlsFatalAlert(46, (Throwable)certificateException);
        }
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray) {
        return this.contextData.getX509KeyManager().chooseEngineClientAlias(stringArray, principalArray, this);
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray) {
        return this.contextData.getX509KeyManager().chooseEngineServerAlias(string, principalArray, this);
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (!this.closedEarly) {
            if (null == this.protocol) {
                this.closedEarly = true;
            } else {
                try {
                    this.protocol.closeInput();
                }
                catch (IOException iOException) {
                    throw new SSLException(iOException);
                }
            }
        }
    }

    @Override
    public synchronized void closeOutbound() {
        if (!this.closedEarly) {
            if (null == this.protocol) {
                this.closedEarly = true;
            } else {
                try {
                    this.protocol.close();
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "Failed to close outbound", iOException);
                }
            }
        }
    }

    @Override
    public synchronized String getApplicationProtocol() {
        return null == this.connection ? null : this.connection.getApplicationProtocol();
    }

    @Override
    public synchronized BCApplicationProtocolSelector<SSLEngine> getBCHandshakeApplicationProtocolSelector() {
        return this.sslParameters.getEngineAPSelector();
    }

    @Override
    public synchronized BCExtendedSSLSession getBCHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized String getHandshakeApplicationProtocol() {
        return null == this.handshakeSession ? null : this.handshakeSession.getApplicationProtocol();
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return null == this.handshakeSession ? null : this.handshakeSession.getExportSSLSession();
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.handshakeStatus;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    @Override
    public synchronized SSLSession getSession() {
        ProvSSLSession provSSLSession = null == this.connection ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
        return provSSLSession.getExportSSLSession();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.closedEarly || null != this.protocol && this.protocol.isClosed();
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.closedEarly || null != this.protocol && this.protocol.isClosed() && this.protocol.getAvailableOutputBytes() < 1;
    }

    @Override
    public synchronized void setBCHandshakeApplicationProtocolSelector(BCApplicationProtocolSelector<SSLEngine> bCApplicationProtocolSelector) {
        this.sslParameters.setEngineAPSelector(bCApplicationProtocolSelector);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.sslParameters.setCipherSuites(stringArray);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.sslParameters.setProtocols(stringArray);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    @Override
    public synchronized void setParameters(BCSSLParameters bCSSLParameters) {
        SSLParametersUtil.setParameters(this.sslParameters, bCSSLParameters);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sSLParameters);
    }

    @Override
    public synchronized void setUseClientMode(boolean bl) {
        if (this.initialHandshakeBegun) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        if (this.useClientMode != bl) {
            this.context.updateDefaultProtocols(this.sslParameters, !bl);
            this.useClientMode = bl;
        }
    }

    @Override
    public synchronized void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) throws SSLException {
        Object object;
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.Status status = SSLEngineResult.Status.OK;
        int n3 = 0;
        int n4 = 0;
        if (this.protocol.isClosed()) {
            status = SSLEngineResult.Status.CLOSED;
        } else {
            try {
                object = this.getRecordPreview(byteBuffer);
                if (object == null || byteBuffer.remaining() < object.getRecordSize()) {
                    status = SSLEngineResult.Status.BUFFER_UNDERFLOW;
                } else if (this.hasInsufficientSpace(byteBufferArray, n, n2, object.getApplicationDataLimit())) {
                    status = SSLEngineResult.Status.BUFFER_OVERFLOW;
                } else {
                    byte[] byArray = new byte[object.getRecordSize()];
                    byteBuffer.get(byArray);
                    this.protocol.offerInput(byArray);
                    n3 += byArray.length;
                    int n5 = this.protocol.getAvailableInputBytes();
                    for (int i = 0; i < n2 && n5 > 0; ++i) {
                        ByteBuffer byteBuffer2 = byteBufferArray[n + i];
                        int n6 = Math.min(byteBuffer2.remaining(), n5);
                        if (n6 <= 0) continue;
                        byte[] byArray2 = new byte[n6];
                        int n7 = this.protocol.readInput(byArray2, 0, n6);
                        assert (n7 == n6);
                        byteBuffer2.put(byArray2);
                        n4 += n6;
                        n5 -= n6;
                    }
                    if (n5 != 0) {
                        throw new TlsFatalAlert(22);
                    }
                }
            }
            catch (IOException iOException) {
                if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    throw new SSLException(iOException);
                }
                if (this.deferredException == null) {
                    this.deferredException = new SSLException(iOException);
                }
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, n3, n4);
            }
        }
        object = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            if (this.protocol.getAvailableOutputBytes() > 0) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                object = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                object = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                object = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
        }
        return new SSLEngineResult(status, (SSLEngineResult.HandshakeStatus)((Object)object), n3, n4);
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) throws SSLException {
        int n3;
        Object object;
        int n4;
        if (this.deferredException != null) {
            SSLException sSLException = this.deferredException;
            this.deferredException = null;
            throw sSLException;
        }
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.Status status = SSLEngineResult.Status.OK;
        int n5 = 0;
        int n6 = 0;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.protocol.isClosed()) {
                status = SSLEngineResult.Status.CLOSED;
            } else if (this.protocol.getAvailableOutputBytes() <= 0) {
                try {
                    n4 = this.getTotalRemaining(byteBufferArray, n, n2, this.protocol.getApplicationDataLimit());
                    if (n4 > 0) {
                        object = this.protocol.previewOutputRecord(n4);
                        int n7 = ((RecordPreview)object).getApplicationDataLimit();
                        n3 = ((RecordPreview)object).getRecordSize();
                        if (byteBuffer.remaining() < n3) {
                            status = SSLEngineResult.Status.BUFFER_OVERFLOW;
                        } else {
                            for (int i = 0; i < n2 && n7 > 0; ++i) {
                                ByteBuffer byteBuffer2 = byteBufferArray[n + i];
                                int n8 = Math.min(byteBuffer2.remaining(), n7);
                                if (n8 <= 0) continue;
                                byte[] byArray = new byte[n8];
                                byteBuffer2.get(byArray);
                                this.protocol.writeApplicationData(byArray, 0, n8);
                                n5 += n8;
                                n7 -= n8;
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new SSLException(iOException);
                }
            }
        }
        if ((n4 = this.protocol.getAvailableOutputBytes()) > 0) {
            int n9 = Math.min(byteBuffer.remaining(), n4);
            if (n9 > 0) {
                byte[] byArray = new byte[n9];
                n3 = this.protocol.readOutput(byArray, 0, n9);
                assert (n3 == n9);
                byteBuffer.put(byArray);
                n6 += n9;
                n4 -= n9;
            } else {
                status = SSLEngineResult.Status.BUFFER_OVERFLOW;
            }
        }
        object = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && n4 <= 0) {
            if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                object = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                object = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            } else {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                object = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        return new SSLEngineResult(status, (SSLEngineResult.HandshakeStatus)((Object)object), n5, n6);
    }

    @Override
    public String getPeerHost() {
        return super.getPeerHost();
    }

    @Override
    public String getPeerHostSNI() {
        return super.getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return super.getPeerPort();
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection provSSLConnection) {
        if (null != this.handshakeSession && !this.handshakeSession.isValid()) {
            provSSLConnection.getSession().invalidate();
        }
        this.handshakeSession = null;
        this.connection = provSSLConnection;
    }

    @Override
    public synchronized void notifyHandshakeSession(ProvSSLSessionHandshake provSSLSessionHandshake) {
        this.handshakeSession = provSSLSessionHandshake;
    }

    @Override
    public synchronized String selectApplicationProtocol(List<String> list) {
        return this.sslParameters.getEngineAPSelector().select(this, list);
    }

    private RecordPreview getRecordPreview(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.remaining() < 5) {
            return null;
        }
        byte[] byArray = new byte[5];
        int n = byteBuffer.position();
        byteBuffer.get(byArray);
        byteBuffer.position(n);
        return this.protocol.previewInputRecord(byArray);
    }

    private int getTotalRemaining(ByteBuffer[] byteBufferArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            ByteBuffer byteBuffer = byteBufferArray[n + i];
            int n5 = byteBuffer.remaining();
            if (n5 >= n3 - n4) {
                return n3;
            }
            n4 += n5;
        }
        return n4;
    }

    private boolean hasInsufficientSpace(ByteBuffer[] byteBufferArray, int n, int n2, int n3) {
        return this.getTotalRemaining(byteBufferArray, n, n2, n3) < n3;
    }
}

