/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCloseable;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHeartbeat;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.crypto.TlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractTlsPeer
implements TlsPeer {
    private final TlsCrypto crypto;
    private volatile TlsCloseable closeHandle;

    protected AbstractTlsPeer(TlsCrypto tlsCrypto) {
        this.crypto = tlsCrypto;
    }

    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.downTo(ProtocolVersion.TLSv10);
    }

    protected abstract int[] getSupportedCipherSuites();

    public void cancel() throws IOException {
        TlsCloseable tlsCloseable = this.closeHandle;
        if (null != tlsCloseable) {
            tlsCloseable.close();
        }
    }

    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    public void notifyCloseHandle(TlsCloseable tlsCloseable) {
        this.closeHandle = tlsCloseable;
    }

    public void notifyHandshakeBeginning() throws IOException {
    }

    public int getHandshakeTimeoutMillis() {
        return 0;
    }

    public boolean requiresExtendedMasterSecret() {
        return false;
    }

    public boolean shouldCheckSigAlgOfPeerCerts() {
        return true;
    }

    public boolean shouldUseExtendedPadding() {
        return false;
    }

    public boolean shouldUseGMTUnixTime() {
        return false;
    }

    public void notifySecureRenegotiation(boolean bl) throws IOException {
        if (!bl) {
            throw new TlsFatalAlert(40);
        }
    }

    public TlsKeyExchangeFactory getKeyExchangeFactory() throws IOException {
        return new DefaultTlsKeyExchangeFactory();
    }

    public void notifyAlertRaised(short s, short s2, String string, Throwable throwable) {
    }

    public void notifyAlertReceived(short s, short s2) {
    }

    public void notifyHandshakeComplete() throws IOException {
    }

    public TlsHeartbeat getHeartbeat() {
        return null;
    }

    public short getHeartbeatPolicy() {
        return 2;
    }

    public int getRenegotiationPolicy() {
        return 0;
    }
}

