/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.DHStandardGroups;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class TlsDHUtils {
    public static TlsDHConfig createNamedDHConfig(TlsContext tlsContext, int n) {
        if (n < 0 || NamedGroup.getFiniteFieldBits(n) < 1) {
            return null;
        }
        boolean bl = TlsUtils.isTLSv13(tlsContext);
        return new TlsDHConfig(n, bl);
    }

    public static DHGroup getDHGroup(TlsDHConfig tlsDHConfig) {
        int n = tlsDHConfig.getNamedGroup();
        if (n >= 0) {
            return TlsDHUtils.getNamedDHGroup(n);
        }
        return tlsDHConfig.getExplicitGroup();
    }

    public static DHGroup getNamedDHGroup(int n) {
        switch (n) {
            case 256: {
                return DHStandardGroups.rfc7919_ffdhe2048;
            }
            case 257: {
                return DHStandardGroups.rfc7919_ffdhe3072;
            }
            case 258: {
                return DHStandardGroups.rfc7919_ffdhe4096;
            }
            case 259: {
                return DHStandardGroups.rfc7919_ffdhe6144;
            }
            case 260: {
                return DHStandardGroups.rfc7919_ffdhe8192;
            }
        }
        return null;
    }

    public static int getMinimumFiniteFieldBits(int n) {
        return TlsDHUtils.isDHCipherSuite(n) ? 1 : 0;
    }

    public static boolean isDHCipherSuite(int n) {
        switch (TlsUtils.getKeyExchangeAlgorithm(n)) {
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static int getNamedGroupForDHParameters(BigInteger bigInteger, BigInteger bigInteger2) {
        int[] nArray = new int[]{256, 257, 258, 259, 260};
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            DHGroup dHGroup = TlsDHUtils.getNamedDHGroup(n);
            if (dHGroup == null || !dHGroup.getP().equals(bigInteger) || !dHGroup.getG().equals(bigInteger2)) continue;
            return n;
        }
        return -1;
    }

    public static TlsDHConfig receiveDHConfig(TlsContext tlsContext, TlsDHGroupVerifier tlsDHGroupVerifier, InputStream inputStream) throws IOException {
        BigInteger bigInteger;
        BigInteger bigInteger2 = TlsDHUtils.readDHParameter(inputStream);
        int n = TlsDHUtils.getNamedGroupForDHParameters(bigInteger2, bigInteger = TlsDHUtils.readDHParameter(inputStream));
        if (n < 0) {
            DHGroup dHGroup = new DHGroup(bigInteger2, null, bigInteger, 0);
            if (!tlsDHGroupVerifier.accept(dHGroup)) {
                throw new TlsFatalAlert(71);
            }
            return new TlsDHConfig(dHGroup);
        }
        int[] nArray = tlsContext.getSecurityParametersHandshake().getClientSupportedGroups();
        if (null == nArray || Arrays.contains((int[])nArray, (int)n)) {
            return new TlsDHConfig(n, false);
        }
        throw new TlsFatalAlert(47);
    }

    public static BigInteger readDHParameter(InputStream inputStream) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque16(inputStream, 1));
    }

    public static void writeDHConfig(TlsDHConfig tlsDHConfig, OutputStream outputStream) throws IOException {
        DHGroup dHGroup = TlsDHUtils.getDHGroup(tlsDHConfig);
        TlsDHUtils.writeDHParameter(dHGroup.getP(), outputStream);
        TlsDHUtils.writeDHParameter(dHGroup.getG(), outputStream);
    }

    public static void writeDHParameter(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        TlsUtils.writeOpaque16(BigIntegers.asUnsignedByteArray((BigInteger)bigInteger), outputStream);
    }
}

