/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.MACAlgorithm;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.SRP6Group;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsEncryptor;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsNullCipher;
import org.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaNonceGenerator;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsHash;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JceAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceBlockCipherWithCBCImplicitIVImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceChaCha20Poly1305;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsDHDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsECDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsHMAC;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JceX25519Domain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceX448Domain;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Client;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Server;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6VerifierGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

public class JcaTlsCrypto
extends AbstractTlsCrypto {
    private final JcaJceHelper helper;
    private final SecureRandom entropySource;
    private final SecureRandom nonceEntropySource;
    private final Hashtable supportedEncryptionAlgorithms = new Hashtable();
    private final Hashtable supportedNamedGroups = new Hashtable();
    private final Hashtable supportedOther = new Hashtable();

    protected JcaTlsCrypto(JcaJceHelper jcaJceHelper, SecureRandom secureRandom, SecureRandom secureRandom2) {
        this.helper = jcaJceHelper;
        this.entropySource = secureRandom;
        this.nonceEntropySource = secureRandom2;
    }

    JceTlsSecret adoptLocalSecret(byte[] byArray) {
        return new JceTlsSecret(this, byArray);
    }

    Cipher createRSAEncryptionCipher() throws GeneralSecurityException {
        try {
            return this.getHelper().createCipher("RSA/NONE/PKCS1Padding");
        }
        catch (GeneralSecurityException generalSecurityException) {
            return this.getHelper().createCipher("RSA/ECB/PKCS1Padding");
        }
    }

    public TlsNonceGenerator createNonceGenerator(byte[] byArray) {
        return new JcaNonceGenerator(this.nonceEntropySource, byArray);
    }

    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    public byte[] calculateKeyAgreement(String string, PrivateKey privateKey, PublicKey publicKey, String string2) throws GeneralSecurityException {
        KeyAgreement keyAgreement = this.helper.createKeyAgreement(string);
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, true);
        try {
            return keyAgreement.generateSecret(string2).getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if ("X25519".equals(string) || "X448".equals(string)) {
                return keyAgreement.generateSecret();
            }
            throw noSuchAlgorithmException;
        }
    }

    public TlsCertificate createCertificate(byte[] byArray) throws IOException {
        return new JcaTlsCertificate(this, byArray);
    }

    protected TlsCipher createCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        try {
            switch (n) {
                case 7: {
                    return this.createDESedeCipher(tlsCryptoParameters, n2);
                }
                case 8: {
                    return this.createAESCipher(tlsCryptoParameters, 16, n2);
                }
                case 15: {
                    return this.createCipher_AES_CCM(tlsCryptoParameters, 16, 16);
                }
                case 16: {
                    return this.createCipher_AES_CCM(tlsCryptoParameters, 16, 8);
                }
                case 10: {
                    return this.createCipher_AES_GCM(tlsCryptoParameters, 16, 16);
                }
                case 103: {
                    return this.createCipher_AES_OCB(tlsCryptoParameters, 16, 12);
                }
                case 9: {
                    return this.createAESCipher(tlsCryptoParameters, 32, n2);
                }
                case 17: {
                    return this.createCipher_AES_CCM(tlsCryptoParameters, 32, 16);
                }
                case 18: {
                    return this.createCipher_AES_CCM(tlsCryptoParameters, 32, 8);
                }
                case 11: {
                    return this.createCipher_AES_GCM(tlsCryptoParameters, 32, 16);
                }
                case 104: {
                    return this.createCipher_AES_OCB(tlsCryptoParameters, 32, 12);
                }
                case 22: {
                    return this.createARIACipher(tlsCryptoParameters, 16, n2);
                }
                case 24: {
                    return this.createCipher_ARIA_GCM(tlsCryptoParameters, 16, 16);
                }
                case 23: {
                    return this.createARIACipher(tlsCryptoParameters, 32, n2);
                }
                case 25: {
                    return this.createCipher_ARIA_GCM(tlsCryptoParameters, 32, 16);
                }
                case 12: {
                    return this.createCamelliaCipher(tlsCryptoParameters, 16, n2);
                }
                case 19: {
                    return this.createCipher_Camellia_GCM(tlsCryptoParameters, 16, 16);
                }
                case 13: {
                    return this.createCamelliaCipher(tlsCryptoParameters, 32, n2);
                }
                case 20: {
                    return this.createCipher_Camellia_GCM(tlsCryptoParameters, 32, 16);
                }
                case 21: {
                    return this.createChaCha20Poly1305(tlsCryptoParameters);
                }
                case 0: {
                    return this.createNullCipher(tlsCryptoParameters, n2);
                }
                case 14: {
                    return this.createSEEDCipher(tlsCryptoParameters, n2);
                }
            }
            throw new TlsFatalAlert(80);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("cannot create cipher: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public TlsHMAC createHMAC(short s) {
        String string = this.getDigestName(s).replaceAll("-", "");
        String string2 = "Hmac" + string;
        return this.createHMAC(string2);
    }

    public TlsHMAC createHMAC(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return this.createHMAC("HmacMD5");
            }
            case 2: {
                return this.createHMAC("HmacSHA1");
            }
            case 3: {
                return this.createHMAC("HmacSHA256");
            }
            case 4: {
                return this.createHMAC("HmacSHA384");
            }
            case 5: {
                return this.createHMAC("HmacSHA512");
            }
        }
        throw new IllegalArgumentException("unknown MACAlgorithm: " + MACAlgorithm.getText(n));
    }

    public TlsSRP6Client createSRP6Client(TlsSRPConfig tlsSRPConfig) {
        final SRP6Client sRP6Client = new SRP6Client();
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        SRP6Group sRP6Group = new SRP6Group(bigIntegerArray[0], bigIntegerArray[1]);
        sRP6Client.init(sRP6Group, this.createHash((short)2), this.getSecureRandom());
        return new TlsSRP6Client(){

            public BigInteger calculateSecret(BigInteger bigInteger) throws TlsFatalAlert {
                try {
                    return sRP6Client.calculateSecret(bigInteger);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new TlsFatalAlert(47, (Throwable)illegalArgumentException);
                }
            }

            public BigInteger generateClientCredentials(byte[] byArray, byte[] byArray2, byte[] byArray3) {
                return sRP6Client.generateClientCredentials(byArray, byArray2, byArray3);
            }
        };
    }

    public TlsSRP6Server createSRP6Server(TlsSRPConfig tlsSRPConfig, BigInteger bigInteger) {
        final SRP6Server sRP6Server = new SRP6Server();
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        SRP6Group sRP6Group = new SRP6Group(bigIntegerArray[0], bigIntegerArray[1]);
        sRP6Server.init(sRP6Group, bigInteger, this.createHash((short)2), this.getSecureRandom());
        return new TlsSRP6Server(){

            public BigInteger generateServerCredentials() {
                return sRP6Server.generateServerCredentials();
            }

            public BigInteger calculateSecret(BigInteger bigInteger) throws IOException {
                try {
                    return sRP6Server.calculateSecret(bigInteger);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new TlsFatalAlert(47, (Throwable)illegalArgumentException);
                }
            }
        };
    }

    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig tlsSRPConfig) {
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        final SRP6VerifierGenerator sRP6VerifierGenerator = new SRP6VerifierGenerator();
        sRP6VerifierGenerator.init(bigIntegerArray[0], bigIntegerArray[1], this.createHash((short)2));
        return new TlsSRP6VerifierGenerator(){

            public BigInteger generateVerifier(byte[] byArray, byte[] byArray2, byte[] byArray3) {
                return sRP6VerifierGenerator.generateVerifier(byArray, byArray2, byArray3);
            }
        };
    }

    public boolean hasAllRawSignatureAlgorithms() {
        return !JcaUtils.isSunMSCAPIProviderActive() && !this.hasSignatureAlgorithm((short)7) && !this.hasSignatureAlgorithm((short)8);
    }

    public boolean hasDHAgreement() {
        return true;
    }

    public boolean hasECDHAgreement() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEncryptionAlgorithm(int n) {
        Serializable serializable;
        Integer n2 = Integers.valueOf((int)n);
        Hashtable hashtable = this.supportedEncryptionAlgorithms;
        synchronized (hashtable) {
            serializable = (Boolean)this.supportedEncryptionAlgorithms.get(n2);
            if (serializable != null) {
                return serializable;
            }
        }
        boolean bl = true;
        try {
            switch (n) {
                case 21: {
                    this.helper.createCipher("ChaCha7539");
                    this.helper.createMac("Poly1305");
                    break;
                }
                case 7: {
                    this.helper.createCipher("DESede/CBC/NoPadding");
                    break;
                }
                case 8: 
                case 9: {
                    this.helper.createCipher("AES/CBC/NoPadding");
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    this.helper.createCipher("AES/CCM/NoPadding");
                    break;
                }
                case 10: 
                case 11: {
                    this.helper.createCipher("AES/GCM/NoPadding");
                    break;
                }
                case 103: 
                case 104: {
                    this.helper.createCipher("AES/OCB/NoPadding");
                    break;
                }
                case 22: 
                case 23: {
                    this.helper.createCipher("ARIA/CBC/NoPadding");
                    break;
                }
                case 24: 
                case 25: {
                    this.helper.createCipher("ARIA/GCM/NoPadding");
                    break;
                }
                case 12: 
                case 13: {
                    this.helper.createCipher("Camellia/CBC/NoPadding");
                    break;
                }
                case 19: 
                case 20: {
                    this.helper.createCipher("Camellia/GCM/NoPadding");
                    break;
                }
                case 14: {
                    this.helper.createCipher("SEED/CBC/NoPadding");
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            bl = false;
        }
        serializable = this.supportedEncryptionAlgorithms;
        synchronized (serializable) {
            this.supportedEncryptionAlgorithms.put(n2, bl);
        }
        return bl;
    }

    public boolean hasHashAlgorithm(short s) {
        return true;
    }

    public boolean hasMacAlgorithm(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNamedGroup(int n) {
        Serializable serializable;
        if (NamedGroup.refersToASpecificFiniteField(n)) {
            return true;
        }
        if (!NamedGroup.refersToASpecificCurve(n)) {
            return false;
        }
        String string = NamedGroup.getName(n);
        if (string == null) {
            return false;
        }
        Integer n2 = Integers.valueOf((int)n);
        Hashtable hashtable = this.supportedNamedGroups;
        synchronized (hashtable) {
            serializable = (Boolean)this.supportedNamedGroups.get(n2);
            if (serializable != null) {
                return serializable;
            }
        }
        boolean bl = true;
        try {
            switch (n) {
                case 29: {
                    this.helper.createKeyAgreement("X25519");
                    this.helper.createKeyFactory("X25519");
                    this.helper.createKeyPairGenerator("X25519");
                    break;
                }
                case 30: {
                    this.helper.createKeyAgreement("X448");
                    this.helper.createKeyFactory("X448");
                    this.helper.createKeyPairGenerator("X448");
                    break;
                }
                default: {
                    bl &= this.isCurveSupported(string);
                    break;
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            bl = false;
        }
        serializable = this.supportedNamedGroups;
        synchronized (serializable) {
            this.supportedNamedGroups.put(n2, bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRSAEncryption() {
        Serializable serializable;
        Hashtable hashtable = this.supportedOther;
        synchronized (hashtable) {
            serializable = (Boolean)this.supportedOther.get("KE_RSA");
            if (serializable != null) {
                return serializable;
            }
        }
        boolean bl = true;
        try {
            this.createRSAEncryptionCipher();
        }
        catch (GeneralSecurityException generalSecurityException) {
            bl = false;
        }
        serializable = this.supportedOther;
        synchronized (serializable) {
            this.supportedOther.put("KE_RSA", bl);
        }
        return bl;
    }

    public boolean hasSignatureAlgorithm(short s) {
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (signatureAndHashAlgorithm.getHash() == 3 && JcaUtils.isSunMSCAPIProviderActive()) {
            return false;
        }
        return this.hasSignatureAlgorithm(signatureAndHashAlgorithm.getSignature());
    }

    public boolean hasSRPAuthentication() {
        return true;
    }

    public TlsSecret createSecret(byte[] byArray) {
        return this.adoptLocalSecret(Arrays.clone((byte[])byArray));
    }

    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion protocolVersion) {
        byte[] byArray = new byte[48];
        this.getSecureRandom().nextBytes(byArray);
        TlsUtils.writeVersion(protocolVersion, byArray, 0);
        return this.adoptLocalSecret(byArray);
    }

    public TlsHash createHash(short s) {
        try {
            return this.createHash(this.getDigestName(s));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalArgumentException("unable to create message digest:" + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public TlsDHDomain createDHDomain(TlsDHConfig tlsDHConfig) {
        return new JceTlsDHDomain(this, tlsDHConfig);
    }

    public TlsECDomain createECDomain(TlsECConfig tlsECConfig) {
        switch (tlsECConfig.getNamedGroup()) {
            case 29: {
                return new JceX25519Domain(this);
            }
            case 30: {
                return new JceX448Domain(this);
            }
        }
        return new JceTlsECDomain(this, tlsECConfig);
    }

    public TlsEncryptor createEncryptor(TlsCertificate tlsCertificate) throws IOException {
        JcaTlsCertificate jcaTlsCertificate = JcaTlsCertificate.convert(this, tlsCertificate);
        jcaTlsCertificate.validateKeyUsage(32);
        final RSAPublicKey rSAPublicKey = jcaTlsCertificate.getPubKeyRSA();
        return new TlsEncryptor(){

            public byte[] encrypt(byte[] byArray, int n, int n2) throws IOException {
                try {
                    Cipher cipher = JcaTlsCrypto.this.createRSAEncryptionCipher();
                    try {
                        cipher.init(3, (Key)rSAPublicKey, JcaTlsCrypto.this.getSecureRandom());
                        return cipher.wrap(new SecretKeySpec(byArray, n, n2, "TLS"));
                    }
                    catch (Exception exception) {
                        try {
                            cipher.init(1, (Key)rSAPublicKey, JcaTlsCrypto.this.getSecureRandom());
                            return cipher.doFinal(byArray, n, n2);
                        }
                        catch (Exception exception2) {
                            throw new TlsFatalAlert(80, (Throwable)exception);
                        }
                    }
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
                }
            }
        };
    }

    public TlsSecret hkdfInit(short s) {
        return this.adoptLocalSecret(new byte[HashAlgorithm.getOutputSize(s)]);
    }

    protected TlsAEADCipherImpl createAEADCipher(String string, String string2, int n, boolean bl) throws GeneralSecurityException {
        return new JceAEADCipherImpl(this.helper, string, string2, n, bl);
    }

    protected TlsBlockCipherImpl createBlockCipher(String string, String string2, int n, boolean bl) throws GeneralSecurityException {
        return new JceBlockCipherImpl(this.helper.createCipher(string), string2, n, bl);
    }

    protected TlsBlockCipherImpl createBlockCipherWithCBCImplicitIV(String string, String string2, int n, boolean bl) throws GeneralSecurityException {
        return new JceBlockCipherWithCBCImplicitIVImpl(this.helper.createCipher(string), string2, bl);
    }

    protected TlsHMAC createHMAC(String string) {
        try {
            return new JceTlsHMAC(this.helper.createMac(string), string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("cannot create HMAC: " + string, generalSecurityException);
        }
    }

    protected TlsHash createHash(String string) throws GeneralSecurityException {
        return new JcaTlsHash(this.helper.createDigest(string));
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException, GeneralSecurityException {
        return new TlsNullCipher(tlsCryptoParameters, this.createMAC(n), this.createMAC(n));
    }

    protected boolean isCurveSupported(String string) {
        return ECUtil.isCurveSupported(string, this.getHelper());
    }

    public JcaJceHelper getHelper() {
        return this.helper;
    }

    private TlsBlockCipher createAESCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, tlsCryptoParameters, this.createCBCBlockOperator(tlsCryptoParameters, "AES", true, n), this.createCBCBlockOperator(tlsCryptoParameters, "AES", false, n), this.createMAC(n2), this.createMAC(n2), n);
    }

    private TlsBlockCipher createARIACipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, tlsCryptoParameters, this.createCBCBlockOperator(tlsCryptoParameters, "ARIA", true, n), this.createCBCBlockOperator(tlsCryptoParameters, "ARIA", false, n), this.createMAC(n2), this.createMAC(n2), n);
    }

    private TlsBlockCipher createCamelliaCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, tlsCryptoParameters, this.createCBCBlockOperator(tlsCryptoParameters, "Camellia", true, n), this.createCBCBlockOperator(tlsCryptoParameters, "Camellia", false, n), this.createMAC(n2), this.createMAC(n2), n);
    }

    private TlsBlockCipher createDESedeCipher(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, tlsCryptoParameters, this.createCBCBlockOperator(tlsCryptoParameters, "DESede", true, 24), this.createCBCBlockOperator(tlsCryptoParameters, "DESede", false, 24), this.createMAC(n), this.createMAC(n), 24);
    }

    private TlsBlockCipher createSEEDCipher(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, tlsCryptoParameters, this.createCBCBlockOperator(tlsCryptoParameters, "SEED", true, 16), this.createCBCBlockOperator(tlsCryptoParameters, "SEED", false, 16), this.createMAC(n), this.createMAC(n), 16);
    }

    private TlsBlockCipherImpl createCBCBlockOperator(TlsCryptoParameters tlsCryptoParameters, String string, boolean bl, int n) throws GeneralSecurityException {
        String string2 = string + "/CBC/NoPadding";
        if (TlsImplUtils.isTLSv11(tlsCryptoParameters)) {
            return this.createBlockCipher(string2, string, n, bl);
        }
        return this.createBlockCipherWithCBCImplicitIV(string2, string, n, bl);
    }

    private TlsHMAC createMAC(int n) throws IOException {
        return this.createHMAC(n);
    }

    private TlsCipher createChaCha20Poly1305(TlsCryptoParameters tlsCryptoParameters) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, new JceChaCha20Poly1305(this.helper, true), new JceChaCha20Poly1305(this.helper, false), 32, 16, 2);
    }

    private TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("AES/CCM/NoPadding", "AES", n, true), this.createAEADCipher("AES/CCM/NoPadding", "AES", n, false), n, n2);
    }

    private TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("AES/GCM/NoPadding", "AES", n, true), this.createAEADCipher("AES/GCM/NoPadding", "AES", n, false), n, n2);
    }

    private TlsAEADCipher createCipher_AES_OCB(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("AES/OCB/NoPadding", "AES", n, true), this.createAEADCipher("AES/OCB/NoPadding", "AES", n, false), n, n2, 2);
    }

    private TlsAEADCipher createCipher_ARIA_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("ARIA/GCM/NoPadding", "ARIA", n, true), this.createAEADCipher("ARIA/GCM/NoPadding", "ARIA", n, false), n, n2);
    }

    private TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", n, true), this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", n, false), n, n2);
    }

    String getDigestName(short s) {
        String string;
        switch (s) {
            case 1: {
                string = "MD5";
                break;
            }
            case 2: {
                string = "SHA-1";
                break;
            }
            case 3: {
                string = "SHA-224";
                break;
            }
            case 4: {
                string = "SHA-256";
                break;
            }
            case 5: {
                string = "SHA-384";
                break;
            }
            case 6: {
                string = "SHA-512";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid HashAlgorithm: " + HashAlgorithm.getText(s));
            }
        }
        return string;
    }
}

