/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.agreement.srp.SRP6Client;
import org.bouncycastle.crypto.agreement.srp.SRP6Server;
import org.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.ARIAEngine;
import org.bouncycastle.crypto.engines.CamelliaEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.SEEDEngine;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.SRP6GroupParameters;
import org.bouncycastle.crypto.prng.DigestRandomGenerator;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import org.bouncycastle.tls.crypto.impl.TlsEncryptor;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsNullCipher;
import org.bouncycastle.tls.crypto.impl.bc.BcChaCha20Poly1305;
import org.bouncycastle.tls.crypto.impl.bc.BcSSL3HMAC;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsHMAC;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsHash;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsNonceGenerator;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAEncryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSRP6Client;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSRP6Server;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSRP6VerifierGenerator;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcX25519Domain;
import org.bouncycastle.tls.crypto.impl.bc.BcX448Domain;
import org.bouncycastle.util.Arrays;

public class BcTlsCrypto
extends AbstractTlsCrypto {
    private final SecureRandom entropySource;

    public BcTlsCrypto(SecureRandom secureRandom) {
        this.entropySource = secureRandom;
    }

    BcTlsSecret adoptLocalSecret(byte[] byArray) {
        return new BcTlsSecret(this, byArray);
    }

    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    public TlsCertificate createCertificate(byte[] byArray) throws IOException {
        return new BcTlsCertificate(this, byArray);
    }

    public TlsCipher createCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        switch (n) {
            case 8: 
            case 12: 
            case 14: 
            case 22: 
            case 28: {
                return this.createCipher_CBC(tlsCryptoParameters, n, 16, n2);
            }
            case 7: {
                return this.createCipher_CBC(tlsCryptoParameters, n, 24, n2);
            }
            case 9: 
            case 13: 
            case 23: {
                return this.createCipher_CBC(tlsCryptoParameters, n, 32, n2);
            }
            case 15: {
                return this.createCipher_AES_CCM(tlsCryptoParameters, 16, 16);
            }
            case 16: {
                return this.createCipher_AES_CCM(tlsCryptoParameters, 16, 8);
            }
            case 10: {
                return this.createCipher_AES_GCM(tlsCryptoParameters, 16, 16);
            }
            case 17: {
                return this.createCipher_AES_CCM(tlsCryptoParameters, 32, 16);
            }
            case 18: {
                return this.createCipher_AES_CCM(tlsCryptoParameters, 32, 8);
            }
            case 11: {
                return this.createCipher_AES_GCM(tlsCryptoParameters, 32, 16);
            }
            case 24: {
                return this.createCipher_ARIA_GCM(tlsCryptoParameters, 16, 16);
            }
            case 25: {
                return this.createCipher_ARIA_GCM(tlsCryptoParameters, 32, 16);
            }
            case 19: {
                return this.createCipher_Camellia_GCM(tlsCryptoParameters, 16, 16);
            }
            case 20: {
                return this.createCipher_Camellia_GCM(tlsCryptoParameters, 32, 16);
            }
            case 21: {
                return this.createChaCha20Poly1305(tlsCryptoParameters);
            }
            case 0: {
                return this.createNullCipher(tlsCryptoParameters, n2);
            }
            case 26: {
                return this.createCipher_SM4_CCM(tlsCryptoParameters);
            }
            case 27: {
                return this.createCipher_SM4_GCM(tlsCryptoParameters);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsDHDomain createDHDomain(TlsDHConfig tlsDHConfig) {
        return new BcTlsDHDomain(this, tlsDHConfig);
    }

    public TlsECDomain createECDomain(TlsECConfig tlsECConfig) {
        switch (tlsECConfig.getNamedGroup()) {
            case 29: {
                return new BcX25519Domain(this);
            }
            case 30: {
                return new BcX448Domain(this);
            }
        }
        return new BcTlsECDomain(this, tlsECConfig);
    }

    public TlsEncryptor createEncryptor(TlsCertificate tlsCertificate) throws IOException {
        BcTlsCertificate bcTlsCertificate = BcTlsCertificate.convert(this, tlsCertificate);
        bcTlsCertificate.validateKeyUsage(32);
        RSAKeyParameters rSAKeyParameters = bcTlsCertificate.getPubKeyRSA();
        return new BcTlsRSAEncryptor(this, rSAKeyParameters);
    }

    public TlsNonceGenerator createNonceGenerator(byte[] byArray) {
        Digest digest = this.createDigest(4);
        byte[] byArray2 = new byte[digest.getDigestSize()];
        this.getSecureRandom().nextBytes(byArray2);
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(digest);
        digestRandomGenerator.addSeedMaterial(byArray);
        digestRandomGenerator.addSeedMaterial(byArray2);
        return new BcTlsNonceGenerator((RandomGenerator)digestRandomGenerator);
    }

    public boolean hasAllRawSignatureAlgorithms() {
        return !this.hasSignatureAlgorithm((short)7) && !this.hasSignatureAlgorithm((short)8);
    }

    public boolean hasDHAgreement() {
        return true;
    }

    public boolean hasECDHAgreement() {
        return true;
    }

    public boolean hasEncryptionAlgorithm(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return true;
    }

    public boolean hasCryptoHashAlgorithm(int n) {
        return true;
    }

    public boolean hasCryptoSignatureAlgorithm(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean hasMacAlgorithm(int n) {
        return true;
    }

    public boolean hasNamedGroup(int n) {
        return NamedGroup.refersToASpecificGroup(n);
    }

    public boolean hasRSAEncryption() {
        return true;
    }

    public boolean hasSignatureAlgorithm(short s) {
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        return this.hasSignatureAlgorithm(signatureAndHashAlgorithm.getSignature());
    }

    public boolean hasSignatureScheme(int n) {
        switch (n) {
            case 1800: {
                return false;
            }
        }
        return this.hasSignatureAlgorithm(SignatureScheme.getSignatureAlgorithm(n));
    }

    public boolean hasSRPAuthentication() {
        return true;
    }

    public TlsSecret createSecret(byte[] byArray) {
        return this.adoptLocalSecret(Arrays.clone((byte[])byArray));
    }

    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion protocolVersion) {
        byte[] byArray = new byte[48];
        this.getSecureRandom().nextBytes(byArray);
        TlsUtils.writeVersion(protocolVersion, byArray, 0);
        return this.adoptLocalSecret(byArray);
    }

    public Digest cloneDigest(int n, Digest digest) {
        switch (n) {
            case 1: {
                return new MD5Digest((MD5Digest)digest);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)digest);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)digest);
            }
            case 4: {
                return new SHA256Digest((SHA256Digest)digest);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)digest);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)digest);
            }
            case 7: {
                return new SM3Digest((SM3Digest)digest);
            }
        }
        throw new IllegalArgumentException("invalid CryptoHashAlgorithm: " + n);
    }

    public Digest createDigest(int n) {
        switch (n) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
            case 7: {
                return new SM3Digest();
            }
        }
        throw new IllegalArgumentException("invalid CryptoHashAlgorithm: " + n);
    }

    public TlsHash createHash(int n) {
        return new BcTlsHash(this, n);
    }

    protected BlockCipher createBlockCipher(int n) throws IOException {
        switch (n) {
            case 7: {
                return this.createDESedeEngine();
            }
            case 8: 
            case 9: {
                return this.createAESEngine();
            }
            case 22: 
            case 23: {
                return this.createARIAEngine();
            }
            case 12: 
            case 13: {
                return this.createCamelliaEngine();
            }
            case 14: {
                return this.createSEEDEngine();
            }
            case 28: {
                return this.createSM4Engine();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected BlockCipher createCBCBlockCipher(BlockCipher blockCipher) {
        return new CBCBlockCipher(blockCipher);
    }

    protected BlockCipher createCBCBlockCipher(int n) throws IOException {
        return this.createCBCBlockCipher(this.createBlockCipher(n));
    }

    protected TlsCipher createChaCha20Poly1305(TlsCryptoParameters tlsCryptoParameters) throws IOException {
        return new TlsAEADCipher(tlsCryptoParameters, new BcChaCha20Poly1305(true), new BcChaCha20Poly1305(false), 32, 16, 2);
    }

    protected TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        BcTlsAEADCipherImpl bcTlsAEADCipherImpl = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_AES_CCM(), true);
        BcTlsAEADCipherImpl bcTlsAEADCipherImpl2 = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_AES_CCM(), false);
        return new TlsAEADCipher(tlsCryptoParameters, bcTlsAEADCipherImpl, bcTlsAEADCipherImpl2, n, n2, 1);
    }

    protected TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        BcTlsAEADCipherImpl bcTlsAEADCipherImpl = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_AES_GCM(), true);
        BcTlsAEADCipherImpl bcTlsAEADCipherImpl2 = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_AES_GCM(), false);
        return new TlsAEADCipher(tlsCryptoParameters, bcTlsAEADCipherImpl, bcTlsAEADCipherImpl2, n, n2, 3);
    }

    protected TlsAEADCipher createCipher_ARIA_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        BcTlsAEADCipherImpl bcTlsAEADCipherImpl = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_ARIA_GCM(), true);
        BcTlsAEADCipherImpl bcTlsAEADCipherImpl2 = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_ARIA_GCM(), false);
        return new TlsAEADCipher(tlsCryptoParameters, bcTlsAEADCipherImpl, bcTlsAEADCipherImpl2, n, n2, 3);
    }

    protected TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        BcTlsAEADCipherImpl bcTlsAEADCipherImpl = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_Camellia_GCM(), true);
        BcTlsAEADCipherImpl bcTlsAEADCipherImpl2 = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_Camellia_GCM(), false);
        return new TlsAEADCipher(tlsCryptoParameters, bcTlsAEADCipherImpl, bcTlsAEADCipherImpl2, n, n2, 3);
    }

    protected TlsCipher createCipher_CBC(TlsCryptoParameters tlsCryptoParameters, int n, int n2, int n3) throws IOException {
        BcTlsBlockCipherImpl bcTlsBlockCipherImpl = new BcTlsBlockCipherImpl(this.createCBCBlockCipher(n), true);
        BcTlsBlockCipherImpl bcTlsBlockCipherImpl2 = new BcTlsBlockCipherImpl(this.createCBCBlockCipher(n), false);
        TlsHMAC tlsHMAC = this.createMAC(tlsCryptoParameters, n3);
        TlsHMAC tlsHMAC2 = this.createMAC(tlsCryptoParameters, n3);
        return new TlsBlockCipher(tlsCryptoParameters, bcTlsBlockCipherImpl, bcTlsBlockCipherImpl2, tlsHMAC, tlsHMAC2, n2);
    }

    protected TlsAEADCipher createCipher_SM4_CCM(TlsCryptoParameters tlsCryptoParameters) throws IOException {
        BcTlsAEADCipherImpl bcTlsAEADCipherImpl = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_SM4_CCM(), true);
        BcTlsAEADCipherImpl bcTlsAEADCipherImpl2 = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_SM4_CCM(), false);
        return new TlsAEADCipher(tlsCryptoParameters, bcTlsAEADCipherImpl, bcTlsAEADCipherImpl2, 16, 16, 1);
    }

    protected TlsAEADCipher createCipher_SM4_GCM(TlsCryptoParameters tlsCryptoParameters) throws IOException {
        BcTlsAEADCipherImpl bcTlsAEADCipherImpl = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_SM4_GCM(), true);
        BcTlsAEADCipherImpl bcTlsAEADCipherImpl2 = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_SM4_GCM(), false);
        return new TlsAEADCipher(tlsCryptoParameters, bcTlsAEADCipherImpl, bcTlsAEADCipherImpl2, 16, 16, 3);
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException {
        return new TlsNullCipher(tlsCryptoParameters, this.createMAC(tlsCryptoParameters, n), this.createMAC(tlsCryptoParameters, n));
    }

    protected BlockCipher createAESEngine() {
        return new AESEngine();
    }

    protected BlockCipher createARIAEngine() {
        return new ARIAEngine();
    }

    protected BlockCipher createCamelliaEngine() {
        return new CamelliaEngine();
    }

    protected BlockCipher createDESedeEngine() {
        return new DESedeEngine();
    }

    protected BlockCipher createSEEDEngine() {
        return new SEEDEngine();
    }

    protected BlockCipher createSM4Engine() {
        return new SM4Engine();
    }

    protected AEADBlockCipher createCCMMode(BlockCipher blockCipher) {
        return new CCMBlockCipher(blockCipher);
    }

    protected AEADBlockCipher createGCMMode(BlockCipher blockCipher) {
        return new GCMBlockCipher(blockCipher);
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_CCM() {
        return this.createCCMMode(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_GCM() {
        return this.createGCMMode(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_ARIA_GCM() {
        return this.createGCMMode(this.createARIAEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_Camellia_GCM() {
        return this.createGCMMode(this.createCamelliaEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_SM4_CCM() {
        return this.createCCMMode(this.createSM4Engine());
    }

    protected AEADBlockCipher createAEADBlockCipher_SM4_GCM() {
        return this.createGCMMode(this.createSM4Engine());
    }

    public TlsHMAC createHMAC(int n) {
        return this.createHMACForHash(TlsCryptoUtils.getHashForHMAC(n));
    }

    public TlsHMAC createHMACForHash(int n) {
        return new BcTlsHMAC(new HMac(this.createDigest(n)));
    }

    protected TlsHMAC createHMAC_SSL(int n) throws IOException {
        switch (n) {
            case 1: {
                return new BcSSL3HMAC(this.createDigest(1));
            }
            case 2: {
                return new BcSSL3HMAC(this.createDigest(2));
            }
            case 3: {
                return new BcSSL3HMAC(this.createDigest(4));
            }
            case 4: {
                return new BcSSL3HMAC(this.createDigest(5));
            }
            case 5: {
                return new BcSSL3HMAC(this.createDigest(6));
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsHMAC createMAC(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException {
        if (TlsImplUtils.isSSL(tlsCryptoParameters)) {
            return this.createHMAC_SSL(n);
        }
        return this.createHMAC(n);
    }

    public TlsSRP6Client createSRP6Client(TlsSRPConfig tlsSRPConfig) {
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        SRP6GroupParameters sRP6GroupParameters = new SRP6GroupParameters(bigIntegerArray[0], bigIntegerArray[1]);
        SRP6Client sRP6Client = new SRP6Client();
        sRP6Client.init(sRP6GroupParameters, this.createDigest(2), this.getSecureRandom());
        return new BcTlsSRP6Client(sRP6Client);
    }

    public TlsSRP6Server createSRP6Server(TlsSRPConfig tlsSRPConfig, BigInteger bigInteger) {
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        SRP6GroupParameters sRP6GroupParameters = new SRP6GroupParameters(bigIntegerArray[0], bigIntegerArray[1]);
        SRP6Server sRP6Server = new SRP6Server();
        sRP6Server.init(sRP6GroupParameters, bigInteger, this.createDigest(2), this.getSecureRandom());
        return new BcTlsSRP6Server(sRP6Server);
    }

    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig tlsSRPConfig) {
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        SRP6VerifierGenerator sRP6VerifierGenerator = new SRP6VerifierGenerator();
        sRP6VerifierGenerator.init(bigIntegerArray[0], bigIntegerArray[1], this.createDigest(2));
        return new BcTlsSRP6VerifierGenerator(sRP6VerifierGenerator);
    }

    public TlsSecret hkdfInit(int n) {
        return this.adoptLocalSecret(new byte[TlsCryptoUtils.getHashOutputSize(n)]);
    }
}

