/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class BcTlsSecret
extends AbstractTlsSecret {
    private static final byte[] SSL3_CONST = BcTlsSecret.generateSSL3Constants();
    protected final BcTlsCrypto crypto;

    private static byte[] generateSSL3Constants() {
        int n = 15;
        byte[] byArray = new byte[n * (n + 1) / 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = (byte)(65 + i);
            for (int j = 0; j <= i; ++j) {
                byArray[n2++] = by;
            }
        }
        return byArray;
    }

    public BcTlsSecret(BcTlsCrypto bcTlsCrypto, byte[] byArray) {
        super(byArray);
        this.crypto = bcTlsCrypto;
    }

    public synchronized TlsSecret deriveUsingPRF(int n, String string, byte[] byArray, int n2) {
        this.checkAlive();
        try {
            switch (n) {
                case 4: {
                    return TlsCryptoUtils.hkdfExpandLabel((TlsSecret)this, 4, string, byArray, n2);
                }
                case 5: {
                    return TlsCryptoUtils.hkdfExpandLabel((TlsSecret)this, 5, string, byArray, n2);
                }
                case 7: {
                    return TlsCryptoUtils.hkdfExpandLabel((TlsSecret)this, 7, string, byArray, n2);
                }
            }
            return this.crypto.adoptLocalSecret(this.prf(n, string, byArray, n2));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public synchronized TlsSecret hkdfExpand(int n, byte[] byArray, int n2) {
        int n3;
        if (n2 < 1) {
            return this.crypto.adoptLocalSecret(TlsUtils.EMPTY_BYTES);
        }
        int n4 = TlsCryptoUtils.getHashOutputSize(n);
        if (n2 > 255 * n4) {
            throw new IllegalArgumentException("'length' must be <= 255 * (output size of 'hashAlgorithm')");
        }
        this.checkAlive();
        byte[] byArray2 = this.data;
        HMac hMac = new HMac(this.crypto.createDigest(n));
        hMac.init((CipherParameters)new KeyParameter(byArray2));
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n4];
        byte by = 0;
        int n5 = 0;
        while (true) {
            hMac.update(byArray, 0, byArray.length);
            by = (byte)(by + 1);
            hMac.update(by);
            hMac.doFinal(byArray4, 0);
            n3 = n2 - n5;
            if (n3 <= n4) break;
            System.arraycopy(byArray4, 0, byArray3, n5, n4);
            n5 += n4;
            hMac.update(byArray4, 0, byArray4.length);
        }
        System.arraycopy(byArray4, 0, byArray3, n5, n3);
        return this.crypto.adoptLocalSecret(byArray3);
    }

    public synchronized TlsSecret hkdfExtract(int n, byte[] byArray) {
        this.checkAlive();
        byte[] byArray2 = this.data;
        this.data = null;
        HMac hMac = new HMac(this.crypto.createDigest(n));
        hMac.init((CipherParameters)new KeyParameter(byArray2));
        hMac.update(byArray, 0, byArray.length);
        byte[] byArray3 = new byte[hMac.getMacSize()];
        hMac.doFinal(byArray3, 0);
        return this.crypto.adoptLocalSecret(byArray3);
    }

    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    protected void hmacHash(Digest digest, byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3) {
        HMac hMac = new HMac(digest);
        hMac.init((CipherParameters)new KeyParameter(byArray, n, n2));
        byte[] byArray4 = byArray2;
        int n3 = hMac.getMacSize();
        byte[] byArray5 = new byte[n3];
        byte[] byArray6 = new byte[n3];
        for (int i = 0; i < byArray3.length; i += n3) {
            hMac.update(byArray4, 0, byArray4.length);
            hMac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            hMac.update(byArray4, 0, byArray4.length);
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, i, Math.min(n3, byArray3.length - i));
        }
    }

    protected byte[] prf(int n, String string, byte[] byArray, int n2) {
        if (0 == n) {
            return this.prf_SSL(byArray, n2);
        }
        byte[] byArray2 = Arrays.concatenate((byte[])Strings.toByteArray((String)string), (byte[])byArray);
        if (1 == n) {
            return this.prf_1_0(byArray2, n2);
        }
        return this.prf_1_2(n, byArray2, n2);
    }

    protected byte[] prf_SSL(byte[] byArray, int n) {
        Digest digest = this.crypto.createDigest(1);
        Digest digest2 = this.crypto.createDigest(2);
        int n2 = digest.getDigestSize();
        int n3 = digest2.getDigestSize();
        byte[] byArray2 = new byte[Math.max(n2, n3)];
        byte[] byArray3 = new byte[n];
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            digest2.update(SSL3_CONST, n5, n4);
            n5 += n4++;
            digest2.update(this.data, 0, this.data.length);
            digest2.update(byArray, 0, byArray.length);
            digest2.doFinal(byArray2, 0);
            digest.update(this.data, 0, this.data.length);
            digest.update(byArray2, 0, n3);
            int n7 = n - n6;
            if (n7 < n2) {
                digest.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray3, n6, n7);
                n6 += n7;
                continue;
            }
            digest.doFinal(byArray3, n6);
            n6 += n2;
        }
        return byArray3;
    }

    protected byte[] prf_1_0(byte[] byArray, int n) {
        int n2 = (this.data.length + 1) / 2;
        byte[] byArray2 = new byte[n];
        this.hmacHash(this.crypto.createDigest(1), this.data, 0, n2, byArray, byArray2);
        byte[] byArray3 = new byte[n];
        this.hmacHash(this.crypto.createDigest(2), this.data, this.data.length - n2, n2, byArray, byArray3);
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            byArray2[n3] = (byte)(byArray2[n3] ^ byArray3[i]);
        }
        return byArray2;
    }

    protected byte[] prf_1_2(int n, byte[] byArray, int n2) {
        Digest digest = this.crypto.createDigest(TlsCryptoUtils.getHashForPRF(n));
        byte[] byArray2 = new byte[n2];
        this.hmacHash(digest, this.data, 0, this.data.length, byArray, byArray2);
        return byArray2;
    }
}

