/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvAlgorithmChecker
extends PKIXCertPathChecker {
    static final int KU_DIGITAL_SIGNATURE = 0;
    static final int KU_KEY_ENCIPHERMENT = 2;
    static final int KU_KEY_AGREEMENT = 4;
    private static final Map<String, String> sigAlgNames = ProvAlgorithmChecker.createSigAlgNames();
    private static final Set<String> sigAlgNoParams = ProvAlgorithmChecker.createSigAlgNoParams();
    private static final byte[] DER_NULL_ENCODING = new byte[]{5, 0};
    private static final String SIG_ALG_NAME_rsa_pss_pss_sha256 = JsseUtils.getJcaSignatureAlgorithmBC("SHA256withRSAandMGF1", "RSASSA-PSS");
    private static final String SIG_ALG_NAME_rsa_pss_pss_sha384 = JsseUtils.getJcaSignatureAlgorithmBC("SHA384withRSAandMGF1", "RSASSA-PSS");
    private static final String SIG_ALG_NAME_rsa_pss_pss_sha512 = JsseUtils.getJcaSignatureAlgorithmBC("SHA512withRSAandMGF1", "RSASSA-PSS");
    private static final String SIG_ALG_NAME_rsa_pss_rsae_sha256 = JsseUtils.getJcaSignatureAlgorithmBC("SHA256withRSAandMGF1", "RSA");
    private static final String SIG_ALG_NAME_rsa_pss_rsae_sha384 = JsseUtils.getJcaSignatureAlgorithmBC("SHA384withRSAandMGF1", "RSA");
    private static final String SIG_ALG_NAME_rsa_pss_rsae_sha512 = JsseUtils.getJcaSignatureAlgorithmBC("SHA512withRSAandMGF1", "RSA");
    private final boolean isInFipsMode;
    private final JcaJceHelper helper;
    private final BCAlgorithmConstraints algorithmConstraints;
    private X509Certificate issuerCert;

    private static Map<String, String> createSigAlgNames() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(EdECObjectIdentifiers.id_Ed25519.getId(), "Ed25519");
        hashMap.put(EdECObjectIdentifiers.id_Ed448.getId(), "Ed448");
        hashMap.put(OIWObjectIdentifiers.dsaWithSHA1.getId(), "SHA1withDSA");
        hashMap.put(X9ObjectIdentifiers.id_dsa_with_sha1.getId(), "SHA1withDSA");
        return Collections.unmodifiableMap(hashMap);
    }

    private static Set<String> createSigAlgNoParams() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(OIWObjectIdentifiers.dsaWithSHA1.getId());
        hashSet.add(X9ObjectIdentifiers.id_dsa_with_sha1.getId());
        hashSet.add(PKCSObjectIdentifiers.id_RSASSA_PSS.getId());
        return Collections.unmodifiableSet(hashSet);
    }

    ProvAlgorithmChecker(boolean bl, JcaJceHelper jcaJceHelper, BCAlgorithmConstraints bCAlgorithmConstraints) {
        if (null == jcaJceHelper) {
            throw new NullPointerException("'helper' cannot be null");
        }
        if (null == bCAlgorithmConstraints) {
            throw new NullPointerException("'algorithmConstraints' cannot be null");
        }
        this.isInFipsMode = bl;
        this.helper = jcaJceHelper;
        this.algorithmConstraints = bCAlgorithmConstraints;
        this.issuerCert = null;
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.issuerCert = null;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        if (!(certificate instanceof X509Certificate)) {
            throw new CertPathValidatorException("checker can only be used for X.509 certificates");
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (this.isInFipsMode && !ProvAlgorithmChecker.isValidFIPSPublicKey(x509Certificate.getPublicKey())) {
            throw new CertPathValidatorException("non-FIPS public key found");
        }
        if (null != this.issuerCert) {
            ProvAlgorithmChecker.checkIssuedBy(this.helper, this.algorithmConstraints, x509Certificate, this.issuerCert);
        }
        this.issuerCert = x509Certificate;
    }

    static void checkCertPathExtras(JcaJceHelper jcaJceHelper, BCAlgorithmConstraints bCAlgorithmConstraints, X509Certificate[] x509CertificateArray, KeyPurposeId keyPurposeId, int n) throws CertPathValidatorException {
        X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
        if (x509CertificateArray.length > 1) {
            ProvAlgorithmChecker.checkIssuedBy(jcaJceHelper, bCAlgorithmConstraints, x509CertificateArray[x509CertificateArray.length - 2], x509Certificate);
        }
        X509Certificate x509Certificate2 = x509CertificateArray[0];
        ProvAlgorithmChecker.checkEndEntity(jcaJceHelper, bCAlgorithmConstraints, x509Certificate2, keyPurposeId, n);
    }

    static void checkChain(boolean bl, JcaJceHelper jcaJceHelper, BCAlgorithmConstraints bCAlgorithmConstraints, Set<X509Certificate> set, X509Certificate[] x509CertificateArray, KeyPurposeId keyPurposeId, int n) throws CertPathValidatorException {
        Object object;
        int n2;
        for (n2 = x509CertificateArray.length; n2 > 0 && set.contains(x509CertificateArray[n2 - 1]); --n2) {
        }
        if (n2 < x509CertificateArray.length) {
            object = x509CertificateArray[n2];
            if (n2 > 0) {
                ProvAlgorithmChecker.checkIssuedBy(jcaJceHelper, bCAlgorithmConstraints, x509CertificateArray[n2 - 1], (X509Certificate)object);
            }
        } else {
            ProvAlgorithmChecker.checkIssued(jcaJceHelper, bCAlgorithmConstraints, x509CertificateArray[n2 - 1]);
        }
        object = new ProvAlgorithmChecker(bl, jcaJceHelper, bCAlgorithmConstraints);
        ((ProvAlgorithmChecker)object).init(false);
        for (int i = n2 - 1; i >= 0; --i) {
            ((ProvAlgorithmChecker)object).check(x509CertificateArray[i], Collections.<String>emptySet());
        }
        X509Certificate x509Certificate = x509CertificateArray[0];
        ProvAlgorithmChecker.checkEndEntity(jcaJceHelper, bCAlgorithmConstraints, x509Certificate, keyPurposeId, n);
    }

    private static void checkEndEntity(JcaJceHelper jcaJceHelper, BCAlgorithmConstraints bCAlgorithmConstraints, X509Certificate x509Certificate, KeyPurposeId keyPurposeId, int n) throws CertPathValidatorException {
        if (null != keyPurposeId && !ProvAlgorithmChecker.supportsExtendedKeyUsage(x509Certificate, keyPurposeId)) {
            throw new CertPathValidatorException("Certificate doesn't support '" + ProvAlgorithmChecker.getExtendedKeyUsageName(keyPurposeId) + "' ExtendedKeyUsage");
        }
        if (n >= 0) {
            if (!ProvAlgorithmChecker.supportsKeyUsage(x509Certificate, n)) {
                throw new CertPathValidatorException("Certificate doesn't support '" + ProvAlgorithmChecker.getKeyUsageName(n) + "' KeyUsage");
            }
            if (!bCAlgorithmConstraints.permits(ProvAlgorithmChecker.getKeyUsagePrimitives(n), x509Certificate.getPublicKey())) {
                throw new CertPathValidatorException("Public key not permitted for '" + ProvAlgorithmChecker.getKeyUsageName(n) + "' KeyUsage");
            }
        }
    }

    private static void checkIssued(JcaJceHelper jcaJceHelper, BCAlgorithmConstraints bCAlgorithmConstraints, X509Certificate x509Certificate) throws CertPathValidatorException {
        String string = ProvAlgorithmChecker.getSigAlgName(x509Certificate, null);
        if (!JsseUtils.isNameSpecified(string)) {
            throw new CertPathValidatorException("Signature algorithm could not be determined");
        }
        AlgorithmParameters algorithmParameters = ProvAlgorithmChecker.getSigAlgParams(jcaJceHelper, x509Certificate);
        if (!bCAlgorithmConstraints.permits(JsseUtils.SIGNATURE_CRYPTO_PRIMITIVES_BC, string, algorithmParameters)) {
            throw new CertPathValidatorException("Signature algorithm '" + string + "' not permitted with given parameters");
        }
    }

    private static void checkIssuedBy(JcaJceHelper jcaJceHelper, BCAlgorithmConstraints bCAlgorithmConstraints, X509Certificate x509Certificate, X509Certificate x509Certificate2) throws CertPathValidatorException {
        String string = ProvAlgorithmChecker.getSigAlgName(x509Certificate, x509Certificate2);
        if (!JsseUtils.isNameSpecified(string)) {
            throw new CertPathValidatorException("Signature algorithm could not be determined");
        }
        AlgorithmParameters algorithmParameters = ProvAlgorithmChecker.getSigAlgParams(jcaJceHelper, x509Certificate);
        if (!bCAlgorithmConstraints.permits(JsseUtils.SIGNATURE_CRYPTO_PRIMITIVES_BC, string, x509Certificate2.getPublicKey(), algorithmParameters)) {
            throw new CertPathValidatorException("Signature algorithm '" + string + "' not permitted with given parameters and issuer public key");
        }
    }

    static String getExtendedKeyUsageName(KeyPurposeId keyPurposeId) {
        if (KeyPurposeId.id_kp_clientAuth.equals((Object)keyPurposeId)) {
            return "clientAuth";
        }
        if (KeyPurposeId.id_kp_serverAuth.equals((Object)keyPurposeId)) {
            return "serverAuth";
        }
        return "(" + keyPurposeId + ")";
    }

    static String getKeyUsageName(int n) {
        switch (n) {
            case 0: {
                return "digitalSignature";
            }
            case 2: {
                return "keyEncipherment";
            }
            case 4: {
                return "keyAgreement";
            }
        }
        return "(" + n + ")";
    }

    static Set<BCCryptoPrimitive> getKeyUsagePrimitives(int n) {
        switch (n) {
            case 4: {
                return JsseUtils.KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC;
            }
            case 2: {
                return JsseUtils.KEY_ENCAPSULATION_CRYPTO_PRIMITIVES_BC;
            }
        }
        return JsseUtils.SIGNATURE_CRYPTO_PRIMITIVES_BC;
    }

    static String getSigAlgName(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        String string = x509Certificate.getSigAlgOID();
        String string2 = sigAlgNames.get(string);
        if (null != string2) {
            return string2;
        }
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.getId().equals(string)) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            string2 = RSASSAPSSparams.getInstance((Object)x509Certificate.getSigAlgParams());
            if (null != string2 && null != (aSN1ObjectIdentifier = string2.getHashAlgorithm().getAlgorithm())) {
                X509Certificate x509Certificate3 = x509Certificate2;
                if (null == x509Certificate3) {
                    x509Certificate3 = x509Certificate;
                }
                try {
                    JcaTlsCertificate jcaTlsCertificate = new JcaTlsCertificate(null, x509Certificate3);
                    if (NISTObjectIdentifiers.id_sha256.equals((ASN1Primitive)aSN1ObjectIdentifier)) {
                        if (jcaTlsCertificate.supportsSignatureAlgorithmCA((short)9)) {
                            return SIG_ALG_NAME_rsa_pss_pss_sha256;
                        }
                        if (jcaTlsCertificate.supportsSignatureAlgorithmCA((short)4)) {
                            return SIG_ALG_NAME_rsa_pss_rsae_sha256;
                        }
                    } else if (NISTObjectIdentifiers.id_sha384.equals((ASN1Primitive)aSN1ObjectIdentifier)) {
                        if (jcaTlsCertificate.supportsSignatureAlgorithmCA((short)10)) {
                            return SIG_ALG_NAME_rsa_pss_pss_sha384;
                        }
                        if (jcaTlsCertificate.supportsSignatureAlgorithmCA((short)5)) {
                            return SIG_ALG_NAME_rsa_pss_rsae_sha384;
                        }
                    } else if (NISTObjectIdentifiers.id_sha512.equals((ASN1Primitive)aSN1ObjectIdentifier)) {
                        if (jcaTlsCertificate.supportsSignatureAlgorithmCA((short)11)) {
                            return SIG_ALG_NAME_rsa_pss_pss_sha512;
                        }
                        if (jcaTlsCertificate.supportsSignatureAlgorithmCA((short)6)) {
                            return SIG_ALG_NAME_rsa_pss_rsae_sha512;
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
        return x509Certificate.getSigAlgName();
    }

    static AlgorithmParameters getSigAlgParams(JcaJceHelper jcaJceHelper, X509Certificate x509Certificate) throws CertPathValidatorException {
        AlgorithmParameters algorithmParameters;
        byte[] byArray = x509Certificate.getSigAlgParams();
        if (null == byArray) {
            return null;
        }
        String string = x509Certificate.getSigAlgOID();
        if (sigAlgNoParams.contains(string) && Arrays.areEqual((byte[])DER_NULL_ENCODING, (byte[])byArray)) {
            return null;
        }
        try {
            algorithmParameters = jcaJceHelper.createAlgorithmParameters(string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
        try {
            algorithmParameters.init(byArray);
        }
        catch (Exception exception) {
            throw new CertPathValidatorException(exception);
        }
        return algorithmParameters;
    }

    static boolean isValidFIPSPublicKey(PublicKey publicKey) {
        try {
            ASN1Primitive aSN1Primitive;
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
            if (!X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)algorithmIdentifier.getAlgorithm())) {
                return true;
            }
            ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
            if (null != aSN1Encodable && (aSN1Primitive = aSN1Encodable.toASN1Primitive()) instanceof ASN1ObjectIdentifier) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static boolean permitsKeyUsage(PublicKey publicKey, boolean[] blArray, int n, BCAlgorithmConstraints bCAlgorithmConstraints) {
        return ProvAlgorithmChecker.supportsKeyUsage(blArray, n) && bCAlgorithmConstraints.permits(ProvAlgorithmChecker.getKeyUsagePrimitives(n), publicKey);
    }

    static boolean supportsExtendedKeyUsage(X509Certificate x509Certificate, KeyPurposeId keyPurposeId) {
        try {
            return ProvAlgorithmChecker.supportsExtendedKeyUsage(x509Certificate.getExtendedKeyUsage(), keyPurposeId);
        }
        catch (CertificateParsingException certificateParsingException) {
            return false;
        }
    }

    static boolean supportsExtendedKeyUsage(List<String> list, KeyPurposeId keyPurposeId) {
        return null == list || list.contains(keyPurposeId.getId()) || list.contains(KeyPurposeId.anyExtendedKeyUsage.getId());
    }

    static boolean supportsKeyUsage(X509Certificate x509Certificate, int n) {
        return ProvAlgorithmChecker.supportsKeyUsage(x509Certificate.getKeyUsage(), n);
    }

    static boolean supportsKeyUsage(boolean[] blArray, int n) {
        return null == blArray || blArray.length > n && blArray[n];
    }
}

