/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsContext;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HandshakeMessageInput;
import org.bouncycastle.tls.HandshakeMessageOutput;
import org.bouncycastle.tls.KeyShareEntry;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.OfferedPsks;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContextImpl;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;

public class TlsServerProtocol
extends TlsProtocol {
    protected TlsServer tlsServer = null;
    TlsServerContextImpl tlsServerContext = null;
    protected int[] offeredCipherSuites = null;
    protected TlsKeyExchange keyExchange = null;
    protected CertificateRequest certificateRequest = null;

    public TlsServerProtocol() {
    }

    public TlsServerProtocol(InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream);
    }

    public void accept(TlsServer tlsServer) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'tlsServer' cannot be null");
        }
        if (this.tlsServer != null) {
            throw new IllegalStateException("'accept' can only be called once");
        }
        this.tlsServer = tlsServer;
        this.tlsServerContext = new TlsServerContextImpl(tlsServer.getCrypto());
        tlsServer.init(this.tlsServerContext);
        tlsServer.notifyCloseHandle(this);
        this.beginHandshake(false);
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.offeredCipherSuites = null;
        this.keyExchange = null;
        this.certificateRequest = null;
    }

    protected boolean expectCertificateVerifyMessage() {
        if (null == this.certificateRequest) {
            return false;
        }
        Certificate certificate = this.tlsServerContext.getSecurityParametersHandshake().getPeerCertificate();
        return null != certificate && !certificate.isEmpty() && (null == this.keyExchange || this.keyExchange.requiresCertificateVerify());
    }

    protected ServerHello generate13HelloRetryRequest(ClientHello clientHello) throws IOException {
        if (this.retryGroup < 0) {
            throw new TlsFatalAlert(80);
        }
        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        Hashtable hashtable = new Hashtable();
        TlsExtensionsUtils.addSupportedVersionsExtensionServer(hashtable, protocolVersion);
        if (this.retryGroup >= 0) {
            TlsExtensionsUtils.addKeyShareHelloRetryRequest(hashtable, this.retryGroup);
        }
        if (null != this.retryCookie) {
            TlsExtensionsUtils.addCookieExtension(hashtable, this.retryCookie);
        }
        TlsUtils.checkExtensionData13(hashtable, 6, (short)80);
        return new ServerHello(clientHello.getSessionID(), securityParameters.getCipherSuite(), hashtable);
    }

    protected ServerHello generate13ServerHello(ClientHello clientHello, HandshakeMessageInput handshakeMessageInput, boolean bl) throws IOException {
        TlsAgreement tlsAgreement;
        int n;
        Object object;
        Object object2;
        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            throw new TlsFatalAlert(80);
        }
        byte[] byArray = clientHello.getSessionID();
        Hashtable hashtable = clientHello.getExtensions();
        if (null == hashtable) {
            throw new TlsFatalAlert(109);
        }
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        TlsCrypto tlsCrypto = this.tlsServerContext.getCrypto();
        OfferedPsks.SelectedConfig selectedConfig = TlsUtils.selectPreSharedKey(this.tlsServerContext, this.tlsServer, hashtable, handshakeMessageInput, this.handshakeHash, bl);
        Vector vector = TlsExtensionsUtils.getKeyShareClientHello(hashtable);
        KeyShareEntry keyShareEntry = null;
        if (bl) {
            if (this.retryGroup < 0) {
                throw new TlsFatalAlert(80);
            }
            if (null == selectedConfig) {
                if (null == securityParameters.getClientSigAlgs()) {
                    throw new TlsFatalAlert(109);
                }
            } else if (selectedConfig.psk.getPRFAlgorithm() != securityParameters.getPRFAlgorithm()) {
                throw new TlsFatalAlert(47);
            }
            if (!Arrays.areEqual((byte[])this.retryCookie, (byte[])(object2 = TlsExtensionsUtils.getCookieExtension(hashtable)))) {
                throw new TlsFatalAlert(47);
            }
            this.retryCookie = null;
            keyShareEntry = TlsUtils.selectKeyShare(vector, this.retryGroup);
            if (null == keyShareEntry) {
                throw new TlsFatalAlert(47);
            }
        } else {
            int n2;
            this.clientExtensions = hashtable;
            securityParameters.secureRenegotiation = false;
            TlsExtensionsUtils.getPaddingExtension(hashtable);
            securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(hashtable);
            TlsUtils.establishClientSigAlgs(securityParameters, hashtable);
            if (null == selectedConfig && null == securityParameters.getClientSigAlgs()) {
                throw new TlsFatalAlert(109);
            }
            this.tlsServer.processClientExtensions(hashtable);
            this.tlsSession = TlsUtils.importSession(TlsUtils.EMPTY_BYTES, null);
            this.sessionParameters = null;
            this.sessionMasterSecret = null;
            securityParameters.sessionID = this.tlsSession.getSessionID();
            this.tlsServer.notifySession(this.tlsSession);
            TlsUtils.negotiatedVersionTLSServer(this.tlsServerContext);
            securityParameters.serverRandom = TlsServerProtocol.createRandomBlock(false, this.tlsServerContext);
            if (!protocolVersion.equals(ProtocolVersion.getLatestTLS(this.tlsServer.getProtocolVersions()))) {
                TlsUtils.writeDowngradeMarker(protocolVersion, securityParameters.getServerRandom());
            }
            if (!TlsUtils.isValidCipherSuiteSelection(this.offeredCipherSuites, n2 = this.tlsServer.getSelectedCipherSuite()) || !TlsUtils.isValidVersionForCipherSuite(n2, protocolVersion)) {
                throw new TlsFatalAlert(80);
            }
            TlsUtils.negotiatedCipherSuite(securityParameters, n2);
            object2 = securityParameters.getClientSupportedGroups();
            object = securityParameters.getServerSupportedGroups();
            keyShareEntry = TlsUtils.selectKeyShare(tlsCrypto, protocolVersion, vector, object2, (int[])object);
            if (null == keyShareEntry) {
                this.retryGroup = TlsUtils.selectKeyShareGroup(tlsCrypto, protocolVersion, object2, (int[])object);
                if (this.retryGroup < 0) {
                    throw new TlsFatalAlert(40);
                }
                this.retryCookie = this.tlsServerContext.getNonceGenerator().generateNonce(16);
                return this.generate13HelloRetryRequest(clientHello);
            }
            if (keyShareEntry.getNamedGroup() != object[0]) {
                // empty if block
            }
        }
        object2 = new Hashtable();
        object = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsServer.getServerExtensions());
        this.tlsServer.getServerExtensionsForConnection((Hashtable)object);
        ProtocolVersion protocolVersion2 = ProtocolVersion.TLSv12;
        TlsExtensionsUtils.addSupportedVersionsExtensionServer((Hashtable)object2, protocolVersion);
        securityParameters.extendedMasterSecret = true;
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer((Hashtable)object);
        securityParameters.applicationProtocolSet = true;
        if (!((Hashtable)object).isEmpty()) {
            securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(hashtable, (Hashtable)object, (short)80);
        }
        securityParameters.encryptThenMAC = false;
        securityParameters.truncatedHMac = false;
        securityParameters.statusRequestVersion = hashtable.containsKey(TlsExtensionsUtils.EXT_status_request) ? 1 : 0;
        this.expectSessionTicket = false;
        TlsSecret tlsSecret = null;
        if (null != selectedConfig) {
            tlsSecret = selectedConfig.earlySecret;
            this.selectedPSK13 = true;
            TlsExtensionsUtils.addPreSharedKeyServerHello((Hashtable)object2, selectedConfig.index);
        }
        if (NamedGroup.refersToASpecificCurve(n = keyShareEntry.getNamedGroup())) {
            tlsAgreement = tlsCrypto.createECDomain(new TlsECConfig(n)).createECDH();
        } else if (NamedGroup.refersToASpecificFiniteField(n)) {
            tlsAgreement = tlsCrypto.createDHDomain(new TlsDHConfig(n, true)).createDH();
        } else {
            throw new TlsFatalAlert(80);
        }
        byte[] byArray2 = tlsAgreement.generateEphemeral();
        KeyShareEntry keyShareEntry2 = new KeyShareEntry(n, byArray2);
        TlsExtensionsUtils.addKeyShareServerHello((Hashtable)object2, keyShareEntry2);
        tlsAgreement.receivePeerValue(keyShareEntry.getKeyExchange());
        TlsSecret tlsSecret2 = tlsAgreement.calculateSecret();
        TlsUtils.establish13PhaseSecrets(this.tlsServerContext, tlsSecret, tlsSecret2);
        this.serverExtensions = object;
        this.applyMaxFragmentLengthExtension(securityParameters.getMaxFragmentLength());
        TlsUtils.checkExtensionData13((Hashtable)object2, 2, (short)80);
        return new ServerHello(protocolVersion2, securityParameters.getServerRandom(), byArray, securityParameters.getCipherSuite(), (Hashtable)object2);
    }

    protected ServerHello generateServerHello(ClientHello clientHello, HandshakeMessageInput handshakeMessageInput) throws IOException {
        byte[] byArray;
        ProtocolVersion protocolVersion;
        ProtocolVersion protocolVersion2 = clientHello.getVersion();
        if (!protocolVersion2.isTLS()) {
            throw new TlsFatalAlert(47);
        }
        this.offeredCipherSuites = clientHello.getCipherSuites();
        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
        this.tlsServerContext.setClientSupportedVersions(TlsExtensionsUtils.getSupportedVersionsExtensionClient(clientHello.getExtensions()));
        ProtocolVersion protocolVersion3 = protocolVersion2;
        if (null == this.tlsServerContext.getClientSupportedVersions()) {
            if (protocolVersion3.isLaterVersionOf(ProtocolVersion.TLSv12)) {
                protocolVersion3 = ProtocolVersion.TLSv12;
            }
            this.tlsServerContext.setClientSupportedVersions(protocolVersion3.downTo(ProtocolVersion.SSLv3));
        } else {
            protocolVersion3 = ProtocolVersion.getLatestTLS(this.tlsServerContext.getClientSupportedVersions());
        }
        this.recordStream.setWriteVersion(protocolVersion3);
        if (!ProtocolVersion.SERVER_EARLIEST_SUPPORTED_TLS.isEqualOrEarlierVersionOf(protocolVersion3)) {
            throw new TlsFatalAlert(70);
        }
        if (securityParameters.isRenegotiating()) {
            if (!protocolVersion3.equals(this.tlsServerContext.getClientVersion()) && !protocolVersion3.equals(this.tlsServerContext.getServerVersion())) {
                throw new TlsFatalAlert(47);
            }
        } else {
            this.tlsServerContext.setClientVersion(protocolVersion3);
        }
        this.tlsServer.notifyClientVersion(this.tlsServerContext.getClientVersion());
        securityParameters.clientRandom = clientHello.getRandom();
        this.tlsServer.notifyFallback(Arrays.contains((int[])this.offeredCipherSuites, (int)22016));
        this.tlsServer.notifyOfferedCipherSuites(this.offeredCipherSuites);
        if (securityParameters.isRenegotiating()) {
            protocolVersion = this.tlsServerContext.getServerVersion();
        } else {
            protocolVersion = this.tlsServer.getServerVersion();
            if (!ProtocolVersion.contains(this.tlsServerContext.getClientSupportedVersions(), protocolVersion)) {
                throw new TlsFatalAlert(80);
            }
            securityParameters.negotiatedVersion = protocolVersion;
        }
        securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(clientHello.getExtensions());
        securityParameters.serverSupportedGroups = this.tlsServer.getSupportedGroups();
        if (ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion)) {
            this.recordStream.setIgnoreChangeCipherSpec(true);
            this.recordStream.setWriteVersion(ProtocolVersion.TLSv12);
            return this.generate13ServerHello(clientHello, handshakeMessageInput, false);
        }
        this.recordStream.setWriteVersion(protocolVersion);
        this.clientExtensions = clientHello.getExtensions();
        byte[] byArray2 = TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            if (Arrays.contains((int[])this.offeredCipherSuites, (int)255)) {
                throw new TlsFatalAlert(40);
            }
            if (null == byArray2) {
                throw new TlsFatalAlert(40);
            }
            SecurityParameters securityParameters2 = this.tlsServerContext.getSecurityParametersConnection();
            byArray = securityParameters2.getPeerVerifyData();
            if (!Arrays.constantTimeAreEqual((byte[])byArray2, (byte[])TlsServerProtocol.createRenegotiationInfo(byArray))) {
                throw new TlsFatalAlert(40);
            }
        } else {
            if (Arrays.contains((int[])this.offeredCipherSuites, (int)255)) {
                securityParameters.secureRenegotiation = true;
            }
            if (byArray2 != null) {
                securityParameters.secureRenegotiation = true;
                if (!Arrays.constantTimeAreEqual((byte[])byArray2, (byte[])TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                    throw new TlsFatalAlert(40);
                }
            }
        }
        this.tlsServer.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        boolean bl = TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.clientExtensions);
        if (this.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(this.clientExtensions);
            securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(this.clientExtensions);
            if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion3)) {
                TlsUtils.establishClientSigAlgs(securityParameters, this.clientExtensions);
            }
            securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(this.clientExtensions);
            this.tlsServer.processClientExtensions(this.clientExtensions);
        }
        this.resumedSession = this.establishSession(this.tlsServer.getSessionToResume(clientHello.getSessionID()));
        if (!this.resumedSession) {
            byArray = this.tlsServer.getNewSessionID();
            if (null == byArray) {
                byArray = TlsUtils.EMPTY_BYTES;
            }
            this.tlsSession = TlsUtils.importSession(byArray, null);
            this.sessionParameters = null;
            this.sessionMasterSecret = null;
        }
        securityParameters.sessionID = this.tlsSession.getSessionID();
        this.tlsServer.notifySession(this.tlsSession);
        TlsUtils.negotiatedVersionTLSServer(this.tlsServerContext);
        int n = this.tlsServer.shouldUseGMTUnixTime();
        securityParameters.serverRandom = TlsServerProtocol.createRandomBlock(n != 0, this.tlsServerContext);
        if (!protocolVersion.equals(ProtocolVersion.getLatestTLS(this.tlsServer.getProtocolVersions()))) {
            TlsUtils.writeDowngradeMarker(protocolVersion, securityParameters.getServerRandom());
        }
        int n2 = n = this.resumedSession ? this.sessionParameters.getCipherSuite() : this.tlsServer.getSelectedCipherSuite();
        if (!TlsUtils.isValidCipherSuiteSelection(this.offeredCipherSuites, n) || !TlsUtils.isValidVersionForCipherSuite(n, protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.negotiatedCipherSuite(securityParameters, n);
        this.tlsServerContext.setRSAPreMasterSecretVersion(protocolVersion2);
        Object object = this.resumedSession ? this.sessionParameters.readServerExtensions() : this.tlsServer.getServerExtensions();
        this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised((Hashtable)object);
        this.tlsServer.getServerExtensionsForConnection(this.serverExtensions);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            object = this.tlsServerContext.getSecurityParametersConnection();
            byte[] byArray3 = TlsUtils.concat(((SecurityParameters)object).getPeerVerifyData(), ((SecurityParameters)object).getLocalVerifyData());
            this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(byArray3));
        } else if (securityParameters.isSecureRenegotiation()) {
            boolean bl2;
            object = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo);
            boolean bl3 = bl2 = null == object;
            if (bl2) {
                this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (this.resumedSession) {
            if (!this.sessionParameters.isExtendedMasterSecret()) {
                throw new TlsFatalAlert(80);
            }
            if (!bl) {
                throw new TlsFatalAlert(40);
            }
            securityParameters.extendedMasterSecret = true;
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.serverExtensions);
        } else {
            boolean bl4 = securityParameters.extendedMasterSecret = bl && !protocolVersion.isSSL() && this.tlsServer.shouldUseExtendedMasterSecret();
            if (securityParameters.isExtendedMasterSecret()) {
                TlsExtensionsUtils.addExtendedMasterSecretExtension(this.serverExtensions);
            } else if (this.tlsServer.requiresExtendedMasterSecret()) {
                throw new TlsFatalAlert(40);
            }
        }
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        if (!this.serverExtensions.isEmpty()) {
            securityParameters.encryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(this.serverExtensions);
            securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(this.clientExtensions, this.serverExtensions, (short)80);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(this.serverExtensions);
            if (!this.resumedSession) {
                if (TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request_v2, (short)80)) {
                    securityParameters.statusRequestVersion = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80)) {
                    securityParameters.statusRequestVersion = 1;
                }
                this.expectSessionTicket = TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
            }
        }
        this.applyMaxFragmentLengthExtension(securityParameters.getMaxFragmentLength());
        return new ServerHello(protocolVersion, securityParameters.getServerRandom(), this.tlsSession.getSessionID(), securityParameters.getCipherSuite(), this.serverExtensions);
    }

    protected TlsContext getContext() {
        return this.tlsServerContext;
    }

    AbstractTlsContext getContextAdmin() {
        return this.tlsServerContext;
    }

    protected TlsPeer getPeer() {
        return this.tlsServer;
    }

    protected void handle13HandshakeMessage(short s, HandshakeMessageInput handshakeMessageInput) throws IOException {
        if (!this.isTLSv13ConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (this.resumedSession) {
            throw new TlsFatalAlert(80);
        }
        block0 : switch (s) {
            case 11: {
                switch (this.connection_state) {
                    case 20: {
                        this.receive13ClientCertificate(handshakeMessageInput);
                        this.connection_state = (short)15;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 15: {
                        this.receive13ClientCertificateVerify(handshakeMessageInput);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)17;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 1: {
                switch (this.connection_state) {
                    case 0: {
                        throw new TlsFatalAlert(80);
                    }
                    case 2: {
                        ClientHello clientHello = this.receiveClientHelloMessage(handshakeMessageInput);
                        this.connection_state = (short)3;
                        ServerHello serverHello = this.generate13ServerHello(clientHello, handshakeMessageInput, true);
                        this.sendServerHelloMessage(serverHello);
                        this.connection_state = (short)4;
                        this.send13ServerHelloCoda(serverHello, true);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 20: {
                        this.skip13ClientCertificate();
                    }
                    case 15: {
                        this.skip13ClientCertificateVerify();
                    }
                    case 17: {
                        this.receive13ClientFinished(handshakeMessageInput);
                        this.connection_state = (short)18;
                        this.recordStream.setIgnoreChangeCipherSpec(false);
                        this.recordStream.enablePendingCipherRead(false);
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 24: {
                this.receive13KeyUpdate(handshakeMessageInput);
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleHandshakeMessage(short s, HandshakeMessageInput handshakeMessageInput) throws IOException {
        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParameters();
        if (this.connection_state > 1 && TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            this.handle13HandshakeMessage(s, handshakeMessageInput);
            return;
        }
        if (!this.isLegacyConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (this.resumedSession) {
            if (s != 20 || this.connection_state != 20) {
                throw new TlsFatalAlert(10);
            }
            this.processFinishedMessage(handshakeMessageInput);
            this.connection_state = (short)18;
            this.completeHandshake();
            return;
        }
        block0 : switch (s) {
            case 1: {
                if (this.isApplicationDataReady()) {
                    if (!this.handleRenegotiation()) break;
                    this.connection_state = 0;
                }
                switch (this.connection_state) {
                    case 21: {
                        throw new TlsFatalAlert(80);
                    }
                    case 0: {
                        ClientHello clientHello = this.receiveClientHelloMessage(handshakeMessageInput);
                        this.connection_state = 1;
                        ServerHello serverHello = this.generateServerHello(clientHello, handshakeMessageInput);
                        this.handshakeHash.notifyPRFDetermined();
                        if (TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
                            this.handshakeHash.sealHashAlgorithms();
                            if (serverHello.isHelloRetryRequest()) {
                                TlsUtils.adjustTranscriptForRetry(this.handshakeHash);
                                this.sendServerHelloMessage(serverHello);
                                this.connection_state = (short)2;
                                this.sendChangeCipherSpecMessage();
                                break block0;
                            }
                            this.sendServerHelloMessage(serverHello);
                            this.connection_state = (short)4;
                            this.sendChangeCipherSpecMessage();
                            this.send13ServerHelloCoda(serverHello, false);
                            break block0;
                        }
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.sendServerHelloMessage(serverHello);
                        this.connection_state = (short)4;
                        if (this.resumedSession) {
                            securityParameters.masterSecret = this.sessionMasterSecret;
                            this.recordStream.setPendingCipher(TlsUtils.initCipher(this.tlsServerContext));
                            this.sendChangeCipherSpec();
                            this.sendFinishedMessage();
                            this.connection_state = (short)20;
                            break block0;
                        }
                        Vector vector = this.tlsServer.getServerSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                            this.connection_state = (short)6;
                        }
                        this.keyExchange = TlsUtils.initKeyExchangeServer(this.tlsServerContext, this.tlsServer);
                        TlsCredentials tlsCredentials = TlsUtils.establishServerCredentials(this.tlsServer);
                        Object object = null;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        if (null == tlsCredentials) {
                            this.keyExchange.skipServerCredentials();
                        } else {
                            this.keyExchange.processServerCredentials(tlsCredentials);
                            object = tlsCredentials.getCertificate();
                            this.sendCertificateMessage((Certificate)object, byteArrayOutputStream);
                            this.connection_state = (short)7;
                        }
                        securityParameters.tlsServerEndPoint = byteArrayOutputStream.toByteArray();
                        if (null == object || ((Certificate)object).isEmpty()) {
                            securityParameters.statusRequestVersion = 0;
                        }
                        if (securityParameters.getStatusRequestVersion() > 0 && (object = this.tlsServer.getCertificateStatus()) != null) {
                            this.sendCertificateStatusMessage((CertificateStatus)object);
                            this.connection_state = (short)8;
                        }
                        if ((object = (Object)this.keyExchange.generateServerKeyExchange()) != null) {
                            this.sendServerKeyExchangeMessage((byte[])object);
                            this.connection_state = (short)10;
                        }
                        if (null != tlsCredentials) {
                            this.certificateRequest = this.tlsServer.getCertificateRequest();
                            if (null == this.certificateRequest) {
                                if (!this.keyExchange.requiresCertificateVerify()) {
                                    throw new TlsFatalAlert(80);
                                }
                            } else {
                                if (TlsUtils.isTLSv12(this.tlsServerContext) != (this.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                                    throw new TlsFatalAlert(80);
                                }
                                this.certificateRequest = TlsUtils.validateCertificateRequest(this.certificateRequest, this.keyExchange);
                                TlsUtils.establishServerSigAlgs(securityParameters, this.certificateRequest);
                                TlsUtils.trackHashAlgorithms(this.handshakeHash, securityParameters.getServerSigAlgs());
                                this.sendCertificateRequestMessage(this.certificateRequest);
                                this.connection_state = (short)11;
                            }
                        }
                        this.sendServerHelloDoneMessage();
                        this.connection_state = (short)12;
                        boolean bl = false;
                        TlsUtils.sealHandshakeHash(this.tlsServerContext, this.handshakeHash, bl);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 23: {
                switch (this.connection_state) {
                    case 12: {
                        this.tlsServer.processClientSupplementalData(TlsServerProtocol.readSupplementalDataMessage(handshakeMessageInput));
                        this.connection_state = (short)14;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 11: {
                switch (this.connection_state) {
                    case 12: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 14: {
                        this.receiveCertificateMessage(handshakeMessageInput);
                        this.connection_state = (short)15;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 16: {
                switch (this.connection_state) {
                    case 12: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 14: {
                        if (null == this.certificateRequest) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            if (TlsUtils.isTLSv12(this.tlsServerContext)) {
                                throw new TlsFatalAlert(10);
                            }
                            if (TlsUtils.isSSL(this.tlsServerContext)) {
                                throw new TlsFatalAlert(10);
                            }
                            this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                        }
                    }
                    case 15: {
                        this.receiveClientKeyExchangeMessage(handshakeMessageInput);
                        this.connection_state = (short)16;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 16: {
                        if (!this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateVerifyMessage(handshakeMessageInput);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)17;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 16: {
                        if (this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 17: {
                        this.processFinishedMessage(handshakeMessageInput);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)18;
                        if (this.expectSessionTicket) {
                            this.sendNewSessionTicketMessage(this.tlsServer.getNewSessionTicket());
                            this.connection_state = (short)19;
                        }
                        this.sendChangeCipherSpec();
                        this.sendFinishedMessage();
                        this.connection_state = (short)20;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleAlertWarningMessage(short s) throws IOException {
        if (41 == s && null != this.certificateRequest && TlsUtils.isSSL(this.tlsServerContext)) {
            switch (this.connection_state) {
                case 12: {
                    this.tlsServer.processClientSupplementalData(null);
                }
                case 14: {
                    this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                    this.connection_state = (short)15;
                    return;
                }
            }
        }
        super.handleAlertWarningMessage(s);
    }

    protected void notifyClientCertificate(Certificate certificate) throws IOException {
        if (null == this.certificateRequest) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.processClientCertificate(this.tlsServerContext, certificate, this.keyExchange, this.tlsServer);
    }

    protected void receive13ClientCertificate(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (null == this.certificateRequest) {
            throw new TlsFatalAlert(10);
        }
        Certificate.ParseOptions parseOptions = new Certificate.ParseOptions().setMaxChainLength(this.tlsServer.getMaxCertificateChainLength());
        Certificate certificate = Certificate.parse(parseOptions, this.tlsServerContext, byteArrayInputStream, null);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(certificate);
    }

    protected void receive13ClientCertificateVerify(ByteArrayInputStream byteArrayInputStream) throws IOException {
        Certificate certificate = this.tlsServerContext.getSecurityParametersHandshake().getPeerCertificate();
        if (null == certificate || certificate.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        DigitallySigned digitallySigned = DigitallySigned.parse(this.tlsServerContext, byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        TlsUtils.verify13CertificateVerifyClient(this.tlsServerContext, this.certificateRequest, digitallySigned, this.handshakeHash);
    }

    protected void receive13ClientFinished(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.process13FinishedMessage(byteArrayInputStream);
    }

    protected void receiveCertificateMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (null == this.certificateRequest) {
            throw new TlsFatalAlert(10);
        }
        Certificate.ParseOptions parseOptions = new Certificate.ParseOptions().setMaxChainLength(this.tlsServer.getMaxCertificateChainLength());
        Certificate certificate = Certificate.parse(parseOptions, this.tlsServerContext, byteArrayInputStream, null);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(certificate);
    }

    protected void receiveCertificateVerifyMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        DigitallySigned digitallySigned = DigitallySigned.parse(this.tlsServerContext, byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        TlsUtils.verifyCertificateVerifyClient(this.tlsServerContext, this.certificateRequest, digitallySigned, this.handshakeHash);
        this.handshakeHash = this.handshakeHash.stopTracking();
    }

    protected ClientHello receiveClientHelloMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        return ClientHello.parse(byteArrayInputStream, null);
    }

    protected void receiveClientKeyExchangeMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.keyExchange.processClientKeyExchange(byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        boolean bl = TlsUtils.isSSL(this.tlsServerContext);
        if (bl) {
            TlsServerProtocol.establishMasterSecret(this.tlsServerContext, this.keyExchange);
        }
        this.tlsServerContext.getSecurityParametersHandshake().sessionHash = TlsUtils.getCurrentPRFHash(this.handshakeHash);
        if (!bl) {
            TlsServerProtocol.establishMasterSecret(this.tlsServerContext, this.keyExchange);
        }
        this.recordStream.setPendingCipher(TlsUtils.initCipher(this.tlsServerContext));
        if (!this.expectCertificateVerifyMessage()) {
            this.handshakeHash = this.handshakeHash.stopTracking();
        }
    }

    protected void send13EncryptedExtensionsMessage(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsServerProtocol.writeExtensionsData(hashtable);
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(8);
        TlsUtils.writeOpaque16(byArray, handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void send13ServerHelloCoda(ServerHello serverHello, boolean bl) throws IOException {
        Object object;
        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
        byte[] byArray = TlsUtils.getCurrentPRFHash(this.handshakeHash);
        TlsUtils.establish13PhaseHandshake(this.tlsServerContext, byArray, this.recordStream);
        this.recordStream.enablePendingCipherWrite();
        this.recordStream.enablePendingCipherRead(true);
        this.send13EncryptedExtensionsMessage(this.serverExtensions);
        this.connection_state = (short)5;
        if (!this.selectedPSK13) {
            this.certificateRequest = this.tlsServer.getCertificateRequest();
            if (null != this.certificateRequest) {
                if (!this.certificateRequest.hasCertificateRequestContext(TlsUtils.EMPTY_BYTES)) {
                    throw new TlsFatalAlert(80);
                }
                TlsUtils.establishServerSigAlgs(securityParameters, this.certificateRequest);
                this.sendCertificateRequestMessage(this.certificateRequest);
                this.connection_state = (short)11;
            }
            if (null == (object = (Object)TlsUtils.establish13ServerCredentials(this.tlsServer))) {
                throw new TlsFatalAlert(80);
            }
            Object object2 = object.getCertificate();
            this.send13CertificateMessage((Certificate)object2);
            securityParameters.tlsServerEndPoint = null;
            this.connection_state = (short)7;
            object2 = TlsUtils.generate13CertificateVerify(this.tlsServerContext, (TlsCredentialedSigner)object, this.handshakeHash);
            this.send13CertificateVerifyMessage((DigitallySigned)object2);
            this.connection_state = (short)17;
        }
        this.send13FinishedMessage();
        this.connection_state = (short)20;
        object = TlsUtils.getCurrentPRFHash(this.handshakeHash);
        TlsUtils.establish13PhaseApplication(this.tlsServerContext, (byte[])object, this.recordStream);
        this.recordStream.enablePendingCipherWrite();
    }

    protected void sendCertificateRequestMessage(CertificateRequest certificateRequest) throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(13);
        certificateRequest.encode(this.tlsServerContext, handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendCertificateStatusMessage(CertificateStatus certificateStatus) throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(22);
        certificateStatus.encode(handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendHelloRequestMessage() throws IOException {
        HandshakeMessageOutput.send(this, (short)0, TlsUtils.EMPTY_BYTES);
    }

    protected void sendNewSessionTicketMessage(NewSessionTicket newSessionTicket) throws IOException {
        if (newSessionTicket == null) {
            throw new TlsFatalAlert(80);
        }
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(4);
        newSessionTicket.encode(handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendServerHelloDoneMessage() throws IOException {
        HandshakeMessageOutput.send(this, (short)14, TlsUtils.EMPTY_BYTES);
    }

    protected void sendServerHelloMessage(ServerHello serverHello) throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(2);
        serverHello.encode(this.tlsServerContext, handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendServerKeyExchangeMessage(byte[] byArray) throws IOException {
        HandshakeMessageOutput.send(this, (short)12, byArray);
    }

    protected void skip13ClientCertificate() throws IOException {
        if (null != this.certificateRequest) {
            throw new TlsFatalAlert(10);
        }
    }

    protected void skip13ClientCertificateVerify() throws IOException {
        if (this.expectCertificateVerifyMessage()) {
            throw new TlsFatalAlert(10);
        }
    }
}

